import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
    timeZone: Joi.string().required(),
});

const controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;
        const { timeZone } = req.body;

        const timeZoneOfCompany = await db.MetaData.findOne({name:"timeZone", companyId})
        console.log({timeZoneOfCompany})

        if(timeZoneOfCompany) await db.MetaData.updateOne({name: "timeZone", companyId },{ value: timeZone })
        else await db.MetaData.create({name: "timeZone", companyId, value: timeZone })
        
        return res.status(200).send({ Success: true, message: 'Timezone updated successfully!' })
        
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), jwtStrategy, permission('Settings','Write'),validateBody(validator), controller);
export default apiRouter;