import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import restrictFeature from '../../middlewares/featureBlocker';

const validator = Joi.object().keys({
    smtpHost: Joi.string(),
    smtpPort: Joi.string(),
    smtpPassword: Joi.string(),
    smtpUsername: Joi.string(),
    smtpFrom: Joi.string(),
    smtpTo: Joi.string(),
    mailSmtp: Joi.boolean()
});

const controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;
        console.log("companyId", companyId)
        const { smtpHost, smtpPort, smtpPassword, smtpUsername, smtpFrom, smtpTo, mailSmtp } = req.body;
        const azureSmtp = await db.SmtpCred.findOne({ companyId, deletedAt: null });
        if (azureSmtp) {
            throw new RequestError('Azure SMTP has already been configured for this company.', 400);
        }
        if(!mailSmtp){
            await db.MetaData.findOneAndUpdate({name: "mailSmtp", companyId },{ value: false},{ upsert: true, new: true, setDefaultsOnInsert: true })
            return res.status(200).send({ Success: true, message: 'Smtp Configuration Updated Successfully!' })
        }
        else{
            const smtpCredentials = {smtpHost, smtpPort, smtpPassword, smtpUsername, smtpFrom, smtpTo, mailSmtp};
            const pendingQueries = [];
            
            Object.entries(smtpCredentials).forEach(([name, value]) => {
                console.log({name, value});
                const metaData = db.MetaData.findOneAndUpdate({ name, companyId }, { value }, { upsert: true, new: true, setDefaultsOnInsert: true });
                pendingQueries.push(metaData);
            })
            await Promise.all(pendingQueries);
            return res.status(200).send({ Success: true, message: 'Smtp Configuration Updated Successfully!' })
        }
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), jwtStrategy, restrictFeature("TPIR-CSTM"), permission('Settings','Write'),validateBody(validator), controller);
export default apiRouter;