import express from 'express';
import { jwtStrategy, checkCompanyValidityStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

/**
 * @api {get} /api/v1/smartBanners/get-banner-status get-banner-status
 * @apiName get-banner-status
 * @apiGroup smartBanners
 * @apiDescription Returns whether the BannerMessage meta is enabled for the company
 *
 * @apiVersion 1.0.0
 *
 * @apiSuccess {Boolean} success true
 * @apiSuccess {Boolean} status  true if enabled else false
 *
 * @apiSuccessExample Success-Response:
 *  HTTP/1.1 200 OK
 *  {
 *    "success": true,
 *    "status": true
 *  }
 */

const controller = async (req, res, next) => {
	try {
		const companyId = req.user.companyId;
		const meta = await db.MetaData.findOne({ companyId, name: 'BannerMessage', deletedAt: null });
		const status = !!meta; // true only if exists and not soft-deleted
        console.log("Banner status:", status);
		return res.status(200).send({ success: true, status });
	} catch (error) {
		next(error);
	}
};

const apiRouter = express.Router();
apiRouter.route('/')
	.get(htmlsanitize(), jwtStrategy, checkCompanyValidityStrategy, permission('Settings','Read'), controller);

export default apiRouter;

