import Joi from 'joi';
import express from 'express';
import { jwtStrategy } from '../../middlewares/strategy.js';
import { permission } from '../../middlewares/permission.js';

/**
 * @api {delete} /api/smtp/:id Delete SMTP Configuration
 * @apiName DeleteSmtpConfiguration
 * @apiGroup SMTP
 * @apiPermission admin
 *
 * @apiHeader {String} Authorization Bearer token.
 * @apiParam {String} id The ID of the SMTP credential to delete.
 *
 * @apiSuccess {Boolean} success True.
 * @apiSuccess {String} message Success message.
 *
 * @apiError (Not Found 404) {String} message Error message for non-existent configuration.
 */
const controller = async (req, res, next) => {
    try {
        const { id } = req.params;
        console.log('Received request to delete SMTP configuration with ID:', id);
        const { companyId } = req.user;
        console.log('Received request to delete SMTP configuration with ID:', id);
        const smtpCred = await db.SmtpCred.findOne({
            _id: id,
            companyId,
            deletedAt: null,
        });
        console.log('Found SMTP configuration:', smtpCred);
        if (!smtpCred) {
            throw new RequestError('SMTP configuration not found or already deleted.');
        }

        smtpCred.deletedAt = new Date();
        await smtpCred.save();
        
        await db.MetaData.findOneAndUpdate(
            { name: "mailSmtp", companyId },
            { value: false, deletedAt: null },
            { upsert: true, new: true, setDefaultsOnInsert: true }
        );

        console.log('SMTP configuration deleted successfully and moved to default:', smtpCred._id);

        return res.status(200).json({
            success: true,
            message: 'SMTP configuration deleted successfully.',
        });
    } catch (error) {
        next(error);
    }
};

const apiRouter = express.Router();
apiRouter.route('/:id').delete(jwtStrategy, permission(''), controller);

export default apiRouter;
