import Joi from 'joi';
import express from 'express';

import { randomString } from '../../functions';
import userActivity from '../../service/audit-log';
import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';
import { validateBody } from '../../middlewares/validator';


const controller = async (req, res, next) => {
    try {
        // const { name, headerContent, bodyContent, footerContent, bgColor, logo } = req.body;
        // const companyId = req.user.companyId;
        const templates = [
          {
            name: 'Acknowledgment E-Mail',
            logo: 'Tpirlogo.png',
            bodyContent:
              '<p>Dear ${userName},</p><p><br>Thank You for reporting a suspicious email.</p><p>&nbsp;</p><p>The email was received at <strong>${date}</strong>.From: <strong>${from}</strong><br>Subject: <strong>${subject}</strong><br>&nbsp;</p><p><br>It has been forwaded to SOC Team for further review. Your actions are helping the organization to keep the network and our data safe!<br>&nbsp;</p><p><br>Thanks,<br>TPIR Team</p>',
            headerContent: '<h2><strong>Mail Reported Successfully!</strong></h2><p>The mail will be reviewed by the SOC team.</p>',
            footerContent:
              '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
            bgColor: '#2c5596',
            companyId: null,
            description: 'This email is sent when a user reports a suspicious email.',
          },
          {
            name: 'SOC Notification E-mail',
            logo: 'Tpirlogo.png',
            description: 'This email is sent to SOC when a user reports a suspicious email.',
            bodyContent:
              '<p>Hi ,<br>Kindly review a mail reported by an employee.</p><p>&nbsp;</p><p>The email was received at <strong>${date}.</strong><br>To: <strong>${to}</strong><br>From: <strong>${from}</strong><br>Subject: <strong>${subject}</strong></p><p><br><br>Please review the mail and take appropiate actions from dashboard. Please find attached header and body.</p><p><br><br>Thanks,<br>TPIR Team</p>',
            headerContent: '<h2><strong>Suspicious Mail Reported&nbsp;</strong></h2><p>An employee discovered a suspicious mail and reported it.</p>',
            footerContent:
              '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
            bgColor: '#2c5596',
            companyId: null,
          },
          {
            name: 'Admin Action E-mail',
            logo: 'Tpirlogo.png',
            description: 'This email is sent when admin takes a action on email reported by user.',
            bodyContent:
              "<p>Dear ${name},&nbsp;</p><p>Thank you for promptly bringing the email to our attention. We have analyzed the mail and result can be found below-</p><p>&nbsp;</p><p>&nbsp;Result : <strong>${status}&nbsp;</strong></p><p>&nbsp;</p><p>${safeMessage}='The original email you reported can be found as an attachment in this email.</p><p>We thank you for your contributions in developing a cyber secure work environment.'</p><p>${spamMessage}='It could be an advertisement or uninteresting junk mail and it is recommended to ignore such mails. Necessary action is being taken SOC team to block the sender and no further action is required from your end.</p><p>We thank you for your contributions in developing a cyber secure work environment.'</p><p>${threatMessage}='Necessary preventive action is also being taken by SOC team to block the threat. The email is already deleted from your inbox and needs no further action from your end.</p><p>We thank you for your contributions in developing a cyber secure work environment.'</p><p><strong>Reported Mail Details :&nbsp;</strong></p><p>The email was received at <strong>${date}</strong>.&nbsp;</p><p>From: <strong>${from}</strong>&nbsp;</p><p>Subject: <strong>${subject}</strong>&nbsp;</p><p>&nbsp;</p><p>Thanks, TPIR Team</p>",
            headerContent: '<h2>Mail Report&nbsp;</h2><p>The mail has been reviewed by the SOC team.</p>',
            footerContent:
              '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
            bgColor: '#2c5596',
            companyId: null,
          },
          {
            name: 'Result Notification Other Reporters E-mail',
            logo: 'Tpirlogo.png',
            description: 'This email is sent to other reporters when an admin takes an action on a reported mail.',
            bodyContent:
              '<p>Dear ${name},&nbsp;</p><p>A mail was reported by an employee, Our SOC Team promptly investigated the matter.&nbsp;</p><p>After careful assessment, the reported email was found to be <strong>${result}</strong> and has been <strong>${status}.</strong>&nbsp;</p><p>&nbsp;</p><p><strong>Reported Mail Details :&nbsp;</strong></p><p>Date: <strong>${date}</strong>.&nbsp;</p><p>From: <strong>${from}</strong>&nbsp;</p><p>Subject: <strong>${subject}</strong>&nbsp;</p><p>&nbsp;</p><p>Thanks, TPIR Team</p>',
            headerContent: '<h2>Suspicious Mail ${status}</h2><p>A suspicious mail was ${status} by SOC Team.</p>',
            footerContent:
              '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
            bgColor: '#2c5596',
            companyId: null,
          },
        ];

        await db.Template.insertMany(templates);  

      
        res.status(200).json({ 
            success: true, 
            message: 'template added successfully'
        })

    } catch (err) {
        console.log(err);
        next(err)
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, checkCompanyValidityStrategy, controller);
export default apiRouter;
