import Joi, { custom } from 'joi';
import express from 'express';

import { randomString } from '../../functions';
import userActivity from '../../service/audit-log';
import { jwtStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';
import { validateBody } from '../../middlewares/validator';
import restrictFeature from '../../middlewares/featureBlocker';


const controller = async (req, res, next) => {
    try {
        const { templateName } = req.query
        let companyId = req.user.companyId;
        let template = ''
       
        const customTemplate = await db.Template.findOne({name: templateName, companyId})
        if(customTemplate){
            template = customTemplate
        }
        else{
            const defaultTemplate = await db.Template.findOne({name: templateName, companyId: null })
            if(!defaultTemplate) throw new RequestError('Default Template Not Found!');
            template = defaultTemplate
        }


        res.status(200).json({ 
            success: true,
            template 
        })

    } catch (err) {
        console.log(err);
        next(err)
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, restrictFeature('TPIR-CET'), controller);
export default apiRouter;