import Joi from 'joi';
import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';
import { validateBody } from '../../middlewares/validator';
import processGroups from '../../service/process-groups';

const validator = Joi.object().keys({
    domainId: Joi.string().hex().length(24).required(),
    groupName: Joi.string().optional()

});

const controller = async (req, res, next) => {
    try {
        const { domainId, groupName = null } = req.body
        const companyId = req.user.companyId;

        let domain = await db.Domain.findOne({
            _id: domainId,
            companyId,
            deletedAt: null
        });       

        if(!domain) throw new RequestError('Domain Not Found!')

        if(domain && !domain.isVerified) throw new RequestError('Domain is not verified', 400)
        if(domain && domain.isVerified && !domain.isCredential) throw new RequestError('Credentials are not uploaded', 400)
        const groups = await processGroups.process(companyId, domainId, domain.domainType, groupName)

        res.status(200).json({ success: true, groups });
    } catch (err) {
        console.log(err);
        next(err)
    }
}
const apiRouter = express.Router();
apiRouter.route('/').post(jwtStrategy, permission('Domain','Read'), validateBody(validator), controller);
export default apiRouter;