import Joi from 'joi';
import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';

const validator = Joi.object().keys({
    action: Joi.string().required(),
    selectedUsers: Joi.array().required()
});



const controller = async (req, res, next) => {
    try {
        const { action, selectedUsers } = req.body;
        const companyId = req.user.companyId;

        if(action == 'activate') {
            const activeUsers = await db.User.countDocuments({ deletedAt: null, isActive: true, companyId });
            const userLimit = await db.MetaData.findOne({ name: "userLimit", companyId })

            if(!(+userLimit.value > activeUsers)) throw new RequestError(`User Limit Exceeded! Only ${+userLimit.value} user(s) can be activated as per your license!`,403 ); 
            
            let usersThatCanbeActivatedCount = +userLimit.value - activeUsers
            console.log({usersThatCanbeActivatedCount})

            if(usersThatCanbeActivatedCount > 0) {
                let usersActivationArray = selectedUsers.slice(0,usersThatCanbeActivatedCount) 
                await db.User.updateMany({_id: { $in: usersActivationArray }}, {$set: {isActive: true}})
            }
            
        }
        if(action == 'deactivate') await db.User.updateMany({_id: { $in: selectedUsers }}, {$set: {isActive: false}})
        if(action == 'delete') await db.User.updateMany({_id: { $in: selectedUsers }}, {$set: {
            isActive: false,
            companyId: null,
            domainId: null,
            groupId: null,
            groupName: null,
            subDomainGroupId: null,
            isActive: false,
            deletedAt: new Date()
        }})


        return res.status(200).send({ Success: true })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(jwtStrategy, permission('Users','Write'), validateBody(validator), controller);
export default apiRouter;