import Joi from 'joi';
import express from 'express';

import { permission } from '../../middlewares/permission';
import { checkTaConnectionStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';

const validator = Joi.object().keys({
    userId: Joi.string().hex().length(24).required()
});


/**
 * @api {post} /api/v1/users/user-enable-disable user-enable-disable
 * @apiName user-enable-disable
 * @apiGroup users
 * @apiDescription Enabling or disabling a particular user's mailbox check
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}    userId      id of users has to be synced
 * 
 * @apiSuccess {Boolean}  Status      true
 * @apiSuccess {Array}    Message     "User deleted successfully"
 * 
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *      {
 *          "Status": true,
 *          "Message": "User deleted successfully"
 *      }
 * 
 * @apiError (400) {Boolean} success             false
 * @apiError (400) {Array}   messages            "Invalid user recieved"
 * 
 * @apiErrorExample Error-Response:
 *       HTTP/1.1 400 Not Found
 *      {
 *      "success":   false,
 *      "messages" : "Invalid user recieved"
 *      }
 * 
 */


const controller = async (req, res, next) => {
    try {
        const { userId } = req.query;
        let user = await db.User.findOne({
            _id: userId,
            deletedAt: null
        })
        if(!user){
            throw new RequestError('Invalid user recieved');
        }
        await db.User.deleteOne({
            _id: user._id
        })
        
        return res.status(200).send({ Success: true, message: 'User deleted successfully' })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').delete(jwtStrategy, permission('Users','Delete'), checkTaConnectionStrategy, validateBody(validator), controller);
export default apiRouter;