import Joi from "joi";
import express from "express";
import schedule from "node-schedule";

import { checkTaConnectionStrategy, jwtStrategy } from "../../middlewares/strategy";
import { validateBody } from "../../middlewares/validator";
import { permission } from "../../middlewares/permission";
import processUser from "../../service/process-user";
import { sanitize } from "../../middlewares/sanitizer";
import { htmlsanitize } from "../../middlewares/sanitizeHtml";
import credentials from "../../service/credentials";
import axios from "axios";

const validator = Joi.object().keys({
  domainId: Joi.string().hex().length(24).required(),
  minute: Joi.number().required(),
  hour: Joi.number().required(),
  isActive: Joi.boolean().required(),
  timeZone: Joi.string().required(),
  days: Joi.array().required(),
});

// Mapping object for day names to numeric values
const dayMapping = {
  All: 0,
  Monday: 1,
  Tuesday: 2,
  Wednesday: 3,
  Thursday: 4,
  Friday: 5,
  Saturday: 6,
  Sunday: 0,
};

const controller = async (req, res, next) => {
  const { domainId, isActive, days, hour, minute, timeZone } = req.body;
  try {
    // const domain = await db.Domain.findOne({_id: domainId, deletedAt: null});
    // if (domain) var companyId = domain["companyId"];
    // if (!domain)
    //   throw new RequestError(
    //     "Domain does not exist or wrong domain id passed!",
    //     404
    //   );
    // if (domain && !domain.isVerified)
    //   throw new RequestError("Domain is not verified", 400);
    // if (domain && domain.isVerified && !domain.isCredential)
    //   throw new RequestError("Credentials are not uploaded", 400);
    // if (
    //   domain &&
    //   domain.isVerified &&
    //   domain.isCredential &&
    //   domain.isSyncingUser
    // )
    //   throw new RequestError(
    //     `Syncing Already in Progress for ${domain.domainName}. Kindly wait until syncing is completed!`,
    //     400
    //   );
    // await db.Domain.updateOne(
    //   { _id: domainId },
    //   {
    //     isScheduledSyncing: {
    //       isActive,
    //       daysOfWeek: days,
    //       hour: hour,
    //       minute: minute,
    //       timeZone: timeZone,
    //     },
    //   }
    // );

    // if (!isActive) return res.status(200).send({ success: true });

    // const transformedDays = days
    //   .filter((day) => day !== "All")
    //   .map((day) => dayMapping[day]);
    // console.log({ transformedDays });

    // const rule = new schedule.RecurrenceRule();
    // rule.hour = hour;
    // rule.minute = minute;
    // rule.dayOfWeek = transformedDays;
    // rule.tz = timeZone;

    // const scheduledJob = schedule.scheduleJob(domainId, rule, async () => {
    //   let deactivateUsers = await db.User.updateMany(
    //     { domainId, companyId, userId: { $ne: null } },
    //     { $set: { deletedAt: new Date() } }
    //   );
    //   if (domain.domainType == "Gsuite" || domain.domainType == "Outlook") {
    //     await db.Domain.updateOne(
    //       {
    //         _id: domainId,
    //       },
    //       {
    //         isSyncingUser: true,
    //         syncStartAt: new Date(),
    //       }
    //     );
    //     const creds = await credentials.getCredentials(companyId, domainId);
    //     // console.log("credssssssssssssssssssssssss", creds);
    //     let subDomainGroupsFromDb = await db.SubDomainGroup.find({ domainId });
    //     let subDomainGroups = subDomainGroupsFromDb.map((val) => {
    //       return val.groupName;
    //     });
    //     let groups = await db.UserGroup.find({ domainId });

    //     if (groups.length) {
    //       for (const group of groups) {
    //         await processUser.process(
    //           companyId,
    //           domain._id,
    //           domain.domainName,
    //           subDomainGroups,
    //           domain.domainType,
    //           false,
    //           domain.domainTypeForOutlook == "EXCHANGE",
    //           group.value,
    //           group.label,
    //           creds
    //         );
    //       }
    //     } else {
    //       await processUser.process(
    //         companyId,
    //         domain._id,
    //         domain.domainName,
    //         subDomainGroups,
    //         domain.domainType,
    //         false,
    //         domain.domainTypeForOutlook == "EXCHANGE",
    //         null,
    //         null,
    //         creds
    //       );
    //     }
    //   } else {
    //     await db.Domain.updateOne(
    //       {
    //         _id: domainId,
    //       },
    //       {
    //         isSyncingUser: false,
    //         isSyncingUserError: true,
    //         isSyncingUserErrorFile: "Domain type not define",
    //       }
    //     );
    //     throw new RequestError("Domain type not define");
    //   }
    // });
    res.status(200).send({ success: true });
  } catch (error) {
    await db.Domain.updateOne({
      _id: domainId
    },{
      isSyncingUser: false,
      isSyncingUserError: true,
      isSyncingUserErrorFile: JSON.stringify(error)
    });
    console.log("error", error);
    next(error);
  }
};

const apiRouter = express.Router();
apiRouter
  .route("/")
  .post(
    htmlsanitize(),
    jwtStrategy,
    checkTaConnectionStrategy,
    permission("Users", "Write"),
    validateBody(validator),
    controller
  );
export default apiRouter;
