import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { cleanText } from '../../functions';

import whatsApp from '../../service/send-whatsapp-message';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import restrictFeature from '../../middlewares/featureBlocker';

const validator = Joi.object().keys({
    messageId: Joi.string().hex().length(24).required(),
    action: Joi.string().required()
});


let controller = async (req, res, next) => {
    try {
        const { messageId, action } = req.body
        const reportedMessage = await db.whatsapp.findById(messageId);
        reportedMessage.status = action
        await reportedMessage.save()

        let message = cleanText(reportedMessage.message)
        const preferedLanguage = await db.Company.findOne({ _id: reportedMessage.companyId }).select("whatsappLanguage");
        whatsApp.sendMessage(reportedMessage.phoneNumberId, reportedMessage.ticketId, reportedMessage.phoneNumber, message, action , 'action', preferedLanguage?.whatsappLanguage)
        .then((result) => { console.log("Sent Message to User ----->", result)})
        .catch((error) => { console.error("Error sending message to user",error.response.data)});

        return res.status(201).send({ success: true, Message: "Successfully Updated Status!" })

    } catch (error) { 
        console.log(error);
        return next(new RequestError(error))
    }
}
const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(),  validateBody(validator),  jwtStrategy, restrictFeature("TPIR-WA"), checkCompanyValidityStrategy, controller);
export default apiRouter;

