import Joi from 'joi';
import express from 'express';

import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import restrictFeature from '../../middlewares/featureBlocker';

const validator = Joi.object().keys({
    action: Joi.string().required(),
    selectedUsers: Joi.array().required()
});

const controller = async (req, res, next) => {
    try {
        const { action, selectedUsers } = req.body;
        const companyId = req.user.companyId;

        if(action == 'activate') {
            const activeUsers = await db.User.countDocuments({ deletedAt: null, isActiveMessenger: true, companyId });
            const userLimit = await db.MetaData.findOne({ name: "userLimitMessenger", companyId })

            if(!(+userLimit.value > activeUsers)) throw new RequestError(`User Limit for messenger exceeded! Only ${+userLimit.value} user(s) can be activated as per your license!`,403 ); 
            
            let usersThatCanbeActivatedCount = +userLimit.value - activeUsers
            console.log({usersThatCanbeActivatedCount})

            if(usersThatCanbeActivatedCount > 0) {
                let usersActivationArray = selectedUsers.slice(0,usersThatCanbeActivatedCount) 
                await db.User.updateMany({_id: { $in: usersActivationArray }}, {$set: {isActiveMessenger: true}})
            }
            
        }
        if(action == 'deactivate') await db.User.updateMany({_id: { $in: selectedUsers }}, {$set: {isActiveMessenger: false}})
        if(action == 'delete') await db.User.updateMany({_id: { $in: selectedUsers }}, {$set: {
            isActive: false,
            companyId: null,
            domainId: null,
            groupId: null,
            groupName: null,
            phoneNumber: null,
            subDomainGroupId: null,
            isActive: false,
            isActiveMessenger: false,
            deletedAt: new Date()
        }})


        return res.status(200).send({ Success: true })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(jwtStrategy, restrictFeature("TPIR-WA"), checkCompanyValidityStrategy, permission('Users','Write'), validateBody(validator), controller);
export default apiRouter;