import Joi from 'joi';
import express from 'express';

import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import restrictFeature from '../../middlewares/featureBlocker';

const validator = Joi.object().keys({
    page: Joi.number().min(0).required(),
    limit: Joi.number().min(1).required(),
    domains: Joi.array().optional(),
    groups: Joi.array().optional(),
    subDomainGroups: Joi.array().optional(),
    search: Joi.string().optional().allow(null).empty(''),
    status: Joi.string().optional().allow(null).empty(''),
});



const controller = async (req, res, next) => {
    try {
        const { domains, subDomainGroups, groups, page, limit, search = '', status = false } = req.query;
        const companyId = req.user.companyId;
        const condition = { companyId, deletedAt: null, phoneNumber: {$ne: null} };
        
        if(domains && domains.length) {
            const selectedDomains = await db.Domain.find({ companyId, domainName: {$in: domains?.map(domain=>domain.split('#')[0])},  _id: {$in: domains?.map(domain=>domain.split('#')[1])}, deletedAt: null},{_id:1})
            condition['domainId'] = {$in: selectedDomains.map((domain)=> domain._id) };
        }

        if(groups && groups.length) {
            const selectedGroups = await db.UserGroup.find({ companyId ,label: {$in: groups}},{_id:0, value:1})
            condition['groupId'] = {$in: selectedGroups.map((group)=> group.value) };
        }

        if(subDomainGroups && subDomainGroups.length){
            const selectedSubDomainGroups = await db.SubDomainGroup.find({ companyId, groupName:{$in: subDomainGroups}},{_id:1}) 
            condition['subDomainGroupId'] = {$in: selectedSubDomainGroups.map((subDomainGroup)=> subDomainGroup._id)}
        } 
        
        
        if(status!='-1') status =='Active' ? condition['isActiveMessenger'] = true : condition["isActiveMessenger"] = false
        if(search && search.length){
            const regex = new RegExp(search, "i");
            condition['$or'] = [
                { name: regex }, 
                // { phoneNumber: search }
            ]
        }
        let count = await db.User.countDocuments(condition)
        let users = await db.User.find(condition)
        .skip((page-1)*limit)
        .limit(limit)
        return res.status(200).send({ Success: true, users, count })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, restrictFeature("TPIR-WA"), permission('Users','Read'), validateBody(validator), controller);
export default apiRouter;