import Joi from "joi";
import express from "express";
import fs from "fs";
import path from "path";

import { sanitize } from "../../middlewares/sanitizer";
import { validateBody } from '../../middlewares/validator';
import { checkCompanyValidityStrategy, jwtStrategy } from "../../middlewares/strategy";
import { htmlsanitize } from "../../middlewares/sanitizeHtml";
import restrictFeature from '../../middlewares/featureBlocker'

const validator = Joi.object({
    reportedMessageId: Joi.string().hex().length(24).required(),
});

let controller = async (req, res, next) => {
    try {
        const { reportedMessageId } = req.query;
        const companyId = req.user.companyId;

        let message = await db.whatsapp.findOne({
            _id: reportedMessageId,
            companyId,
            deletedAt: null,
        });

        if (message && message.fileName) {
            const filePath = path.join(appRoot, 'Content', 'whatsappImages', message.fileName);
            console.log({filePath})
            // Read the image file
            fs.readFile(filePath, (err, data) => {
                if (err) {
                    return res.status(200).json({ success: 'true', message });
                }

                // Convert the image to base64
                const base64Image = `data:image/jpeg;base64,${data.toString('base64')}`;

                message = { ...message.toObject(), image:base64Image };

                // Send the base64 string as the response
                return res.status(200).json({ message });
            });
        } else {
            // If no image file, just return the message object
            return res.status(200).json({ success: true, message });
        }
    } catch (err) {
        console.log(err);
        next(err);
    }
};

const apiRouter = express.Router();
apiRouter
    .route("/")
    .get(htmlsanitize(), validateBody(validator), jwtStrategy, restrictFeature("TPIR-WA"), controller);

export default apiRouter;
