import express from 'express';

import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';
import restrictFeature from '../../middlewares/featureBlocker';


const controller = async (req, res, next) => {
    try {
        const {  page = 1, limit = 10, search = "" } = req.query;

        const companyId = req.user.companyId;
        let condition = {
            companyId,
            deletedAt: null
        }

        if(search && search.length){
            const regex = new RegExp(search, "i");
            condition['$or'] = [
                { from: regex }, 
                { sender: regex }, 
            ]
        }
        const count = await db.whatsapp.countDocuments(condition)
        const messages = await db.whatsapp.find(condition).sort({'createdAt': -1})
        .skip((page-1)*limit)
        .limit(limit)

        
        res.status(200).json({ success: true, messages, count });
    } catch (err) {
        console.log(err);
        next(err)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, restrictFeature("TPIR-WA"), controller);
export default apiRouter;