import Joi from "joi";
import express from "express";
import fs from "fs";
import path from "path";
import multer from "multer";
import csv from "csv-parser";


import { sanitize } from "../../middlewares/sanitizer";
import { validateBody } from '../../middlewares/validator';
import { jwtStrategy } from "../../middlewares/strategy";
import { htmlsanitize } from "../../middlewares/sanitizeHtml";
import { permission } from "../../middlewares/permission";
import { queue } from '../../kue'
import { phone } from 'phone'

let batchSize = 2;

const csvPathDir = path.join(
    path.dirname(require.main.filename),
    "Content",
    "csv"
  );
  
  const storage = multer.diskStorage({
    destination: (req, file, cb) => {
      cb(null, csvPathDir);
    },
    filename: (req, file, cb) => {
      cb(null, file.originalname);
    },
  });

  const upload = multer({storage})

function checkForValidRow(row) {
    let isValid = true;
    isValid = isValid && row && row.country_code && row.phone_number && phone(row.country_code+row.phone_number).isValid
    isValid = isValid && row && row.name && /^[a-zA-Z ]+$/.test(row.name);
    isValid &&
      row &&
      row.status &&
      (row.status.toLowerCase().trim() === "true" ||
        row.status.toLowerCase().trim() === "false");
    return isValid;
  }

function processDeactivationBatch(users, companyId, callback){
    if(users.length == 0) return callback();

    let batch = users.splice(0, batchSize)

    queue.create('whatsapp-user-save', { 
                users: batch, 
                companyId, 
    }).removeOnComplete(true).priority('high').save(()=>{
        if(users.length > 0){
            processDeactivationBatch(users, companyId, callback)
        }
        else{
            callback()
        }
    })  

}

function processActivationBatch(users, companyId, ){
    if(users.length == 0) return;

    let batch = users.splice(0, batchSize)

    queue.create('whatsapp-user-save', { 
                users: batch, 
                companyId, 
    }).removeOnComplete(true).priority('high').save(()=>{
        if(users.length > 0){
            processActivationBatch(users, companyId)
        }
    })  

}

let controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;
        if(!companyId) throw new RequestError("Company not found!")

        const file = req.file;
        const csvReadStream = fs.createReadStream(file.path);
        let csvStream = csv();

        let falseUsers = [];
        let trueUsers = [];

        csvReadStream
        .pipe(csvStream)
        .on("data", async(row)=>{
            try {
                if (row!={}  && row.name.length!=0 && row.status.length!=0 && row.country_code.length!=0 && row.phone_number.length!=0 && checkForValidRow(row)){
                    if(row.status.toLowerCase() == 'false') falseUsers.push(row)
                    else if(row.status.toLowerCase() == 'true') trueUsers.push(row)
                }

            } catch (error) {
                
            }
        })
        .on("end", () => {
            processDeactivationBatch(falseUsers, companyId,()=>{
                processActivationBatch(trueUsers, companyId)
            })

            fs.existsSync(file.path, (exists) => {
              if (exists) {
                fs.unlink(file.path, (deleteErr) => {
                  if (deleteErr) {
                    console.error(
                      "Error deleting the uploaded CSV file:",
                      deleteErr
                    );
                  }
                });
              }
            });
            console.log("Read stream is closed...");
          })
          .on("error", (err) => {
            fs.unlink(file.path, (deleteErr) => {
              if (deleteErr) {
                console.error("Error deleting the uploaded CSV file:", deleteErr);
              }
            });
          });

          return res.status(200).send({success: true, message: "Contacts will be synced shortly!"})
       
    } catch (err) {
        console.log(err);
        next(err);
    }
};

const apiRouter = express.Router();
apiRouter
    .route("/")
    .post(htmlsanitize(), 
    // validateBody(validator), 
    jwtStrategy, 
    permission("Users", "Write"), 
    upload.single("csvFile"),
    controller);

export default apiRouter;
