import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import restrictFeature from '../../middlewares/featureBlocker';

let validator = Joi.object().keys({
    whatsappMessageId: Joi.string().hex().length(24).required()
});


let controller = async (req, res, next) => {
    try {
        const { whatsappMessageId } = req.query;
        const urls = await db.Url.find({
            whatsappMessageId
        })
        res.status(200).json({ success: true, urls });
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(htmlsanitize(), validateBody(validator), jwtStrategy, restrictFeature("TPIR-WA"), controller);
export default apiRouter;