import express from "express";
import { processImageMessage, sendWhatsappMessage } from '../../service/whatsapp';

// const getMessageController = async (req, res, next) => {
//   try {
//     console.log("Request received");
//     if (req.body.entry && req.body.entry[0].changes && req.body.entry[0].changes[0] && req.body.entry[0].changes[0].value.messages) {
//       const phone_number_id = req.body.entry[0].changes[0].value.metadata.phone_number_id;
//       const from = req.body.entry[0].changes[0].value.messages[0].from;
//       const message = req.body.entry[0].changes[0].value.messages[0];
//       const name = req.body.entry[0].changes[0].value.contacts[0].profile.name;

//       console.log({phone_number_id, from, name})

//       const user = await db.User.findOne({
//         phoneNumber: from,
//         isActiveMessenger: true,
//         deletedAt: null
//     })

//     if(user){
//         let activeGroupsOfCompanyWithMessengerAccess = await db.Group.find({ companyId: user.companyId, deletedAt: null, messengerAccess: true }).select("_id")
//         activeGroupsOfCompanyWithMessengerAccess = activeGroupsOfCompanyWithMessengerAccess.map(group=> group._id)
//         console.log({activeGroupsOfCompanyWithMessengerAccess, user, check: user.groups.some(groupId =>activeGroupsOfCompanyWithMessengerAccess.some(activeGroupId => groupId.toString() === activeGroupId.toString()) )})
//     }
//       if(user && activeGroupsOfCompanyWithMessengerAccess && user.groups.some(groupId =>
//         activeGroupsOfCompanyWithMessengerAccess.some(activeGroupId => 
//           groupId.toString() === activeGroupId.toString()
//         )
//       )){
//         switch (message.type) {
//           case "image":
//             await processImageMessage(phone_number_id, from, message, name, user.companyId, user._id);
//             break;
//           default:
//             await sendWhatsappMessage(phone_number_id, 'Only images are allowed, please send an image.', from, message.id);
//             console.log("Message type not allowed! Please send images.");
//             break;
//         }
//       }

//       res.status(200).send("Success");
//     } else {
//       res.status(200).send("Success");
//     }
//   } catch (error) {
//     console.log("Error:", error);
//     next(error);
//   }
// };

const getMessageController = async (req, res, next) => {
  try {
    console.log("Request received");

    const value = req.body?.entry?.[0]?.changes?.[0]?.value;
    const message = value?.messages?.[0];
    const from = message?.from;
    const name = value?.contacts?.[0]?.profile?.name;
    const phone_number_id = value?.metadata?.phone_number_id;

    if (!message || !from || !name || !phone_number_id) {
      return res.status(200).send("Success");
    }

    console.log({ phone_number_id, from, name });

    const user = await db.User.findOne({
      phoneNumber: from,
      isActiveMessenger: true,
      deletedAt: null
    });

    if (!user) {
      return res.status(200).send("Success");
    }

    const activeGroups = await db.Group.find({
      companyId: user.companyId,
      deletedAt: null,
      messengerAccess: true
    }).select("_id");

    const activeGroupIds = new Set(activeGroups.map(group => group._id.toString()));
    const userGroupMatch = user.groups.some(groupId => activeGroupIds.has(groupId.toString()));

    console.log({ activeGroupIds, user, userGroupMatch });

    if (userGroupMatch) {
      if (message.type === "image") {
        await processImageMessage(phone_number_id, from, message, name, user.companyId, user._id);
      } else {
        await sendWhatsappMessage(
          phone_number_id,
          "Only images are allowed, please send an image.",
          from,
          message.id
        );
        console.log("Message type not allowed! Please send images.");
      }
    }

    res.status(200).send("Success");
  } catch (error) {
    console.log("Error:", error);
    next(error);
  }
};


const verifyWebhookController = async (req, res, next) => {
  try {
    const mode = req.query["hub.mode"];
    const challenge = req.query["hub.challenge"];
    const token = req.query["hub.verify_token"];
    const myToken = "hello";

    if (mode && token) {
      if (mode === "subscribe" && token === myToken) {
        res.status(200).send(challenge);
      } else {
        res.sendStatus(403);
      }
    }
  } catch (error) {
    console.log("Error:", error);
    next(error);
  }
};

const apiRouter = express.Router();
apiRouter.route("/").get(verifyWebhookController);
apiRouter.route("/").post(getMessageController);

export default apiRouter;

