import isUrl from 'validator/lib/isURL';
import { HttpsProxyAgent } from 'https-proxy-agent';
import { HttpProxyAgent } from 'http-proxy-agent';

const cfg = {
  useProxy: process.env.USE_PROXY
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.USE_PROXY)
      ? true
      : false
    : false,

  proxyUrl: process.env.PROXY_URL
    ? isUrl(process.env.PROXY_URL)
      ? process.env.PROXY_URL
      : ''
    : undefined,

  // undefined instead of null, because it's null by default
  proxyAgent: undefined,
  enableForNodeMailer: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_NODEMAILER
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_NODEMAILER)
      ? true
      : false
    : false),
  enableForMicrosoftGraph: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_MICROSOFT_GRAPH
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_MICROSOFT_GRAPH)
      ? true
      : false
    : false),
  enableForTA: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_TA
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_TA)
      ? true
      : false
    : false),
  enableForCM: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_CM
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_CM)
      ? true
      : false
    : false),
  enableForThreatCop: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_THREATCOP
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_THREATCOP)
      ? true
      : false
    : false),
  enableForVirusTotal: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_VIRUSTOTAL
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_VIRUSTOTAL)
      ? true
      : false
    : false),
   enableForGoogleAPIs: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_GOOGLE_APIS
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_GOOGLE_APIS)
      ? true
      : false
    : false),
   enableForIpLocation: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_IPLOCATION
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_IPLOCATION)
      ? true
      : false
    : false),
   enableForWhatsapp: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_WHATSAPP
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_WHATSAPP)
      ? true
      : false
    : false),
   enableForOpenAI: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_OPENAI
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_OPENAI)
      ? true
      : false
    : false),
   enableForHIBP: process.env.USE_PROXY && (process.env.ENABLE_PROXY_FOR_HIBP
    ? ['true', 'True', 'TRUE', '1'].includes(process.env.ENABLE_PROXY_FOR_HIBP)
      ? true
      : false
    : false),
};

if (!cfg.useProxy) {
  console.info(
    "config.proxy: Proxy is disabled. To enable, set process.env.USE_PROXY to any of these ['true', 'True', 'TRUE', '1'].",
  );
} else {
  if (!cfg.proxyUrl) {
    console.error(
      "config.proxy: Proxy is enabled, but proxyUrl doesn't exist. Set process.env.PROXY_URL to a valid URL.",
    );
  } else {
    // both are valid
    // set proxyAgent
    if( cfg.proxyUrl.startsWith('https://') ) cfg.proxyAgent = new HttpsProxyAgent(cfg.proxyUrl);
    else if (cfg.proxyUrl.startsWith('http://') ) cfg.proxyAgent = new HttpProxyAgent(cfg.proxyUrl);
    else console.error("config.proxy: Proxy URL must start with 'http://' or 'https://'.");
    console.info('config.proxy: Proxy is ready.');
  }
}

export default cfg;