import schedule from 'node-schedule';
import processUser from './service/process-user';
import moment from 'moment-timezone'

const convertTimeToUtc = (hour, minute, timeZone) => {
    var localTime = moment.tz({hour, minute},timeZone)
    var utcDate = localTime.utc().toISOString()
    return utcDate
}

const syncUsers = async (domain, domainId, companyId) => {
    return new Promise(async (resolve, reject) => {
        try {
            let deactivateUsers = await db.User.updateMany(
                { domainId, companyId, userId: { $ne: null } },
                { $set: { deletedAt: new Date() } }
            );
            if (domain.domainType == 'Gsuite' || domain.domainType == 'Outlook') {
                await db.Domain.updateOne({
                    _id: domainId
                }, {
                    isSyncingUser: true,
                    syncStartAt: new Date()
                })
                await processUser.process(companyId, domainId, domain.domainType, false, domain.domainTypeForOutlook == 'EXCHANGE');
                resolve(true)
            } else {
                console.log('Domain type not define');
                await db.Domain.updateOne({ _id: domainId },{ isSyncingUser: false, isSyncingUserErrorFile: "Error from scheduling user-sync", isSyncingUserError:true})
                reject(false)
            }
        } catch (error) {
            await db.Domain.updateOne({ _id: domainId },{ isSyncingUser: false, isSyncingUserErrorFile: "Error from scheduling user-sync", isSyncingUserError:true})
            reject(error)
        }
    })
}

const scheduleLostCrons = (domain, domainId, companyId, hour, minute, transformedDays, timeZone) => {
    return new Promise(async (resolve, reject) => {
        try {
            const rule = new schedule.RecurrenceRule();
            rule.hour = hour;
            rule.minute = minute;
            rule.dayOfWeek = transformedDays
            rule.tz = timeZone;

            schedule.scheduleJob(`${domainId}`, rule, async () => {
                let deactivateUsers = await db.User.updateMany(
                    { domainId, companyId, userId: { $ne: null } },
                    { $set: { deletedAt: new Date() } }
                );
                if (domain.domainType == 'Gsuite' || domain.domainType == 'Outlook') {
                    await db.Domain.updateOne({
                        _id: domainId
                    }, {
                        isSyncingUser: true,
                        syncStartAt: new Date()
                    })
                    await processUser.process(companyId, domainId, domain.domainType, false, domain.domainTypeForOutlook == 'EXCHANGE');
                } else {
                    await db.Domain.updateOne({ _id: domainId },{ isSyncingUser: false, isSyncingUserErrorFile: "Error from scheduling user-sync", isSyncingUserError: true})
                    console.log('Domain type not define');
                }
            });

            resolve(true)
        } catch (error) {
            await db.Domain.updateOne({ _id: domainId },{ isSyncingUser: false, isSyncingUserError: "Error from scheduling user-sync", isSyncingUserError: true})
            console.log('Some error occured recreating jobs')
            reject(error)
        }

    })
}

const logScheduledJobs = () => {
    const jobs = schedule.scheduledJobs;
    console.log('\nCurrently Scheduled Jobs:\n');
    if (Object.keys(jobs).length === 0) {
        console.log('No scheduled jobs found.\n');
        return;
    }
    Object.entries(jobs).forEach(([jobName, job]) => {
        console.log(`Job Name: ${jobName}`);
        console.log(`Next Run At: ${job.nextInvocation()}\n`);
    });
};


var cronJob = {
    init: () => {
        // cronJob.execute();
        logScheduledJobs()
    },

    async execute() {
        try {
            // const domains = await db.Domain.find({ 'isScheduledSyncing.isActive': true, deletedAt: null })
            // const dayMapping = { "All": 0, "Monday": 1, "Tuesday": 2, "Wednesday": 3, "Thursday": 4, "Friday": 5, "Saturday": 6, "Sunday": 0 };
            // for (let i = 0; i < domains.length; i++) {
                
            //     let domain = domains[i]
            //     let hour = domain.isScheduledSyncing.hour
            //     let minute = domain.isScheduledSyncing.minute
            //     let days = domain.isScheduledSyncing.daysOfWeek
            //     let timeZone = domain.isScheduledSyncing.timeZone
            //     let domainId = domain._id
            //     let companyId = domain.companyId

            //     const transformedDays = days.filter(day => day !== "All").map(day => dayMapping[day]);

            //     let convertedTime = new Date(convertTimeToUtc(hour, minute, timeZone))
            //     let todayDay = new Date().getDay()

            //     if (transformedDays.includes(todayDay)) {
            //         const currentTime = new Date()
            //         const lastSynced = domain.syncStartAt
            //         const setSyncTime = convertedTime
            //         if (lastSynced < setSyncTime && setSyncTime < currentTime) {
            //             await syncUsers(domain, domainId, companyId)
            //         }
            //     }

            //     await scheduleLostCrons(domain, domainId, companyId, hour, minute, transformedDays, timeZone)
            // }
            // console.log("\x1b[32mCronJob:\x1b[0m", 'Successfully retrieved and set cron!')

        } catch (error) {
            console.log(error)
            console.error('\x1b[31mCronJob:\x1b[0m', 'something went wrong with recreating cron')
        }
    }
}

export default cronJob;
































// console.log(domain)
// const rule = new schedule.RecurrenceRule();
// rule.hour = hour;
// rule.minute = minute;
// rule.dayOfWeek= transformedDays
// rule.tz = timeZone;


// const scheduledJob = schedule.scheduleJob(domainId, rule, async () => {
//     let deactivateUsers = await db.User.updateMany(
//         { domainId, userId: { $ne: null } },
//         { $set: { deletedAt: new Date() } }
//     );
//     if(domain.domainType == 'Gsuite' || domain.domainType == 'Outlook'){
//             await db.Domain.updateOne({
//                 _id: domainId
//             }, {
//                 isSyncingUser: true,
//                 syncStartAt: new Date()
//             })
//             await processUser.process(companyId, domainId, domain.domainType, domain.domainTypeForOutlook=='EXCHANGE');
//     } else {
//         throw new RequestError('Domain type not define');
//     }
// });