import CryptoJS from "crypto-js";
import config from './config';

export default {
    encrypt: (text) => {
        return CryptoJS.AES.encrypt(text, config.crypto.secret).toString();
    },
    decrypt: (ciphertext, secret) => {
        try{
            var bytes  = CryptoJS.AES.decrypt(ciphertext, secret ? secret :config.crypto.secret);
            return bytes.toString(CryptoJS.enc.Utf8);
        } catch(err){
            console.log(err);
            return ciphertext;
        }
    }
}