import zlib from 'zlib'
import getLanguageFormattedMessage from './service/languageService';
var words = require('an-array-of-english-words')

const messages = {
  finalAnalysisMessage: {
    english: (ticketId, result) => `*Security Update: Final Analysis of Your Reported Message*. \n\nTicket ID - ${ticketId}\n\nThank you for your vigilance. After analyzing the message, our system flagged it as *${result}*. However, we take extra measures to ensure that you’re fully protected, so our security team has reviewed the message again to provide an additional layer of analysis.\n\nBased on their review, they have marked the message as *${result}*. We always prioritize your security and appreciate your help in maintaining a safe environment.\n\n\`Thank you for the commitment to online safety.\``,
    
    indonesian: (ticketId, result) => `*Pembaruan Keamanan: Analisis Akhir dari Pesan yang Anda Laporkan*. \n\nTiket ID - ${ticketId}\n\nTerima kasih atas kewaspadaan Anda. Setelah menganalisis pesan, sistem kami menandainya sebagai *${result}*. Namun, kami mengambil langkah ekstra untuk memastikan Anda sepenuhnya terlindungi, jadi tim keamanan kami telah meninjau pesan tersebut lagi.\n\nBerdasarkan peninjauan mereka, pesan tersebut ditandai sebagai *${result}*. Kami selalu mengutamakan keamanan Anda dan menghargai bantuan Anda dalam menjaga lingkungan yang aman.\n\n\`Terima kasih atas komitmen Anda terhadap keamanan online.\``,

    arabic: (ticketId, result) => `*تحديث أمني: التحليل النهائي لرسالتك المُبلَّغ عنها*. \n\nمعرف التذكرة - ${ticketId}\n\nشكرًا ليقظتك. بعد تحليل الرسالة، أشار نظامنا إلى أنها *${result}*. ومع ذلك، نتخذ تدابير إضافية لضمان حمايتك الكاملة، لذا راجع فريق الأمان الرسالة مرة أخرى.\n\nاستنادًا إلى مراجعتهم، تم تصنيف الرسالة على أنها *${result}*. نحن نعطي الأولوية لأمنك ونقدّر مساعدتك في الحفاظ على بيئة آمنة.\n\n\`شكرًا لك على التزامك بالسلامة عبر الإنترنت.\``,

    french: (ticketId, result) => `*Mise à jour de sécurité : Analyse finale de votre message signalé*. \n\nID du ticket - ${ticketId}\n\nMerci pour votre vigilance. Après avoir analysé le message, notre système l'a signalé comme *${result}*. Cependant, nous prenons des mesures supplémentaires pour garantir votre sécurité, c'est pourquoi notre équipe de sécurité a revu le message.\n\nSuite à leur examen, ils ont marqué le message comme *${result}*. Nous priorisons toujours votre sécurité et apprécions votre aide pour maintenir un environnement sûr.\n\n\`Merci pour votre engagement envers la sécurité en ligne.\``,

    spanish: (ticketId, result) => `*Actualización de seguridad: Análisis final de su mensaje reportado*. \n\nID de ticket - ${ticketId}\n\nGracias por su vigilancia. Después de analizar el mensaje, nuestro sistema lo marcó como *${result}*. Sin embargo, tomamos medidas adicionales para garantizar su protección total, por lo que nuestro equipo de seguridad revisó el mensaje nuevamente.\n\nSegún su revisión, el mensaje ha sido marcado como *${result}*. Siempre priorizamos su seguridad y agradecemos su ayuda para mantener un entorno seguro.\n\n\`Gracias por su compromiso con la seguridad en línea.\``,

    german: (ticketId, result) => `*Sicherheitsupdate: Endgültige Analyse Ihrer gemeldeten Nachricht*. \n\nTicket-ID - ${ticketId}\n\nVielen Dank für Ihre Wachsamkeit. Nach der Analyse der Nachricht hat unser System sie als *${result}* gekennzeichnet. Wir ergreifen jedoch zusätzliche Maßnahmen, um Ihre vollständige Sicherheit zu gewährleisten, daher hat unser Sicherheitsteam die Nachricht erneut überprüft.\n\nBasierend auf ihrer Überprüfung wurde die Nachricht als *${result}* markiert. Wir priorisieren stets Ihre Sicherheit und schätzen Ihre Hilfe bei der Aufrechterhaltung eines sicheren Umfelds.\n\n\`Vielen Dank für Ihr Engagement für die Online-Sicherheit.\``,

    russian: (ticketId, result) => `*Обновление безопасности: окончательный анализ вашего сообщения*. \n\nНомер заявки - ${ticketId}\n\nСпасибо за вашу бдительность. После анализа сообщение было помечено системой как *${result}*. Тем не менее, мы предпринимаем дополнительные меры для вашей полной защиты, поэтому наша служба безопасности повторно его проверила.\n\nПо результатам повторной проверки сообщение помечено как *${result}*. Мы всегда ставим вашу безопасность в приоритет и благодарим за помощь в поддержании безопасной среды.\n\n\`Спасибо за вашу приверженность онлайн-безопасности.\``,

    chinese_simplified: (ticketId, result) => `*安全更新：您举报信息的最终分析结果*. \n\n工单编号 - ${ticketId}\n\n感谢您的警觉。经过分析，我们的系统将该消息标记为 *${result}*。为确保您的全面安全，我们的安全团队对该消息进行了再次审核。\n\n他们将该消息标记为 *${result}*。我们始终将您的安全置于首位，感谢您为维护安全环境所做的贡献。\n\n\`感谢您对网络安全的承诺。\``,

    chinese_traditional: (ticketId, result) => `*安全更新：您檢舉訊息的最終分析結果*. \n\n工單編號 - ${ticketId}\n\n感謝您的警覺。我們的系統在分析後將此訊息標記為 *${result}*。為了確保您的安全，我們的安全團隊再次審查了該訊息。\n\n根據審查結果，此訊息被標記為 *${result}*。我們始終優先考慮您的安全，感謝您協助維護安全的網絡環境。\n\n\`感謝您對網絡安全的承諾。\``,

    japanese: (ticketId, result) => `*セキュリティ更新：報告されたメッセージの最終分析*. \n\nチケットID - ${ticketId}\n\nご報告ありがとうございます。分析の結果、システムはこのメッセージを *${result}* と判定しました。更なる安全性を確保するため、セキュリティチームが再度確認を行いました。\n\nその結果、メッセージは *${result}* と最終判定されました。私たちは常にお客様の安全を最優先とし、安全な環境を維持するためのご協力に感謝いたします。\n\n\`オンラインセキュリティへのご協力ありがとうございます。\``,

    korean: (ticketId, result) => `*보안 업데이트: 신고된 메시지의 최종 분석 결과*. \n\n티켓 ID - ${ticketId}\n\n경계를 유지해 주셔서 감사합니다. 메시지를 분석한 결과, 시스템은 이를 *${result}*로 표시했습니다. 그러나 귀하의 완전한 보호를 위해 보안팀이 메시지를 다시 검토했습니다.\n\n검토 결과, 해당 메시지는 *${result}*로 판단되었습니다. 우리는 항상 귀하의 보안을 최우선으로 하며 안전한 환경 유지를 위한 도움에 감사드립니다.\n\n\`온라인 안전에 대한 헌신에 감사드립니다.\``
  }
};


export let get_end_point_name  = (filename) => {
	return (filename.split('/')[(filename.split('/').length)?(filename.split('/').length-1):filename]).split('.')[0];
} 
export let randomString = (len, charSet) => {
    charSet = charSet || 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    let randomString = '';
    for (let i = 0; i < len; i++) {
        let randomPoz = Math.floor(Math.random() * charSet.length);
        randomString += charSet.substring(randomPoz,randomPoz+1);
    }
    return randomString;
}

export let cleanDictionaryAndSpecialChars = (text) => {
  const dictionary = new Set(words);
  const wordArray = text.split(/\s+/);
  // Remove punctuation from each word and filter out non-dictionary words
  const filteredWords = wordArray.filter(word => {
  // Remove punctuation
  const cleanWord = word.replace(/[.,/#!$%^&?*;:{}=\-_`~()]/g, "").toLowerCase();
  // Check if the cleaned word is in the dictionary
    return dictionary.has(cleanWord);
  });
  let filteredDictionaryWords = filteredWords.join(' ');
  filteredDictionaryWords.replace(/\\r\\n|\\n|\\r|\\t/g, ' ');
  let finalText =  filteredDictionaryWords.replace(/\s+/g, ' ').trim()
  return finalText
}

export let cleanText = (text) => {
    text = text.replace(/(\r\n|\n|\r)/gm, '');
    text = text.replace(/\t/g, '');
    text = text.replace(/ {5,}/g, '    ');
    if (text.length >= 1024) {
        text = text.substring(0, 928) + '...';
      }
    console.log("length---",text.length)
    return text;
}

export let cacheReportedMail = async (reportedEmail) => {
  try {
    const reportedMailBuffer = zlib.deflateSync(JSON.stringify(reportedEmail)); 
    const reportedMailString = reportedMailBuffer.toString('base64'); 

    const cacheReportedMail = await redisClient.set(reportedEmail._id.toString(),JSON.stringify(reportedMailString),'EX',60)
    await redisClient.expire(reportedEmail._id.toString(), 1200);

    console.log("--------------Successfully Cached Reported Mail------------------",reportedEmail._id)
  } catch (error) {
    console.log('-----------Error Saving Reported Mail----------',error);
    return error
  }
}

export let getReportedMailFromCache = async (reportedMailId) => {
  try {
    const reportedMail = await redisClient.get(reportedMailId)
    if(reportedMail){
      const decompressedReportedMailBuffer = zlib.inflateSync(Buffer.from(reportedMail, 'base64')); 
      const decompressedReportedMailString = JSON.parse(decompressedReportedMailBuffer.toString('utf8'))
      console.log("--------------Successfully Fetched Reported Mail From Cache------------------",reportedMailId)
      return decompressedReportedMailString
    }
    else return null
  } catch (error) {
    console.log('-----------Error Fetching Reported Mail----------',error);
    return error
  }
}

export let updateReportedMailCache = async (reportedMailId, field) => {
  try {
    const reportedMail = await redisClient.get(reportedMailId)
    if(reportedMail){
      const decompressedBuffer = zlib.inflateSync(Buffer.from(reportedMail, 'base64')); 
      const decompressedString = JSON.parse(decompressedBuffer.toString('utf8'))
      for(const key in field){
        decompressedString[key] = field[key]
      }
      const compressedBuffer = zlib.deflateSync(JSON.stringify(decompressedString)); 
      const compressedString = compressedBuffer.toString('base64'); 
      await redisClient.set(reportedMailId,compressedString)
      await redisClient.expire(reportedMailId.toString(), 1200);
      return true
    }
  } catch (error) {
    return error
  }
}

export let gracefullyShutdown = async () => {
  try {
    if (calledOnce) {
      return;
    }

    calledOnce = true;

    const [globalRedisError, redisError, serverError, sequelizeError] =
      await Promise.all([
        globalRedisGracefulShutdown(),
        redisGracefulShutdown(),
        serverGracefulShutdown(server),
        sequelizeGracefulShutdown(),
      ]);

    const hasError =
      globalRedisError || redisError || serverError || sequelizeError;

    process.exit(hasError ? 1 : 0);
  } catch (err) {
    console.log(`Graceful shut down error: ${err} !`);
    process.exit(1);
  }
};

// async function handleResponse(message) {
//   try {
//      let parseMessage = JSON.parse(message)
//       if (Array.isArray(parseMessage)) {
//           console.log('Received JSON array:', message);
//           return 'Array'
//       }
//       else return 'String'
//   } catch (error) {
//       console.log('Received response is a string so handling the string directly as investigated content.',error);
//       return 'String'
//     }
// }

export const tryParseJSON = (jsonString) => {
  try {
      return JSON.parse(jsonString);
  } catch (error) {
      return false;
  }
};

async function handleResponse(message) {
  const parsedMessage = tryParseJSON(message);
  return Array.isArray(parsedMessage) ? 'Array' : 'String';
}


export let whatsappResultTemplate = async ( message, ticketId, preferedLanguage ) =>{
  const checkTypeOfMessage = await handleResponse(message);
    console.log({ checkTypeOfMessage });

    let formattedMessage = ``;
    let sender = ''
    // let originalResponse = JSON.stringify(message);
    let overallResult = ''
    let messageSummary = ''
    let summary = ''

    if (checkTypeOfMessage === 'Array') {
        const messageArray = JSON.parse(message);
        let extractedMessage = messageArray[0]
        
        if(extractedMessage.length == 1) messageSummary = extractedMessage[0]['Message Body']
        else messageSummary = "Multiple Messages"
        console.log({djasmdkaslmldkasmlkdmsal: extractedMessage[0], gggg: extractedMessage[0]["Message Body"]})
        sender = extractedMessage[0]?.Sender
        overallResult = messageArray[1][0]?.decision
        formattedMessage = extractedMessage.map((msg, index) => `*Message ${index + 1}:*\n*Sender*: ${msg?.Sender}\n*Message Body:* ${msg['Message Body']}\n*Safety Parameter:* ${msg['Safety Parameter']}\n*Description:* ${msg?.Description}
        `).join('\n\n');
        summary = messageArray[1][0]?.summary 

    } else {
        formattedMessage = message;
        messageSummary = message
        summary = messageArray[1][0]?.summary
        overallResult = messageArray[1][0]?.decision 
    }


    // const template = `
    //     *Ticket Id* - ${ticketId} \n Please find the investigation report below.\n\n*Investigated Content* - \nSafety Parameter - ${overallResult}\n\n${summary}\n\n\`Thank you for the commitment to online safety.\`
    // `;

    const template = await getLanguageFormattedMessage("investigation", preferedLanguage ,{ticketId, overallResult, summary})

    return { template, originalResponse: message, sender, overallResult, messageSummary };
}



// export let whatsappActionTemplate = ( ticketId, result, preferedLanguage) =>{
//   return `*Security Update: Final Analysis of Your Reported Message*. \n\nTicket ID - ${ticketId}\n\nThank you for your vigilance. After analyzing the message, our system flagged it as *${result}*. However, we take extra measures to ensure that you’re fully protected, so our security team has reviewed the message again to provide an additional layer of analysis.\n\nBased on their review, they have marked the message as *${result}*. We always prioritize your security and appreciate your help in maintaining a safe environment.\n\n \`Thank you for the commitment to online safety.\``
// }

export let whatsappActionTemplate = (ticketId, result, preferedLanguage) => {
  const language = (typeof preferedLanguage === 'string' && preferedLanguage.length > 0)
                          ? preferedLanguage.toLowerCase() : 'english';
  const lang = messages.finalAnalysisMessage[language] ? language : "english";
  return messages.finalAnalysisMessage[lang](ticketId, result);
};


export let whatsappAffirmTemplate = (ticketId,to) =>{
    return {
        messaging_product: "whatsapp",
        "type": "template",
        to,
        "text": {
          "body": "Do you like to process this text? if no, please crop the image accordingly and send again."
        },
        template: {
          namespace: "053243c9_c1ad_47da_9cc0_ae30508f0429",                  
          name: "affirm_template",
          language: {
              code: "en",
              policy: "deterministic"
          },
          components:  [
            {
              "type": "body",
              "parameters": [
                {
                  "type": "text",
                  "text": ticketId
                }
              ]
            }
          ]
      }
    }
}
