let features = [
  {
    name: "Custom Smtp",
    description: "Ability to add their custom SMTP to send notification emails.",
    category: "Notifications",
    type: "dynamic",
    featureCode: "TPIR-CSTM"
  },
  {
      name: "Email Alert to SOC Team for threat reports. Threshold configurable", 
      description: "Send alerts to the SOC team when a mail is reported with configurable soc emails.",
      category: "Notifications",
      type: "dynamic",
      featureCode: "TPIR-EASOC"
  },
  {
      name: "Report Notification", 
      description: "Notify users when a mail is reported.",
      category: "Notifications",
      type: "dynamic",
      featureCode: "TPIR-RN"
  },
  {
      name: "Notification to user on action taken on email", 
      description: "Notify users about actions taken on reported emails.",
      category: "Notifications",
      type: "dynamic",
      featureCode: "TPIR-NACT"
  },
  {
      name: "Customisable Email Templates", 
      description: "Provide customizable templates for notification emails.",
      category: "Notifications",
      type: "dynamic",
      featureCode: "TPIR-CET"
  },
  {
      name: "View Reported Email",   
      description: "Ability to view reported email.",
      category: "Analytics",
      type: "dynamic",
      featureCode: "TPIR-VRE"
  },
  {
    name: "View Reported Email Body",   
    description: "Ability to view reported email.",
    category: "Analytics",
    type: "dynamic",
    featureCode: "TPIR-VREB"
  },
  {
    name: "Header analysis", 
    description: "Analyze email headers for metadata and potential threats.",
    category: "Analytics",
    type: "dynamic",
    featureCode: "TPIR-HA"
  },
  {
    name: "SPF, DKIM, DMARC check-pass", 
    description: "Check and validate SPF, DKIM, and DMARC records to ensure email authenticity.",
    category: "Analytics",
    type: "dynamic",
    featureCode: "TPIR-SDD"
  },
  {
    name: "IP Reputation Check", 
    description: "Check the reputation of the sending IP address to detect potential spam or malicious sources.",
    category: "Analytics",
    type: "dynamic",
    featureCode: "TPIR-IPRC"
  },
  {
    name: "Sender Domain Reputation Check", 
    description: "Check the reputation of the sender’s domain to identify potential phishing or spam sources.",
    category: "Analytics",
    type: "dynamic",
    featureCode: "TPIR-SDRC"
  },
  {
    name: "DNS blackhole list", 
    description: "Check if the sender’s domain or IP address is on a DNS blackhole list.",
    category: "Analytics",
    type: "dynamic",
    featureCode: "TPIR-DBL"
  },
  {
    name: "User Awareness Score (Based on suspicious email reporting)", 
    description: "Calculate a score based on user reports of suspicious emails to evaluate their awareness level.",
    category: "Analytics",
    type: "dynamic",
    featureCode: "TPIR-UAS"
  },
  {
    name: "Download raw email", 
    description: "Allow users to download raw email headers for further analysis.",
    category: "Analytics",
    type: "dynamic",
    featureCode: "TPIR-DRH"
  },
  {
    name: "Spam Score to reported email", 
    description: "Assign a spam score to reported emails to help identify potential spam.",
    category: "Scanner",
    type: "dynamic",
    featureCode: "TPIR-SSRE"
  },
  {
    name: "Email content scan", 
    description: "Scan email content for potential threats such as phishing or malware.",
    category: "Scanner",
    type: "dynamic",
    featureCode: "TPIR-ECS"
  },
  {
    name: "Advanced Attachment and URL/Link protection", 
    description: "Protect against threats by scanning attachments and URLs/links in emails for malicious content.",
    category: "Scanner",
    type: "dynamic",
    featureCode: "TPIR-AALP"
  },
  {
    name: "View Attachment and URL/Links in reported email", 
    description: "View Attachment and URL/Links in reported email with or without scanner",
    category: "Scanner",
    type: "dynamic",
    featureCode: "TPIR-VAUIR"
  },
  {
    name: "Hash comparison for malware detection", 
    description: "Perform hash comparison on email attachments to detect known malware signatures.",
    category: "Scanner",
    type: "dynamic",
    featureCode: "TPIR-HCMD"
  },
  {
    name: "Who else (Who all within the organization received the mail)", 
    description: "Identify other users within the organization who received the same email.",
    category: "Advanced Features",
    type: "dynamic",
    featureCode: "TPIR-WE"
  },
  {
    name: "Action (Restore / Trash / Deletion) of suspicious email for entire organization", 
    description: "Take action on suspicious emails by restoring, trashing or deleting them across the organization.",
    category: "Advanced Features",
    type: "dynamic",
    featureCode: "TPIR-ARTD"
  },
  {
    name: "Find similar emails in the inbox", 
    description: "Allow users to see similar emails in their inbox for easy identification of potential threats with same subject.",
    category: "Advanced Features",
    type: "dynamic",
    featureCode: "TPIR-FSEI"
  },
  {
    name: "Advanced search", 
    description: "Provide an advanced search capability to quickly find specific emails or threats.",
    category: "Advanced Features",
    type: "dynamic",
    featureCode: "TPIR-ADVS"
  },
  {
    name: "Email Broadcast", 
    description: "Broadcast a notification email to a group or entire organization for important alerts.",
    category: "Advanced Features",
    type: "dynamic",
    featureCode: "TPIR-EB"
  },
  {
    name: "TSAT", 
    description: "Integration with TSAT for tracking and analyzing threat-related metrics.",
    category: "Integrations",
    type: "dynamic",
    featureCode: "TPIR-TSAT"
  },
  {
    name: "WhatsApp", 
    description: "Generate and send reports via WhatsApp for quick notifications and updates.",
    category: "Reporting",
    type: "dynamic",
    featureCode: "TPIR-WA"
  }
]

const templates = [
  {
    name: 'Acknowledgment E-Mail',
    logo: 'Tpirlogo.png',
    bodyContent:
      '<p>Dear ${userName},</p><p><br>Thank You for reporting a suspicious email.</p><p>&nbsp;</p><p>The email was received at <strong>${date}</strong>.From: <strong>${from}</strong><br>Subject: <strong>${subject}</strong><br>&nbsp;</p><p><br>It has been forwaded to SOC Team for further review. Your actions are helping the organization to keep the network and our data safe!<br>&nbsp;</p><p><br>Thanks,<br>TPIR Team</p>',
    headerContent: '<h2><strong>Mail Reported Successfully!</strong></h2><p>The mail will be reviewed by the SOC team.</p>',
    footerContent:
      '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
    bgColor: '#2c5596',
    companyId: null,
    description: 'This email is sent when a user reports a suspicious email.',
  },
  {
    name: 'SOC Notification E-mail',
    logo: 'Tpirlogo.png',
    description: 'This email is sent to SOC when a user reports a suspicious email.',
    bodyContent:
      '<p>Hi ,<br>Kindly review a mail reported by an employee.</p><p>&nbsp;</p><p>The email was received at <strong>${date}.</strong><br>To: <strong>${to}</strong><br>From: <strong>${from}</strong><br>Subject: <strong>${subject}</strong></p><p><br><br>Please review the mail and take appropiate actions from dashboard. Please find attached header and body.</p><p><br><br>Thanks,<br>TPIR Team</p>',
    headerContent: '<h2><strong>Suspicious Mail Reported&nbsp;</strong></h2><p>An employee discovered a suspicious mail and reported it.</p>',
    footerContent:
      '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
    bgColor: '#2c5596',
    companyId: null,
  },
  {
    name: 'Admin Action E-mail',
    logo: 'Tpirlogo.png',
    description: 'This email is sent when admin takes a action on email reported by user.',
    bodyContent:
      '<p>Dear ${name},&nbsp;</p><p>Thank you for promptly bringing the email to our attention. We have analyzed the mail and result can be found below-</p><p>&nbsp;</p><p>&nbsp;Result : <strong>${status}&nbsp;</strong></p><p>&nbsp;</p><p><strong>Reported Mail Details :&nbsp;</strong></p><p>The email was received at <strong>${date}</strong>.&nbsp;</p><p>From: <strong>${from}</strong>&nbsp;</p><p>Subject: <strong>${subject}</strong>&nbsp;</p><p>&nbsp;</p><p>Thanks, TPIR Team</p>',
    headerContent: '<h2>Mail Report&nbsp;</h2><p>The mail has been reviewed by the SOC team.</p>',
    footerContent:
      '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
    bgColor: '#2c5596',
    companyId: null,
  },
  {
    name: 'Result Notification Other Reporters E-mail',
    logo: 'Tpirlogo.png',
    description: 'This email is sent to other reporters when an admin takes an action on a reported mail.',
    bodyContent:
      '<p>Dear ${name},&nbsp;</p><p>A mail was reported by an employee, Our SOC Team promptly investigated the matter.&nbsp;</p><p>After careful assessment, the reported email was found to be <strong>${result}</strong> and has been <strong>${status}.</strong>&nbsp;</p><p>&nbsp;</p><p><strong>Reported Mail Details :&nbsp;</strong></p><p>Date: <strong>${date}</strong>.&nbsp;</p><p>From: <strong>${from}</strong>&nbsp;</p><p>Subject: <strong>${subject}</strong>&nbsp;</p><p>&nbsp;</p><p>Thanks, TPIR Team</p>',
    headerContent: '<h2>Suspicious Mail ${status}</h2><p>A suspicious mail was ${status} by SOC Team.</p>',
    footerContent:
      '<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href="mailto:%20support@tpir.threatcop.com">support@tpir.threatcop.com</a></p>',
    bgColor: '#2c5596',
    companyId: null,
  },
  {
   name: "Broadcast Email",
   logo: "Tpirlogo.png",
   description: "This email is sent to users when an admin broadcasts a particular email for awareness.",
   bodyContent: "<p>Dear Team,</p> <p>It has come to our attention that several employees have received a suspicious email from \"<b>${from}</b>\" with the subject \"<b>${subject}</b>\" Please DO NOT open any attachments or click any links. Delete the email immediately and report it to IT. See attached screenshot for reference.</p> <p>&nbsp;</p> <p>Stay vigilant and thank you for your cooperation.</p> <p>&nbsp;</p> <p>Thanks,</p> <p>TPIR Team</p>",
   headerContent: "<h2>Suspicious Email Warning</h2> <p>Important notice regarding a suspicious email circulating within the organization.</p>",
   footerContent: "<p>*If you did not make this request, there is no action required.</p><p>For any queries, please contact <a href=\"mailto:%20support@tpir.threatcop.com\">support@tpir.threatcop.com</a></p>",
   bgColor: "#2c5596",
   companyId: null,
  },


];


const createPolicyData = async () => {
  try {
    const pol = [
      "Domain",
      "Emails",
      "Users",
      "IAM",
      "AdvancedSearch",
      "Settings",
    ];
    const actions = ["Read", "Write", "Delete"];
    for (const policy of pol) {
      for (const act of actions) {
        await db.Policy.create({
          name: `${policy}-${act}`,
        });
      }
    }
  } catch (err) {
    console.log(err);
  }
}
const createDefaultRoles = async() => {
    try {
 
    let adminPolicyIds = [];
    let adminDescription = "An admin has full access to all functionalities, including creating, editing, and deleting content, managing user roles, and accessing all settings and configurations."
    let memberPolicies = [];
    let memberDescription = "A member can view, create, and edit content but cannot manage user roles or access sensitive settings. Members have the ability to contribute to and modify existing resources."
    let viewerPolicies = [];
    let viewerDescription = "A viewer has read-only access, allowing them to view content without the ability to make any changes or edits. Viewers cannot create, edit, or delete content."
    let Policies = await db.Policy.find({});
    if (!Policies) {
        throw "Policies Not found";
    }
    Policies.forEach(policy => {
        let suffix = policy.name.split('-')[1];
        let prefix = policy.name.split('-')[0];
        if (suffix == 'Read') {
            adminPolicyIds.push(policy._id.toHexString());
            memberPolicies.push(policy._id.toHexString());
            viewerPolicies.push(policy._id.toHexString());
        }
        if (suffix == 'Write') {
            if (['Domain', 'Emails', 'AdvancedSearch', 'Settings'].includes(prefix)) {
                memberPolicies.push(policy._id.toHexString());
            }
            adminPolicyIds.push(policy._id.toHexString());
        }
        if (suffix == 'Delete') {
            adminPolicyIds.push(policy._id.toHexString());
        }
    })
     
      // let companies = await db.Company.find({});
      // for (const company of companies) {
          await db.Role.create({
              roleName: "admin",
              policyIds: adminPolicyIds,
              companyId: null,
              description: adminDescription,
              roleType: "Default"
          })
          await db.Role.create({
              roleName: "member",
              policyIds: memberPolicies,
              companyId: null,
              description: memberDescription,
              roleType: "Default"
          })
          await db.Role.create({
              roleName: "viewer",
              policyIds: viewerPolicies,
              companyId: null,
              description: viewerDescription,
              roleType: "Default"
          })
     
} catch (err) {
  console.log(err);
}
}


export default {
  init: async () => {
      let metaData = await db.MetaData.findOne({
          name: 'seeds'
      }) 
      if(metaData){
          return true;
      } else {
        await createPolicyData();
        await createDefaultRoles();
          await db.Template.insertMany(templates); 
          await db.Feature.insertMany(features)
          return db.MetaData.create({
              name: 'seeds',
              value: true
          })
      }
},
}
