import fs from 'fs';
import kue from 'kue';
import path from 'path';
import Spamc from 'spamc';
import getUrls from 'get-urls';
import parseDomain from "parse-domains";

import config from './config';
import mailer from './mailer';
import s3 from './Content/upload_file';
import parseEmail from './service/parse-email';
import WorkerCon from './workerpool/workerpool';
import axios from 'axios'
import Credentials from './service/credentials';
import parseHeader from './service/parse-header';
import totalvirus from './service/get-virus-totalkey';
import scanResultURL from './service/result-url-totalvirus';
import tsat from './service/route-email-tsat'
import { checkDeceptive } from './service/deceiptive-check';
import { updateReportedMailCache, cleanDictionaryAndSpecialChars, cleanText, whatsappResultTemplate, tryParseJSON, randomString } from './functions';
import scanResultAttachment from './service/result-attachment-totalvirus';
import processWhatsappMessage from './service/process-whatsapp-message'
import { sendWhatsappMessage } from './service/whatsapp';
import whatsApp from './service/send-whatsapp-message';
import processImage from './service/image-to-text'
import moveEmail from './service/move-reported-email-outlook'
import { callMailActionApi } from './service/mail-actions';
import { cacheReportedMail } from './functions';
import checkLanguage from './service/check-language';
import scanAttachmentClamScan from './service/ScanAttachmentClamScan';
import updateMessageId from './service/update-messageId';
import {processBroadcastMailsRequest} from './service/broadcast-mail'
import { updateSyncingStatusOfGroups } from './service/update-syncing-status-groups';
import canAccessFeature from './service/allowed-features';
import { getAttachments, getOriginalMessageDetails } from './service/outlook-webhook-email-services';
import { formatMailAttachments, getMessageByInternetMessageId } from './service/subscriptionService';
import { cleanupMirrorGroup, orphanSweepManualGroups } from './utils/adSync';
import { injectBannerForWhoElse, removeBannerForWhoElse  } from './service/Banner';


export let queue = kue.createQueue({
    prefix: 'tpir-kue',
    redis: {
        host: config.redis.host,
        port: config.redis.port,
        auth: config.redis.password
    }
});

const spamc = new Spamc(config.spamassession.host, config.spamassession.port, 10000);

queue.setMaxListeners(10000);


function formatResult(result) {
    const messages = result.split('\n').filter(line => line.trim() !== '');
    let formatted = '';
    messages.forEach((msg, index) => {
      formatted += `Message ${index + 1}:\n${msg}\n\n`;
    });
    return formatted.trim();
  }

const findAndUpdateUsers = async (data) => {
    var { companyId, domainId, email, emailType, userId, name, addedUsersSoFar, phoneNumber, remainingUsersCount, group, subDomainGroupId, syncTs } = data;
    try {

        let user = null; 
        user = await db.User.findOne({ email, emailType, companyId });
        if(!user) user = await db.User.findOne({email: null, phoneNumber }); //if a contact was created without api but using csv
        console.log({email, user, condition: addedUsersSoFar < remainingUsersCount })

        console.log({
            addedUsersSoFar,
            remainingUsersCount
        })

        const allUsersGroup = await db.Group.findOne({groupName:"all-users-tpir", companyId, isDefaultGroup: true, deletedAt: null})

        const canBeActivate = (allUsersGroup.emailAccess || group.emailAccess) && addedUsersSoFar < remainingUsersCount;
        const canBeActivateMessenger = (allUsersGroup.messengerAccess || group.messengerAccess) && addedUsersSoFar < remainingUsersCount;

        if (user) {
            user.name = name;
            user.email = email;
            user.domainId = domainId;
            user.companyId = companyId;
            // user.groups = { $addToSet:{ groups: group._id }};
            user.phoneNumber = phoneNumber
            // user.groupName = groupName ? groupName : null;
            user.subDomainGroupId = subDomainGroupId ? subDomainGroupId : null
            user.tacGroupId = null
                //uploaded from csv and deleted                         //uploaded from api and deleted                                 (removed)uploaded from api but deactivated
            if (((user.userId == null && user.deletedAt !== null) || (user.userId !== null && user.deletedAt !== null)) && addedUsersSoFar < remainingUsersCount)
            {   
                console.log("user being activated", user.email, canBeActivate, canBeActivateMessenger)
                user.emailType = emailType;
                user.isActive = canBeActivate;
                user.isActiveMessenger = canBeActivateMessenger;
                user.deletedAt = null;
                addedUsersSoFar += 1;
            }
            console.log("groupppppp",group, !user.groups.includes(group._id) )
            //ek group sync kara to us group ki id ni hogi aur allUser wale default group ki bhi id nhi hogi
            if (!user.groups.includes(group._id)) {
                user.groups.push(group._id);
            }
            if(!user.groups.includes(allUsersGroup._id)){
                user.groups.push(allUsersGroup._id)
            }
            if (user.isADSynced && user.lastAdSeenAt !== syncTs) {
                user.lastAdSeenAt = syncTs;
            }
            await user.save();

        } else if(addedUsersSoFar < remainingUsersCount){

                const groupIdStr = group._id.toString();
                const allUsersGroupIdStr = allUsersGroup._id.toString();
            
                const uniqueGroupIdsStr = [...new Set([groupIdStr, allUsersGroupIdStr])];
                console.log("user being added", email, canBeActivate, canBeActivateMessenger, uniqueGroupIdsStr)
                user = new db.User({
                    companyId,
                    domainId,
                    email,
                    emailType,
                    isActive: canBeActivate,
                    isActiveMessenger: canBeActivateMessenger,
                    userId,
                    tacGroupId: null,
                    tacIdentityKey: null,
                    name,
                    groups: uniqueGroupIdsStr,
                    phoneNumber,
                    // groupName,
                    subDomainGroupId: subDomainGroupId ? subDomainGroupId : null,
                    lastAdSeenAt: syncTs,
                    isADSynced: true,
                });
                // activatedUsersSoFar = activatedUsersSoFar + (isActive ? 1 : 0);
                addedUsersSoFar = addedUsersSoFar + 1

                await user.save();
        }


        return addedUsersSoFar 

    } catch (error) {
        console.log(error);
        return addedUsersSoFar 
    } finally {
        return addedUsersSoFar 

    }
}

const findAndUpdateUsersWhatsapp = async (data) => {
    try {
        var { companyId,  remainingUsersCount, activatedUsersSoFar, emailType, name,  phoneNumber, status} = data;

        const isActive = (activatedUsersSoFar < remainingUsersCount);
        let user = await db.User.findOne({ phoneNumber, companyId });

        console.log({status, statusCheck: status.toLowerCase() == 'true',user})

        if (user) {
            user.name = name;
            user.phoneNumber = phoneNumber
            user.isActiveMessenger = status.toLowerCase() == 'true' ? isActive : false;
            user.phoneNumber = phoneNumber
            user.deletedAt = null;                                                                            //user found is activated but now deactivating so reducing activatedUsersSoFar count
            activatedUsersSoFar = status.toLowerCase() == 'true' ? activatedUsersSoFar + (isActive ? 1 : 0) : user.isActiveMessenger ? activatedUsersSoFar - 1 : activatedUsersSoFar  

        } else {
            user = new db.User({
                companyId,
                emailType,
                isActiveMessenger : status ? isActive : false,
                name,
                phoneNumber,
            });
            activatedUsersSoFar = status.toLowerCase() == 'true'  ? activatedUsersSoFar + (isActive ? 1 : 0) : activatedUsersSoFar
        }

        await user.save();

        return activatedUsersSoFar 
 
    } catch (error) {
        console.log(error);
        return activatedUsersSoFar 
    } finally {
        return activatedUsersSoFar 

    }
}


const createRequestObjects = async (whoElses)=>{
    let requestArray = []
   
    for(let i=0;i<whoElses.length;i++){
        let batch = whoElses[i]
        requestArray[i] = [];
        for(let j=0;j<batch.length;j++){
           let request = {
                id: batch[j]._id,
                method: "GET",
                url: `/users/${batch[j].to}/messages?$select=id,parentFolderId&$filter=internetMessageId eq '${encodeURIComponent(batch[j].internetMessageId)}' and from/emailAddress/address eq '${batch[j].from}'`
           }  
           requestArray[i].push(request)
        }
    }
    return requestArray
}

const createRequestObjectMailAction = (whoElses, token, mailAction) =>{
    let requestArray = []
    
    for(let i=0;i<whoElses.length;i++){
        let batch = whoElses[i]
        requestArray[i] = [];
        for(let j=0;j<batch.length;j++){
            let request ={}
        if(mailAction == 'Trashed'){
            let moveToTrashApi = `/users/${batch[j].to}/messages/${batch[j].messageId}/move`
            request ={
                    id: batch[j]._id,
                    method: 'POST',
                    url: moveToTrashApi,
                    headers: { 
                    "Authorization": `Bearer ${token}`,
                    "Content-Type": "application/json"
                    }, 
                    body : { "destinationId": "deleteditems" }
            }
           }
        else if(mailAction == 'Deleted'){
            let deleteApi = `/users/${batch[j].to}/messages/${batch[j].messageId}`
            request = {
                id: batch[j]._id,
                method: 'DELETE',
                url: deleteApi,
                headers: { 
                "Authorization": `Bearer ${token}`,
                "Content-Type": "application/json"
                }, 
            };
           }
        else{
            let folderId = batch ? batch[j].folderId ?  batch[j].folderId : 'inbox' : 'inbox'
            let moveToInboxApi = `/users/${batch[j].to}/messages/${batch[j].messageId}/move`
            request = {
                id: batch[j]._id,
                method: 'POST',
                url: moveToInboxApi,
                headers: { 
                "Authorization": `Bearer ${token}`,
                "Content-Type": "application/json"
                },
                body : { "destinationId": folderId }
            };
        }
           requestArray[i].push(request)
        }
    }
    return requestArray
} 


let outlookBatchProcess =  (requests, token) => {
   return new Promise(async(resolve,reject) =>{
    let data = { requests };
    let axiosConfig = {
        method: 'POST',
        url: 'https://graph.microsoft.com/v1.0/$batch/',
        headers: { "content-type": "application/json", authorization: `Bearer ${token}`, Prefer: 'outlook.allow-unsafe-operations'},
        data: data,
        ...(config.proxy.enableForMicrosoftGraph && { httpAgent: config.proxy.proxyAgent, httpsAgent: config.proxy.proxyAgent }),
    }
    let response = await axios.request(axiosConfig)
    let result = response.data.responses
    console.log(result[0].body)
    resolve(result);
   })
}




const update = (mailBoxRequests, token, action) => {
   return new Promise(async (resolve, reject) => {
        try {
            let mailBoxResponses = [];
            mailBoxResponses = await outlookBatchProcess(mailBoxRequests, token.access_token)
            let updatesArray = [];
             
            for(let i=0;i<mailBoxResponses.length;i++){
                if(mailBoxResponses[i] && mailBoxResponses[i].status==200 && mailBoxResponses[i].body && mailBoxResponses[i].body.value.length &&  mailBoxResponses[i].body.value[0].id){
                    
                    if(action){
                        updatesArray.push({
                            updateOne:{
                                filter: { _id: mailBoxResponses[i].id },
                                update: { messageId: mailBoxResponses[i].body.value[0].id},
                            }
                        })
                    }
                    else{
                        updatesArray.push({
                            updateOne:{
                                filter: { _id: mailBoxResponses[i].id },
                                update: { messageId: mailBoxResponses[i].body.value[0].id, folderId: mailBoxResponses[i].body.value[0].parentFolderId},
                            }
                        })
                    }
                }
            }
            const updateWhoElse = await db.WhoElse.bulkWrite(updatesArray)
            console.log({updateWhoElse})
            resolve(mailBoxResponses)

        } catch (error) {
            console.log(error.response.data)
            resolve(false)
        }

    })
}

const updateReportedMailIfEveryDomainCompleted = async (reportedMailId, companyId) =>{
        const countTotalDomains = await db.WhoElseMetaData.countDocuments({reportedMailId, companyId})
        const countCompletedDomains = await db.WhoElseMetaData.countDocuments({reportedMailId, companyId, isCompleted: true})
        const countProcessing = await db.WhoElseMetaData.countDocuments({reportedMailId, companyId, isProcessing: true})
        const countErrors = await db.WhoElseMetaData.countDocuments({reportedMailId, companyId, isError: true})
        if(countTotalDomains !== countCompletedDomains){
            // Show a snapshot of up to 5 incomplete domain meta rows
            const pendingMeta = await db.WhoElseMetaData.find({reportedMailId, companyId, isCompleted:false}).select('domainId isProcessing isCompleted isError errorMessage updatedAt createdAt').limit(5).lean();
            console.log(`[WHOELSE][CHECK-COMPLETION] reportedMailId=${reportedMailId} companyId=${companyId} completed=${countCompletedDomains}/${countTotalDomains} processing=${countProcessing} errors=${countErrors} samplePending=%j`, pendingMeta);
        }
        if( countTotalDomains > 0 && countTotalDomains == countCompletedDomains ){
            console.log(`[WHOELSE][ALL-DOMAINS-COMPLETED] reportedMailId=${reportedMailId} companyId=${companyId} domainsCompleted=${countCompletedDomains}/${countTotalDomains} -> marking isWhoElseCompleted=true`);
            try {
                await updateReportedMailCache(reportedMailId,{isWhoElseCompleted:true, isWhoElseProcessing:false})
            } catch(cacheErr){
                console.log(`[WHOELSE][CACHE-UPDATE-ERROR] reportedMailId=${reportedMailId} error=${cacheErr && cacheErr.message ? cacheErr.message : cacheErr}`)
            }
            const upd = await db.ReportedMail.updateOne({
                _id: reportedMailId, companyId: companyId
            }, {
                syncEndAt: new Date(),
                isWhoElseError: false,
                isWhoElseProcessing: false,
                isWhoElseErrorMessage: "",
                isWhoElseCompleted: true
            })
            console.log(`[WHOELSE][REPORTED-MAIL-UPDATE] reportedMailId=${reportedMailId} matched=${upd.matchedCount} modified=${upd.modifiedCount}`)
            if(upd.modifiedCount === 0){
                const currentDoc = await db.ReportedMail.findOne({_id: reportedMailId}).select('isWhoElseProcessing isWhoElseCompleted syncEndAt').lean();
                console.log(`[WHOELSE][REPORTED-MAIL-UPDATE-NOOP] reportedMailId=${reportedMailId} current=%j`, currentDoc);
            }
            // Retaining WhoElseMetaData documents (no deletion) as per requirement
            console.log(`[WHOELSE][REPORTED-MAIL-FINALIZED] reportedMailId=${reportedMailId} companyId=${companyId} metaRetained=true`)
        }
}

const updateReportedMailIfEveryDomainSimiliarSearchCompleted = async (reportedMailId, companyId) =>{
    const countTotalDomains = await db.SimiliarEmailMetdata.countDocuments({reportedMailId, companyId});
    const countCompletedDomains = await db.SimiliarEmailMetdata.countDocuments({reportedMailId, companyId, isCompleted: true});
    const countProcessing = await db.SimiliarEmailMetdata.countDocuments({reportedMailId, companyId, isProcessing: true});
    const countErrors = await db.SimiliarEmailMetdata.countDocuments({reportedMailId, companyId, isError: true});

    if(countTotalDomains !== countCompletedDomains){
        console.log(`[SIMILAR][AGG-STATE] reportedMailId=${reportedMailId} companyId=${companyId} domainsCompleted=${countCompletedDomains}/${countTotalDomains} processing=${countProcessing} errors=${countErrors}`);
    }
    if( countTotalDomains > 0 && countTotalDomains === countCompletedDomains ){
        console.log(`[SIMILAR][ALL-DOMAINS-COMPLETED] reportedMailId=${reportedMailId} companyId=${companyId} domainsCompleted=${countCompletedDomains}/${countTotalDomains} -> marking isSimiliarEmailCompleted=true`);
        const update = await db.ReportedMail.updateOne({ _id: reportedMailId, companyId }, {
            isSimiliarEmailProcessing: false,
            isSimiliarEmailCompleted: true,
            syncEndAt: new Date(),
            isSimilarEmailError: false,
            isSimiliarEmailErrorMessage: ''
        });
        console.log(`[SIMILAR][REPORTED-MAIL-UPDATE] reportedMailId=${reportedMailId} matched=${update.matchedCount} modified=${update.modifiedCount}`);
        try {
            await updateReportedMailCache(reportedMailId, { isSimiliarEmailProcessing: false, isSimiliarEmailCompleted: true });
        } catch(cacheErr){
            console.log(`[SIMILAR][CACHE-ERROR] reportedMailId=${reportedMailId} error=${cacheErr && cacheErr.message ? cacheErr.message : cacheErr}`)
        }
    // Retaining SimiliarEmailMetdata documents (no deletion) as per requirement
    console.log(`[SIMILAR][REPORTED-MAIL-FINALIZED] reportedMailId=${reportedMailId} companyId=${companyId} metaRetained=true`);
    }
}




export default {
    init: () => {

        queue.process('outlook-user-save', async (job, done) => {
            console.log("job ka data",job.data);
            const { users, domainId, companyId, subDomainGroups=[], isLast, isExchange, group, domainName, isMirrorSync, allUsersGroupId, syncTs, isFirstPage } = job.data;
            try {
                const userLimit = parseInt((await db.MetaData.findOne({ companyId, name: "userLimit"})).value)
                console.log({userLimit})
                const userLimitMessenger = parseInt((await db.MetaData.findOne({ companyId, name: "userLimitMessenger"})).value)
                console.log({userLimitMessenger})
                const addedUsersCount = await db.User.countDocuments({ companyId, deletedAt: null });
                console.log({addedUsersCount})
                const remainingUsersCount = Math.max(0, (userLimit+userLimitMessenger) - addedUsersCount);
                console.log({add:userLimit+userLimitMessenger, remainingUsersCount},)
                var addedUsersSoFar = 0;

                //we are not concluding the kue if remainingUserCount = 0 as if a user was already in a group and a new group
                //is synced in which a user was already there so the group have to be updated in user's document to associate it 
                //to that group too 
                console.log("users to be synced------------",{users})
                const seenUserIds = [];
                if (isMirrorSync && isFirstPage) {
                    await db.User.updateMany(
                      { companyId, domainId, groups: group._id },
                      { $set: { lastAdSeenAt: null } }
                    );
                }

                for (let i = 0; i < users.length; i++) {
                    const user = users[i];
                    let domainExistsInSubDomainGroups = false;
                    let subDomainGroupId = null;
                    console.log(`${user.displayName}---------------------- ${user.mail}`);
                    if(user.mail && user.mail.length && user.displayName){
                        subDomainGroupId;
                        var domain = user.mail.split('@')[1].toLowerCase()
                        domainExistsInSubDomainGroups = subDomainGroups.includes(domain)
                        if(domain == domainName) domainExistsInSubDomainGroups = true //when domain is main domain
                        subDomainGroupId = await db.SubDomainGroup.findOne({ groupName: domain, domainId})
                        console.log({domain, domainExistsInSubDomainGroups, subDomainGroupId})
                    }
                    if (user.mail && user.mail.length && user.displayName && domainExistsInSubDomainGroups) {

                        let isValidPhoneNumber = false

                        console.log({isValidPhoneNumber})
                        console.log("addedUsersSoFar inside queue-------------------", addedUsersSoFar)
                        addedUsersSoFar = await findAndUpdateUsers({
                            companyId,
                            domainId,
                            remainingUsersCount,
                            addedUsersSoFar,
                            userId: user.id,
                            email: user.mail,
                            emailType: isExchange ? 'Exchange': 'Outlook',
                            name: user.displayName,
                            group,
                            phoneNumber: user?.mobilePhone,
                            subDomainGroupId,
                            isLast,
                            syncTs
                        });
                    } else {
                        // console.warn('invalid user details', users[i]);
                    }
                }
               
            } catch (err) {
                await updateSyncingStatusOfGroups(group._id,companyId)
                console.error(err);
            } finally {
                if (isLast) {
                    if (isMirrorSync) {
                        await cleanupMirrorGroup({ companyId, groupId: group._id, syncTs });
                        await orphanSweepManualGroups({ companyId });
                    }
                    await updateSyncingStatusOfGroups(group._id,companyId)
                    await db.Domain.updateOne({ _id: domainId }, { isSyncingUser: false, syncEndAt: new Date() });
                    let isAnyUserUploadedInCurrentGroup = await db.User.countDocuments({companyId, groups:{$in:[group._id]}})
                    console.log({isAnyUserUploadedInCurrentGroup})
                    if(!isAnyUserUploadedInCurrentGroup) await db.Group.deleteOne({_id: group._id, isDefaultGroup: false, companyId})
                }
                done();
            }
        });

        queue.process('gsuite-user-save', async (job, done) => {
            var { users, domainId, subDomainGroups=[], companyId, isLast, group, domainName, isMirrorSync, allUsersGroupId, syncTs, isFirstPage } = job.data;    
            try {
                console.log("job ka data",job.data)      
               
                // const userLimit = (await db.MetaData.findOne({ companyId, name: "userLimit"})).value;
                // const addedUsersCount = await db.User.countDocuments({ companyId, deletedAt: null });
                // const remainingUsersCount = Math.max(0, userLimit - addedUsersCount);
                // let addedUsersSoFar = 0;
                const userLimit = parseInt((await db.MetaData.findOne({ companyId, name: "userLimit"})).value)
                console.log({userLimit})
                const userLimitMessenger = parseInt((await db.MetaData.findOne({ companyId, name: "userLimitMessenger"})).value)
                console.log({userLimitMessenger})
                const addedUsersCount = await db.User.countDocuments({ companyId, deletedAt: null });
                console.log({addedUsersCount})
                const remainingUsersCount = Math.max(0, (userLimit+userLimitMessenger) - addedUsersCount);
                console.log({add:userLimit+userLimitMessenger, remainingUsersCount},)
                var addedUsersSoFar = 0;
                const seenUserIds = [];
                if (isMirrorSync && isFirstPage) {
                    await db.User.updateMany(
                      { companyId, domainId, groups: group._id },
                      { $set: { lastAdSeenAt: null } }
                    );
                }
                for(let i=0; i<users.length; i++){
                    const user = users[i];
                    let domainExistsInSubDomainGroups = false;
                    let subDomainGroupId = null;
                    if(user.primaryEmail && user.primaryEmail.length && user.isMailboxSetup){
                        var domain = user.primaryEmail.split('@')[1]?.toLowerCase()
                        domainExistsInSubDomainGroups = subDomainGroups.includes(domain)
                        if(domain == domainName) domainExistsInSubDomainGroups = true
                        subDomainGroupId = await db.SubDomainGroup.findOne({ groupName: domain, domainId})

                    }
                    
                    if(user.primaryEmail && user.primaryEmail.length && user.isMailboxSetup && domainExistsInSubDomainGroups){
                        let isValidPhoneNumber = false

                        addedUsersSoFar = await findAndUpdateUsers({
                            companyId, 
                            domainId, 
                            remainingUsersCount,
                            addedUsersSoFar,
                            userId: user.id,
                            emailType: 'Gsuite',
                            email: user.primaryEmail,
                            name: user?.name?.fullName??'', 
                            group,
                            phoneNumber: user?.phones?.length ? user.phones[0].value : null,
                            subDomainGroupId,
                            isLast,
                            syncTs
                        })
                    } else {
                        console.warn('invalid user details or not setup mail box', user);
                    }
                }
                
            } catch (err) {
                console.log(err);
                 await db.Domain.updateOne({
                        _id: domainId
                    }, {
                        isSyncingUser: false,
                        syncEndAt: new Date()
                    })
                
            } finally { 
                if (isLast) {
                    if (isMirrorSync) {
                        await cleanupMirrorGroup({ companyId, groupId: group._id, syncTs });
                        await orphanSweepManualGroups({ companyId });
                    }
                    await updateSyncingStatusOfGroups(group._id,companyId)
                    await db.Domain.updateOne({ _id: domainId }, { isSyncingUser: false, syncEndAt: new Date() });
                    let isAnyUserUploadedInCurrentGroup = await db.User.countDocuments({companyId, groups:{$in:[group._id]}})
                    console.log({isAnyUserUploadedInCurrentGroup})
                    if(!isAnyUserUploadedInCurrentGroup) await db.Group.deleteOne({_id: group._id, isDefaultGroup: false, companyId})
                }
                done()
            }
        }),

        queue.process('whatsapp-user-save', async (job, done) => {
            try {
                var { users, companyId } = job.data;  
                               
                const userLimit = (await db.MetaData.findOne({ companyId, name: "userLimitMessenger"})).value;
                const activatedUsersCount = await db.User.countDocuments({ companyId, deletedAt: null, isActiveMessenger: true });
                const remainingUsersCount = Math.max(0, userLimit - activatedUsersCount);
                let activatedUsersSoFar = 0;

                for(let i=0; i<users.length; i++){
                    
                    if(users[i].name && users[i].name.length && 
                       users[i].country_code && users[i].country_code.length &&
                       users[i].phone_number && users[i].phone_number.length &&
                       users[i].status && users[i].status.length){

                        activatedUsersSoFar = await findAndUpdateUsersWhatsapp({
                            companyId, 
                            remainingUsersCount,
                            activatedUsersSoFar,
                            emailType: 'Messenger',
                            name: users[i]?.name??'', 
                            phoneNumber: users[i].country_code.split('+')[1] + users[i].phone_number,
                            status: users[i].status
                        })
                    } else {
                        console.warn('invalid user details or not setup mail box', users[i]);
                    }
                }
            } catch (err) {
                console.log(err);
                
            } finally {
                done();
            }
        }),

        queue.process('check-email-spam-or-not-event-outlook', async (job, done) => {
            try{
                const { email, score = 0, mailType, headerDetails, header } = job.data;
                let messageId = job.data.messageId;
                const parseEml = await parseEmail.parseEml(header);
                if(parseEml){

                    let from = null, fromName = null, to = null, toName = null, 
                        subject, mailId, mailRecievedTime, companyId = null;

                    if(parseEml.from && parseEml.from.length){
                        from = parseEml.from[0].address
                        fromName = parseEml.from[0].name
                    } else {
                        throw new RequestError('con\'t find from email');
                    }
                    to = email
                    toName = ""
                    subject = parseEml.subject
                    mailId = parseEml.messageId
                    mailRecievedTime = parseEml.receivedDate

                    const user = await db.User.findOne({ 
                        email: to,
                        emailType: mailType
                    })
                    if(user){
                        companyId = user.companyId;
                    } 
                    console.log({companyId})
                    await db.CheckEmailScoreEvent.create({
                        from, fromName, to, toName, subject, mailId, headerDetails,
                        messageId, mailRecievedTime, companyId, score, mailType
                    })
                } else {
                    console.error('error in parsing eml');
                }
            } catch(err){
                console.log(err);
            } finally {
                done();
            }
        })

        queue.process('check-email-spam-or-not-event-gsuite', async (job, done) => {
            try{
                const { email, score = 0, mailType, headerDetails, mailBody, messageId, threadId } = job.data;
                const parseEml = await parseEmail.parseEml(mailBody);
                if(parseEml){
                    let from = null, fromName = null, to = null, toName = null, 
                        subject, mailId, mailRecievedTime, companyId = null;
                    if(parseEml.from && parseEml.from.length){
                        from = parseEml.from[0].address
                        fromName = parseEml.from[0].name
                    } else {
                        throw new RequestError('con\'t find from email');
                    }
                    to = email
                    toName = ""
                    mailId = threadId
                    subject = parseEml.subject
                    mailRecievedTime = parseEml.receivedDate
                    const user = await db.User.findOne({ 
                        email: to,
                        emailType: mailType
                    })
                    if(user){
                        companyId = user.companyId;
                    } 
                    await db.CheckEmailScoreEvent.create({
                        from, fromName, to, toName, subject, mailId, headerDetails,
                        messageId, mailRecievedTime, companyId, score, mailType
                    })
                } else {
                    console.error('error in parsing eml');
                }
            } catch(err){
                console.log(err);
            } finally {
                done();
            }
        })
    
        
        queue.process('webhook-reported-email-outlook-collector', async (job, done) => {
            try {
                const { messageId, companyId, domainId, token, webhookRetrievalEmail, from, user } = job.data;
                console.log(`Processing webhook-reported-email-outlook-collector for message: ${messageId}`);
        
                if (!messageId || !companyId || !domainId || !token || !webhookRetrievalEmail || !from || !user) {
                    console.error("Missing required data. Skipping queue processing.");
                    return done("Invalid job data");
                }
        
                let attachments, eml;
                try {
                    attachments = await getAttachments(webhookRetrievalEmail, messageId, token);
                    if (!attachments.length) {
                        console.warn(`⚠️ No attachments found for message: ${messageId}`);
                        return done();
                    }
        
                    eml = await getOriginalMessageDetails(webhookRetrievalEmail, messageId, attachments[0].Id, token);
                    if (!eml) {
                        console.error("Failed to fetch original EML content.");
                        return done("No valid EML content found");
                    }
                } catch (error) {
                    console.error(`Error fetching email details: ${error.message}`);
                    return done(error.message);
                }
        
                const parsedEML = await parseEmail.parseHeader(eml);
                const internetMessageId = parsedEML?.headers?.['message-id'];
        
                if (!internetMessageId) {
                    console.error("Failed to extract internetMessageId from parsed EML.");
                    return done("Missing internetMessageId");
                }
        
                const originalMessage = await getMessageByInternetMessageId(from, internetMessageId, token);
                if (!originalMessage || !originalMessage.id) {
                    console.error("Failed to retrieve original message by internetMessageId.");
                    return done("Original message not found");
                }
        
                const { body, id, parentFolderId } = originalMessage;
                let mailAttachments = parsedEML?.attachments ?? [];
                if (mailAttachments.length) mailAttachments = await formatMailAttachments(mailAttachments);
        
                if (!id || !from || !user._id || !companyId || !domainId || !parentFolderId) {
                    console.error("Missing required data before queuing reported-email-outlook.");
                    return done("Incomplete data for email reporting");
                }
        
                queue.create('reported-email-outlook', {
                    email: from,
                    header: eml,
                    body: body?.content || '',
                    eml,
                    userId: user._id,
                    userName: user?.name || '',
                    domainId,
                    companyId,
                    messageId: id,
                    internetMessageId,
                    attachments: mailAttachments,
                    folderId: parentFolderId,
                    spamScore: 0,
                    isTsatMail: false
                })
                .priority('high')
                .removeOnComplete(true)
                .save((err) => {
                    if (err) {
                        console.error("Failed to enqueue reported-email-outlook:", err);
                        return done(err);
                    }
                    console.log(`Successfully enqueued reported-email-outlook for message: ${id}`);
                    return done();
                });

            } catch (error) {
                console.error("Error processing webhook-reported-email-outlook-collector:", error.message);
                return done(error);
            }
        });
        
        

        queue.process('reported-email-outlook', async (job, done) => {
            const { email, header, body, attachments, userId, domainId, folderId, messageId, companyId, eml, internetMessageId, spamScore, userName, isTsatMail } = job.data;
            try{
                const parseEml = await parseEmail.parseEml(header);
                const bannerMeta = await db.MetaData.findOne({ companyId, name: 'BannerMessage', deletedAt: null });
                const hasBanner  = !!(bannerMeta && bannerMeta.value);
                let headerDetails = await parseHeader.processHeader(header);
                let from = null, fromName = null, to = null, toName = null, mailType = "Outlook", subject, mailId, mailRecievedTime, cc = [], bcc = [], otherTo = [];
                let emailReportedId = null;
                if(parseEml){

                    if(parseEml.from && parseEml.from.length){
                        from = parseEml.from[0].address
                        fromName = parseEml.from[0].name
                    }
                    if(parseEml.to && parseEml.to.length){
                        otherTo = parseEml.to;
                    }
                    to = email.toLowerCase()
                    toName = userName
                    subject = parseEml.subject
                    mailId = parseEml.messageId
                    mailRecievedTime = parseEml.receivedDate
                    cc = parseEml.cc?? parseEml.cc 
                    bcc = parseEml.bcc?? parseEml.bcc 
                    if(!isTsatMail){
                        let emailReported = await db.ReportedMail.findOne({
                            companyId,
                            userId,
                            internetMessageId,
                            deletedAt: null
                        });
                        if (!emailReported) {
                            emailReported = await db.ReportedMail.create({ 
                                from, fromName, to, toName, subject, mailId, cc, reporterFolderId: folderId,
                                bcc, otherTo, messageId, internetMessageId, mailRecievedTime, companyId,   
                                mailType, header:'', body:'', userId, headerDetails: await canAccessFeature(companyId,"TPIR-SDD") ? headerDetails : null, domainId, parsedHeader: ''
                            });
                            const document = { _id: emailReported._id, header, body, parsedHeader:parseEml };
                            s3.uploadReportedMail(document)
                        } else {
                            console.log(`reported-email-outlook: duplicate detected (companyId=${companyId}, userId=${userId}, internetMessageId=${internetMessageId}); reusing _id=${emailReported._id}`)
                        }
                        emailReportedId = emailReported._id
                    }   


                    if(await canAccessFeature(companyId,"TPIR-RN")){
                        queue.create('send-reported-mail',{
                            to,
                            userName,
                            from,
                            subject,
                            mailRecievedTime,
                            companyId
                        }).removeOnComplete(true).priority('high').save()
                    }
                    const resolutionTime = Date.now() - new Date(mailRecievedTime).getTime();
                    const urls = getUrls(body);

                    queue.create('upload-siem-logs',{
                        to,
                        from,
                        subject,
                        mailRecievedTime,
                        companyId,
                        internetMessageId,
                        spf: headerDetails?.spf,
                        dkim: headerDetails?.dkim,
                        dmarc: headerDetails?.dmarc,
                        senderIp: headerDetails?.senderIp,
                        header,
                        body,
                        reportedUser: email,
                        spamScore,
                        resolutionTime,
                        links: Array.from(urls),
                        attachments

                    }).removeOnComplete(true).priority('high').save();

                    if(await canAccessFeature(companyId,"TPIR-EASOC")){
                        console.log('sending soc mail from reported email outlook',companyId, to)
                    queue.create('send-soc-mail',{
                        to,
                        from,
                        subject,
                        mailRecievedTime,
                        header,
                        body,
                        companyId,
                        eml,
                        attachment:attachments,
                        isGsuite: false
                    }).removeOnComplete(true).priority('high').save()
                    }

                    if(!isTsatMail){

                    if(await canAccessFeature(companyId,"TPIR-SDRC")){
                        queue.create('check-sender-domain-deceptive', {
                            from: from,
                            reportedMailId: emailReportedId,
                        }).removeOnComplete(true).priority('high').save();
                    }

                    queue.create('email-language', {
                        body,
                        reportedMailId: emailReportedId,
                    }).removeOnComplete(true).priority('high').save();

                    queue.create('report-email-score', {
                        spamScore: spamScore,
                        reportedMailId: emailReportedId,
                    }).removeOnComplete(true).priority('high').save();
                    
                    if(await canAccessFeature(companyId,"TPIR-VAUIR")){
                        queue.create('email-reported-url', {
                            body,
                            companyId,
                            reportedMailId: emailReportedId,
                        }).removeOnComplete(true).priority('high').save();
                    }

                    if(await canAccessFeature(companyId,"TPIR-VAUIR")){
                        queue.create('email-reported-attachments-outlook', {
                            attachments,
                            companyId,
                            reportedMailId: emailReportedId,
                        }).removeOnComplete(true).priority('high').save();
                    }

                    // queue.create('email-reported-who-else-outlook', {
                    //     reportedMailId: emailReported._id,
                    //     internetMessageId, domainId, companyId, 
                    //     subject, from, email
                    // }).delay(5000).removeOnComplete(true).priority('high').save();

                    if(headerDetails?.senderIp && await canAccessFeature(companyId,"TPIR-DBL")){
                        queue.create('process-dnsbl', {
                            reportedMailId: emailReportedId,
                            senderIp: headerDetails.senderIp
                        }).removeOnComplete(true).save();
                    }
                    if (hasBanner) {
                        console.log("called the banner message queue from ------ reported email outlook");
                        queue.create('email-reported-who-else-outlook', {
                            from,
                            subject,
                            reportedMailId : emailReportedId,
                            domainId,
                            companyId,
                            internetMessageId
                        })
                        .delay(8000)
                        .removeOnComplete(true)
                        .priority('high')
                        .save();
                    }
                }
                }
            } catch(err){
                console.log(err);
            } finally {
                done();
            }
        })

        

        queue.process('upload-siem-logs', async (job, done) => {
            const { to, from, subject, mailRecievedTime, companyId, internetMessageId, spf, dkim, dmarc, senderIp, header, body, reportedUser, spamScore, resolutionTime, links, attachments} = job.data;
            try {
                await s3.uploadSiemLogs(job.data, companyId)
            } catch (err){
                console.log('Error Sending Reported Mail', err);
                done()
            } finally {
                done();
            }
        })

        queue.process('send-reported-mail', async (job, done) => {
            const { to, from, userName, subject, mailRecievedTime ,companyId} = job.data;
            try {
                await mailer.sendReportedMail(to, from, subject, mailRecievedTime, companyId, userName)
            } catch (err){
                console.log('Error Sending Reported Mail', err);
            } finally {
                done();
            }
        })

        queue.process('route-email-tsat', async (job, done) => {
            const { body, header, tsatUrl } = job.data;
            try {
                await tsat.routeMail(job.data)
            } catch (err){
                console.log('Error Sending Reported Mail', err);
                done();
            } finally {
                done();
            }
        })

        queue.process('send-soc-mail', async (job, done) => {
            let { companyId, to, from, subject, mailRecievedTime, header, eml = '', body, attachment = false, filename = '', mailBody = '', isGsuite } = job.data;
            const isSocMail = await db.Company.findOne({_id: companyId, socEmail: {$exists: true}})
            console.log({isSocMail})
            if(!isSocMail){ console.log('Mail Not Sent: SOC mail not added')
                done()
                return 
            }
            try {
                for (let i = 0; i < isSocMail.socEmail.length; i++){
                    console.log('Sending SOC Mail to', isSocMail.socEmail[i])
                    mailer.sendSocMail(to, from, subject, mailRecievedTime,header, body,eml, isSocMail.socEmail[i], attachment, filename, companyId, mailBody, isGsuite)
                }
            } catch (err){
                console.log('Error Sending SOC Mail', err);
            } finally {
                done();
            }
        })

        queue.process('check-sender-domain-deceptive', async (job, done) => {
            const { reportedMailId, from } = job.data;
            try {
                let senderDomain = from.split("@")[1];
                let senderDomainDeceptive = await checkDeceptive(senderDomain);
                await db.ReportedMail.updateOne({
                    _id: reportedMailId
                }, {
                    senderDomain,
                    senderDomainDeceptive
                })
            } catch (err){
                console.log(err);
            } finally {
                done();
            }
        })

        queue.process('email-language', async (job, done) => {
            const { reportedMailId, body } = job.data;
            console.log('---------------------------LANG DETECT------------------------------------');
            try {
                let languages = await checkLanguage.processText(body);
                updateReportedMailCache(reportedMailId,{languages:languages})
                await db.ReportedMail.updateOne({
                    _id: reportedMailId
                }, {
                    languages
                })
            } catch (err){
                console.log(err);
            } finally {
                done();
            }
        })
        
        queue.process('reported-email-gsuite', async (job, done) => {
            let { email, header, plainHeader, body, attachments, userId, domainId, messageId, threadId, companyId, internetMessageId, spamScore, userName, isTsatMail, mailBody } = job.data;
            try{
                let headerDetails = await parseHeader.processHeader(header, false);

                // const parseEml = await parseEmail.parseEml(header);
                const parseEml = header
                if(parseEml){
                    let from = null, fromName = null, to = null, toName = null, mailType = "Gsuite", subject, mailId, mailRecievedTime, cc = [], bcc = [], otherTo = []
                    if(parseEml.from && parseEml.from.length){
                        from = parseEml.from[0].address
                        fromName = parseEml.from[0].name
                    }
                    if(parseEml.to && parseEml.to.length){
                        otherTo = parseEml.to;
                    }
                    to = email
                    toName = userName
                    mailId = threadId
                    subject = parseEml.subject
                    mailRecievedTime = parseEml.receivedDate
                    cc = parseEml.cc?? parseEml.cc 
                    bcc = parseEml.bcc?? parseEml.bcc 

                    delete parseEml['attachments']

                    if(!isTsatMail){
                        var emailReported = await db.ReportedMail.create({
                            from, fromName, to, toName, subject, mailId, cc, 
                            bcc, otherTo, messageId, mailRecievedTime, companyId, internetMessageId,
                            mailType, header: '', body:'', userId, headerDetails: await canAccessFeature(companyId,"TPIR-SDD") ? headerDetails : null, domainId, parsedHeader: ''
                        })

                        let document = { _id: emailReported._id, header:plainHeader, body, parsedHeader:parseEml}
                        s3.uploadReportedMail(document)
                    }
                    
                    queue.create('upload-siem-logs',{
                        to,
                        from,
                        subject,
                        mailRecievedTime,
                        companyId,
                        internetMessageId,
                        spf: headerDetails?.spf,
                        dkim: headerDetails?.dkim,
                        dmarc: headerDetails?.dmarc,
                        senderIp: headerDetails?.senderIp
                    }).removeOnComplete(true).priority('high').save();
                    
                    if(await canAccessFeature(companyId,"TPIR-RN")){
                        queue.create('send-reported-mail',{
                            to,
                            from,
                            userName,
                            subject,
                            mailRecievedTime,
                            companyId
                        }).removeOnComplete(true).priority('high').save()
                    }

                    if(await canAccessFeature(companyId,"TPIR-EASOC")){
                    queue.create('send-soc-mail',{
                        to,
                        from,
                        subject,
                        mailRecievedTime,
                        header,
                        body,
                        // eml,
                        companyId,
                        mailBody,
                        isGsuite: true
                    }).removeOnComplete(true).priority('high').save()
                }

                    if(!isTsatMail){

                    if(await canAccessFeature(companyId,"TPIR-SDRC")){
                        queue.create('check-sender-domain-deceptive', {
                            from: from,
                            reportedMailId: emailReported._id,
                        }).removeOnComplete(true).priority('high').save();
                    }

                    queue.create('email-language', {
                        body,
                        reportedMailId: emailReported._id,
                    }).removeOnComplete(true).priority('high').save();

                    queue.create('report-email-score', {
                        spamScore: spamScore,
                        reportedMailId: emailReported._id,
                    }).removeOnComplete(true).priority('high').save();
                    
                    if(await canAccessFeature(companyId,"TPIR-VAUIR")){
                        queue.create('email-reported-url', {
                            body,
                            companyId,
                            reportedMailId: emailReported._id,
                        }).removeOnComplete(true).priority('high').save();
                    }

                    if(await canAccessFeature(companyId,"TPIR-VAUIR")){
                    queue.create('email-reported-attachments-gsuite', {
                        attachments,
                        companyId,
                        reportedMailId: emailReported._id,
                    }).removeOnComplete(true).priority('high').save();
                    }

                    // queue.create('email-reported-who-else-gsuite', {
                    //     reportedMailId: emailReported._id,
                    //     domainId, companyId, subject, from, email, internetMessageId
                    // }).delay(5000).removeOnComplete(true).priority('high').save();

                    if(headerDetails?.senderIp && await canAccessFeature(companyId,"TPIR-DBL")){
                        queue.create('process-dnsbl', {
                            reportedMailId: emailReported._id,
                            senderIp: headerDetails.senderIp
                        }).removeOnComplete(true).save();
                    }
                }
                }
            } catch(err){
                console.log("Kue error",err);
            } finally {
                done();
            }
        })
        
        queue.process('process-dnsbl', async (job, done) => {
            console.log('processing dnsbl.....');
            const { reportedMailId, senderIp } = job.data;
            try {
                let workerPool = WorkerCon.get();
                console.time(reportedMailId);
                workerPool.dnsbl({ senderIp })
                .then(async result => {
                    console.timeEnd(reportedMailId);
                    await db.ReportedMail.updateOne({
                        _id: reportedMailId
                    }, {
                        dnsbl: result['dnsbl']
                    })
                })
            }catch(err){
                console.log(err);
            } finally {
                done();
            }
        })

        queue.process('email-reported-url', async (job, done) => {
            const { reportedMailId, whatsAppMessageId, body, companyId } = job.data;
            try {
                let urls = await getUrls(body);
                console.log("urls-----",urls)
                let data = [];
                for(let key of urls){
                    let domain = await parseDomain(key);
                    let deceptiveStatus = false;
                    if(domain?.domain) {
                        deceptiveStatus = await checkDeceptive(domain.domain);
                    }
                    data.push({
                        url: key, deceptiveStatus, domain, reportedMailId: reportedMailId ? reportedMailId : null,
                        whatsappMessageId: whatsAppMessageId ? whatsAppMessageId :null, companyId
                    })
                }
                await db.Url.insertMany(data);
            } catch(err) {
                console.log(err);
            } finally {
                done();
            }
        })

        queue.process('email-reported-attachments-outlook', async (job, done) => {
            const { reportedMailId, attachments, companyId } = job.data;
            try {
                console.log('find attachment length', attachments.length);
                let scanResult = {isInfected: true, viruses:[], file: ""}
                if(attachments && attachments.length){
                    var attachmentToinsert = [];
                    for (let attachment of attachments) {
                        const fileExt = attachment.name.split('.').pop();
                        const filename = `${Date.now()}.${fileExt}`;
                        const filePath = path.join(appRoot, 'Content', 'MailAttachments', filename);

                        console.log(`Uploading attachment ${filename} for reportedMailId ${reportedMailId}`);

                        const mailId = reportedMailId.toString();
                        console.log("Attachment keys:", Object.keys(attachment));
                        console.log("ContentBytes type:", typeof attachment.contentBytes, "length:", attachment.contentBytes?.length);

                        await s3.uploadReportedMailAttachments(
                            mailId,
                            filePath,
                            filename,
                            attachment.contentBytes,
                            attachment.contentType
                        );

                        scanResult = await scanAttachmentClamScan.scanFile(attachment.contentBytes);

                        attachmentToinsert.push({
                            reportedMailId,
                            mimeType: attachment.contentType,
                            fileName: filename,
                            attachmentId: attachment.id,
                            originalName: attachment.name,
                            attachmentType: attachment.contentType,
                            isInfected: scanResult.isInfected,
                            viruses: scanResult.viruses,
                            companyId
                        });
                    }
                    await db.Attachment.insertMany(attachmentToinsert);
                }
            } catch(err) {
                console.log(err);
            } finally {
                done();
            }
        })
        queue.process('upload-attachments-s3', async (job, done) => {
            try {
                const { filename, content, contentType } = job.data;
                s3.upload_on_s3(filename);
            } catch (error) {
                console.log(err);
            } finally {
                done()
            }
        })

        queue.process('email-reported-attachments-gsuite', async (job, done) => {
            try {
                const { reportedMailId, attachments, companyId } = job.data;
                console.log('find attachment length', attachments.length);
                if(attachments && attachments.length){
                    var attachment = [];
                    for (var i = 0; i < attachments.length; i++) {
                        var filemime = (attachments[i].fileName).split('.')[(attachments[i].fileName).split('.').length - 1];
                        var filename = Date.now() + '.' + filemime;
                        var filePath = path.join(appRoot, 'Content', 'MailAttachments', filename);
                        
                        await s3.uploadReportedMailAttachments(reportedMailId, filePath, filename,  attachments[i].content, attachments[i].contentType)
                        attachment.push({ 
                            reportedMailId,
                            mimeType: filemime,
                            fileName: filename,
                            originalName: attachments[i].fileName, 
                            attachmentId: attachments[i].contentId, 
                            attachmentType: attachments[i].contentType,
                            companyId
                        });
                        // queue.create('upload-attachments', {
                        //     filename
                        // }).delay(5000).removeOnComplete(true).save();
                    }
                    await db.Attachment.insertMany(attachment);
                }
            } catch(err) {
                console.log("Error From attachments save",err);
            } finally {
                done();
            }
        })

        queue.process('upload-attachments', async (job, done) => {
            try {
                const { filename } = job.data;
                s3.upload_on_s3(filename);
            } catch (error) {
                console.log(err);
            } finally {
                done()
            }
        })

        queue.process('email-reported-who-else-outlook', async (job, done) => {
            const { from, subject, reportedMailId, domainId, companyId, internetMessageId, mailAction } = job.data;
            const domain = await db.Domain.findOne({ _id: domainId, companyId, deletedAt: null });
            try {
                console.log({domain})
                if(domain){
                    if(domain.isCredential){
                        const { token } = await Credentials.getCredentials(companyId, domainId);
                        console.log(`[WHOELSE][TOKEN-ACQUIRED] reportedMailId=${reportedMailId} domainId=${domainId} tokenChars=${token && token.access_token ? token.access_token.length : 0}`)
                        let groupsWithEmailAccess = await db.Group.find({ companyId, deletedAt: null, emailAccess: true }).select('_id')
                        groupsWithEmailAccess = groupsWithEmailAccess?.map(group=> group._id)

                        const users = await db.User.find({
                            domainId, companyId,
                            isActive: true,
                            groups: {$in: groupsWithEmailAccess },
                            deletedAt: null
                        })
                        console.log({users})
                        console.log(`[WHOELSE][START] reportedMailId=${reportedMailId} companyId=${companyId} domainId=${domainId} totalUsers=${users.length} subject="${subject}" from="${from}" internetMessageId="${internetMessageId}" mailAction=${mailAction || 'none'}`);
                        if(users.length > 0){
                            // mark metadata row as processing now (previously remained false until completion)
                            const metaStart = await db.WhoElseMetaData.updateOne({ reportedMailId, companyId, domainId }, { $set: { isProcessing: true } });
                            console.log(`[WHOELSE][DOMAIN-META-START] reportedMailId=${reportedMailId} domainId=${domainId} matched=${metaStart.matchedCount} modified=${metaStart.modifiedCount}`)
                            let userLength = users.length;
                            let workerPool = WorkerCon.get();
                            console.time(`total processing whoelse time ${reportedMailId}-${domainId}`);
                            
                            let batchRequests = []
                            let totalUsers = userLength
                            let processedUsers = 0;
                            for(let i=0; i<userLength; i++){
                                let isLast = ((i + 1) == userLength);
                                batchRequests.push({ 
                                    index: i + 1,
                                    token: token.access_token,
                                    subject,
                                    from,
                                    isLast,
                                    reportedMailId,
                                    internetMessageId,
                                    domainId,
                                    companyId,
                                    name: users[i].name,
                                    email: users[i].email,
                                    userId: users[i].userId,
                                    emailUserId: users[i]._id.toHexString()
                                })
                                
                                if(batchRequests.length == 20){
                                    const currentBatchSize = batchRequests.length; // should be 20 but keep generic
                                    const batch = ((i+1)/20)
                                    console.time(`processing done whoelse batch - ${batch} - ${reportedMailId} - ${domainId}`);
                                    console.log(`[WHOELSE][BATCH-DISPATCH] reportedMailId=${reportedMailId} domainId=${domainId} batch=${batch} size=${currentBatchSize} processedUsersSoFar=${processedUsers} totalUsers=${totalUsers}`)
                                    const toProcess = batchRequests;
                                    batchRequests=[]; // clear early to avoid accidental reuse
                                    workerPool.whoElseOutlook(toProcess)
                                        .then(( mailResults ) => {
                                            const resultCount = (mailResults && mailResults.length) || 0;
                                            processedUsers += currentBatchSize;
                                            console.log(`[WHOELSE][BATCH-RESULT] reportedMailId=${reportedMailId} domainId=${domainId} batch=${batch} mailResults=${resultCount} processedUsers=${processedUsers}/${totalUsers}`)
                                            queue.create('outlook-who-else-event', { mailResults, totalUsers, processedUsers, reportedMailId, mailAction, companyId, domainId }).removeOnComplete(true).priority('high').save();
                                            console.timeEnd(`processing done whoelse batch - ${batch} - ${reportedMailId} - ${domainId}`);
                                        })
                                        .catch( async (err) => {
                                            processedUsers += currentBatchSize;
                                            console.log(`[WHOELSE][BATCH-ERROR] reportedMailId=${reportedMailId} domainId=${domainId} batch=${batch} size=${currentBatchSize} error=${err && err.message ? err.message : err}`)
                                            if(totalUsers == processedUsers){
                                                await db.WhoElseMetaData.updateOne({
                                                    reportedMailId, companyId, domainId
                                                },{
                                                    isProcessing: false,
                                                    isCompleted: true,
                                                    isError: true,
                                                    errorMessage: 'Error From Workerpool'
                                                })
                                                updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId)
                                            }
                                            console.timeEnd(`processing done whoelse batch - ${batch} - ${reportedMailId} - ${domainId}`);
                                        })
                                }
                            }
                            if(batchRequests.length != 0){
                                console.time(`processing done last whoelse batch ${reportedMailId}-${domainId}`);
                                console.log(`[WHOELSE][LAST-BATCH-DISPATCH] reportedMailId=${reportedMailId} domainId=${domainId} size=${batchRequests.length} processedUsersSoFar=${processedUsers} totalUsers=${totalUsers}`)
                                const lastBatchSize = batchRequests.length;
                                const toProcessLast = batchRequests;
                                batchRequests = [];
                                workerPool.whoElseOutlook(toProcessLast)
                                    .then(( mailResults ) => {
                                        const resultCount = (mailResults && mailResults.length) || 0;
                                        processedUsers += lastBatchSize;
                                        console.log(`[WHOELSE][LAST-BATCH-RESULT] reportedMailId=${reportedMailId} domainId=${domainId} lastBatchSize=${lastBatchSize} mailResults=${resultCount} processedUsers=${processedUsers}/${totalUsers}`)
                                        queue.create('outlook-who-else-event', { mailResults, totalUsers, processedUsers, reportedMailId, mailAction, companyId, domainId }).removeOnComplete(true).priority('high').save();
                                        console.timeEnd(`processing done last whoelse batch ${reportedMailId}-${domainId}`);
                                    })
                                    .catch(async err => {
                                        processedUsers += lastBatchSize;
                                        console.log(`[WHOELSE][LAST-BATCH-ERROR] reportedMailId=${reportedMailId} domainId=${domainId} size=${lastBatchSize} error=${err && err.message ? err.message : err}`)
                                        if(totalUsers == processedUsers){
                                            await db.WhoElseMetaData.updateOne({
                                                reportedMailId, companyId, domainId
                                            },{
                                                isProcessing: false,
                                                isCompleted: true,
                                                isError: true,
                                                errorMessage: "Error From Workerpool"
                                            })
                                        }
                                        updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId) 
                                    })
                            }
                            // After scheduling all batches, log if processedUsers already equals totalUsers (edge case) or mismatch
                            if(processedUsers === totalUsers){
                                console.log(`[WHOELSE][POST-DISPATCH-STATE] reportedMailId=${reportedMailId} domainId=${domainId} processedUsers=${processedUsers} totalUsers=${totalUsers} note="All users accounted for immediately after dispatch (possible zero users in last batch)."`)
                            } else if (processedUsers > totalUsers){
                                console.log(`[WHOELSE][ANOMALY] reportedMailId=${reportedMailId} domainId=${domainId} processedUsers=${processedUsers} exceeds totalUsers=${totalUsers}`)
                            } else {
                                console.log(`[WHOELSE][POST-DISPATCH-PENDING] reportedMailId=${reportedMailId} domainId=${domainId} processedUsers=${processedUsers}/${totalUsers}`)
                            }
                        } else {
                            console.log(`[WHOELSE][NO-USERS] reportedMailId=${reportedMailId} domainId=${domainId} reason="Domain Users not found"`)
                            await db.WhoElseMetaData.updateOne({
                                reportedMailId, companyId, domainId
                            },{
                                isProcessing: false,
                                isCompleted: true,
                                isError: true,
                                errorMessage: "Domain Users not found"
                            })
                            updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId) 

                        }
                    } else {
                        console.log(`[WHOELSE][CREDENTIAL-MISSING] reportedMailId=${reportedMailId} domainId=${domainId} reason="Domain Credentials Not Found"`)
                        await db.WhoElseMetaData.updateOne({
                            reportedMailId, companyId, domainId
                        },{
                            isProcessing: false,
                            isCompleted: true,
                            isError: true,
                            errorMessage: "Domain Credentials Not Found"
                        })
                        updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId) 

                    }
                } else {
                    console.log(`[WHOELSE][DOMAIN-NOT-FOUND] reportedMailId=${reportedMailId} domainId=${domainId}`)
                    await db.WhoElseMetaData.updateOne({
                        reportedMailId, companyId, domainId
                    },{
                        isProcessing: false,
                        isCompleted: true,
                        isError: true,
                        errorMessage: "Domain Not Found"
                    })

                    updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId) 

                }
            } catch (err) {
                console.log(`[WHOELSE][UNCAUGHT-ERROR] reportedMailId=${reportedMailId} domainId=${domainId} error=${err && err.message ? err.message : err}`)
                await db.WhoElseMetaData.updateOne({
                    reportedMailId, companyId, domainId
                },{
                    isProcessing: false,
                    isCompleted: true,
                    isError: true,
                    errorMessage: JSON.stringify(err)
                })
                updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId) 

            } finally {
                done();
            }
        }),

        queue.process('email-reported-similiar-emails-outlook', async (job, done) => {
            const { from, subject, reportedMailId, domainId, companyId, internetMessageId, mailRecievedTime } = job.data;
            const domain = await db.Domain.findOne({ _id: domainId, companyId, deletedAt: null });
            try {
                if(domain){
                    if(domain.isCredential){
                        const { token } = await Credentials.getCredentials(companyId, domainId);
                        let groupsWithEmailAccess = await db.Group.find({ companyId, deletedAt: null, emailAccess: true }).select('_id');
                        groupsWithEmailAccess = groupsWithEmailAccess?.map(group=> group._id);
                        const users = await db.User.find({ domainId, companyId, isActive: true, groups: {$in: groupsWithEmailAccess }, deletedAt: null });
                        console.log(`[SIMILAR][START] reportedMailId=${reportedMailId} companyId=${companyId} domainId=${domainId} totalUsers=${users.length} subject="${subject}" from="${from}" internetMessageId="${internetMessageId}" mailReceivedTime=${mailRecievedTime}`);
                        if(users.length > 0){
                            // mark metadata as processing early
                            const metaStart = await db.SimiliarEmailMetdata.updateOne({ reportedMailId, companyId, domainId }, { $set: { isProcessing: true } });
                            console.log(`[SIMILAR][DOMAIN-META-START] reportedMailId=${reportedMailId} domainId=${domainId} matched=${metaStart.matchedCount} modified=${metaStart.modifiedCount}`);
                            let userLength = users.length;
                            let workerPool = WorkerCon.get();
                            console.time(`total processing similiar email time ${reportedMailId}-${domainId}`);
                            let batchRequests = [];
                            let totalUsers = userLength;
                            let processedUsers = 0;
                            for(let i=0; i<userLength; i++){
                                let isLast = ((i + 1) == userLength);
                                batchRequests.push({ 
                                    index: i + 1,
                                    token: token.access_token,
                                    subject,
                                    from,
                                    isLast,
                                    reportedMailId,
                                    internetMessageId,
                                    domainId,
                                    companyId,
                                    name: users[i].name,
                                    email: users[i].email,
                                    userId: users[i].userId,
                                    emailUserId: users[i]._id.toHexString(),
                                    mailRecievedTime
                                });
                                if(batchRequests.length === 20){
                                    const currentBatchSize = batchRequests.length;
                                    const batch = ((i+1)/20);
                                    console.time(`processing done similiar email batch - ${batch} - ${reportedMailId} - ${domainId}`);
                                    console.log(`[SIMILAR][BATCH-DISPATCH] reportedMailId=${reportedMailId} domainId=${domainId} batch=${batch} size=${currentBatchSize} processedUsersSoFar=${processedUsers} totalUsers=${totalUsers}`);
                                    const toProcess = batchRequests;
                                    batchRequests = [];
                                    workerPool.similiarSearchOutlook(toProcess)
                                        .then(( mailResults ) => {
                                            const resultCount = (mailResults && mailResults.length) || 0;
                                            processedUsers += currentBatchSize;
                                            console.log(`[SIMILAR][BATCH-RESULT] reportedMailId=${reportedMailId} domainId=${domainId} batch=${batch} mailResults=${resultCount} processedUsers=${processedUsers}/${totalUsers}`);
                                            queue.create('outlook-similiar-emails-event', { mailResults, totalUsers, processedUsers, reportedMailId, companyId, domainId }).removeOnComplete(true).priority('high').save();
                                            console.timeEnd(`processing done similiar email batch - ${batch} - ${reportedMailId} - ${domainId}`);
                                        })
                                        .catch(async (err) => {
                                            processedUsers += currentBatchSize;
                                            console.log(`[SIMILAR][BATCH-ERROR] reportedMailId=${reportedMailId} domainId=${domainId} batch=${batch} size=${currentBatchSize} error=${err && err.message ? err.message : err}`);
                                            if(totalUsers === processedUsers){
                                                await db.SimiliarEmailMetdata.updateOne({ reportedMailId, companyId, domainId }, { isProcessing: false, isCompleted: true, isError: true, errorMessage: 'Error From Workerpool' });
                                                updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
                                            }
                                            console.timeEnd(`processing done similiar email batch - ${batch} - ${reportedMailId} - ${domainId}`);
                                        });
                                }
                            }
                            if(batchRequests.length !== 0){
                                console.time(`processing done last similiar search batch ${reportedMailId}-${domainId}`);
                                console.log(`[SIMILAR][LAST-BATCH-DISPATCH] reportedMailId=${reportedMailId} domainId=${domainId} size=${batchRequests.length} processedUsersSoFar=${processedUsers} totalUsers=${totalUsers}`);
                                const lastBatchSize = batchRequests.length;
                                const toProcessLast = batchRequests;
                                batchRequests = [];
                                workerPool.similiarSearchOutlook(toProcessLast)
                                    .then(( mailResults ) => {
                                        const resultCount = (mailResults && mailResults.length) || 0;
                                        processedUsers += lastBatchSize;
                                        console.log(`[SIMILAR][LAST-BATCH-RESULT] reportedMailId=${reportedMailId} domainId=${domainId} lastBatchSize=${lastBatchSize} mailResults=${resultCount} processedUsers=${processedUsers}/${totalUsers}`);
                                        queue.create('outlook-similiar-emails-event', { mailResults, totalUsers, processedUsers, reportedMailId, companyId, domainId }).removeOnComplete(true).priority('high').save();
                                        console.timeEnd(`processing done last similiar search batch ${reportedMailId}-${domainId}`);
                                    })
                                    .catch(async err => {
                                        processedUsers += lastBatchSize;
                                        console.log(`[SIMILAR][LAST-BATCH-ERROR] reportedMailId=${reportedMailId} domainId=${domainId} size=${lastBatchSize} error=${err && err.message ? err.message : err}`);
                                        if(totalUsers === processedUsers){
                                            await db.SimiliarEmailMetdata.updateOne({ reportedMailId, companyId, domainId }, { isProcessing: false, isCompleted: true, isError: true, errorMessage: 'Error From Workerpool' });
                                        }
                                        updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
                                    });
                            }
                            if(processedUsers === totalUsers){
                                console.log(`[SIMILAR][POST-DISPATCH-STATE] reportedMailId=${reportedMailId} domainId=${domainId} processedUsers=${processedUsers} totalUsers=${totalUsers} note="All users accounted for immediately after dispatch."`);
                            } else if(processedUsers > totalUsers){
                                console.log(`[SIMILAR][ANOMALY] reportedMailId=${reportedMailId} domainId=${domainId} processedUsers=${processedUsers} exceeds totalUsers=${totalUsers}`);
                            } else {
                                console.log(`[SIMILAR][POST-DISPATCH-PENDING] reportedMailId=${reportedMailId} domainId=${domainId} processedUsers=${processedUsers}/${totalUsers}`);
                            }
                        } else {
                            console.log(`[SIMILAR][NO-USERS] reportedMailId=${reportedMailId} domainId=${domainId} reason="Domain Users not found"`);
                            await db.SimiliarEmailMetdata.updateOne({ reportedMailId, companyId, domainId }, { isProcessing: false, isCompleted: true, isError: true, errorMessage: "Domain Users not found" });
                            updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
                        }
                    } else {
                        console.log(`[SIMILAR][CREDENTIAL-MISSING] reportedMailId=${reportedMailId} domainId=${domainId} reason="Domain Credentials Not Found"`);
                        await db.SimiliarEmailMetdata.updateOne({ reportedMailId, companyId, domainId }, { isProcessing: false, isCompleted: true, isError: true, errorMessage: "Domain Credentials Not Found" });
                        updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
                    }
                } else {
                    console.log(`[SIMILAR][DOMAIN-NOT-FOUND] reportedMailId=${reportedMailId} domainId=${domainId}`);
                    await db.SimiliarEmailMetdata.updateOne({ reportedMailId, companyId, domainId }, { isProcessing: false, isCompleted: true, isError: true, errorMessage: "Domain Not Found" });
                    updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
                }
            } catch (err) {
                console.log(`[SIMILAR][UNCAUGHT-ERROR] reportedMailId=${reportedMailId} domainId=${domainId} error=${err && err.message ? err.message : err}`);
                await db.SimiliarEmailMetdata.updateOne({ reportedMailId, companyId, domainId }, { isProcessing: false, isCompleted: true, isError: true, errorMessage: JSON.stringify(err) });
                updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
            } finally {
                done();
            }
        }),

        queue.process('outlook-similiar-emails-event', async (job, done) => {
            const { mailResults: users, totalUsers, processedUsers, reportedMailId, mailAction, companyId, domainId } = job.data;
            try {
                console.log('[SIMILAR][EVENT-PAYLOAD]', job.data);
                for(let i =0; i<users.length; i++){
                    console.log(`[SIMILAR][USER-RESULT] ${users[i].email} - ${users[i].foundInInbox ? "Inbox" : "Trash"}`);
                    if(users[i].from.toLowerCase() === users[i].email.toLowerCase()) { console.log(`[SIMILAR][SKIP-SENDER] ${users[i].email}`); continue }
                    await db.SimiliarEmail.create({
                        reportedMailId: users[i].reportedMailId,
                        name: users[i].name,
                        from: users[i].from,
                        subject: users[i].subject,
                        domainId: users[i].domainId,
                        companyId: users[i].companyId,
                        messageId: users[i].messageId,
                        internetMessageId: users[i].internetMessageId,
                        threadId: null,
                        to: users[i].email,
                        userId: users[i].emailUserId,
                        isTrashed: users[i].foundInTrash ? true : false,
                        folderId: users[i].folderId
                    });
                }
                if(totalUsers === processedUsers){
                    try {
                        const metaBefore = await db.SimiliarEmailMetdata.findOne({reportedMailId, companyId, domainId}).lean();
                        console.log(`[SIMILAR][DOMAIN-PRE-FINALIZE] reportedMailId=${reportedMailId} domainId=${domainId} meta=%j`, metaBefore);
                    } catch(inspectErr){
                        console.log(`[SIMILAR][DOMAIN-PRE-FINALIZE-ERROR] reportedMailId=${reportedMailId} domainId=${domainId} error=${inspectErr && inspectErr.message ? inspectErr.message : inspectErr}`);
                    }
                    const update = await db.SimiliarEmailMetdata.updateOne({ reportedMailId, companyId, domainId }, { isProcessing: false, isCompleted: true, isError: false, errorMessage: null });
                    console.log(`[SIMILAR][DOMAIN-METADATA-UPDATED] reportedMailId=${reportedMailId} domainId=${domainId} matched=${update.matchedCount} modified=${update.modifiedCount}`);
                    console.log(`[SIMILAR][DOMAIN-COMPLETED] reportedMailId=${reportedMailId} companyId=${companyId} domainId=${domainId} totalUsers=${totalUsers} processedUsers=${processedUsers}`);
                    updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
                    console.timeEnd(`total processing similiar email time ${reportedMailId}-${domainId}`);
                }
            } catch (err) {
                console.log(`[SIMILAR][DOMAIN-ERROR] reportedMailId=${reportedMailId} companyId=${companyId} domainId=${domainId} error=${err && err.message ? err.message : err}`);
                await db.SimiliarEmailMetdata.updateOne({ reportedMailId, companyId, domainId }, { isProcessing: false, isCompleted: true, isError: true, errorMessage: "outlook-similiar-emails-event" });
                updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId);
            } finally {
                done();
            }
        }),

        queue.process('outlook-who-else-event', async (job, done) => {
            try {
                const { mailResults: users, totalUsers, processedUsers, reportedMailId, mailAction, companyId, domainId } = job.data
                console.log(job.data)
                const bannerMeta = await db.MetaData.findOne({ companyId, name: 'BannerMessage', deletedAt: null });
                const hasBanner = !!(bannerMeta && bannerMeta.value);
                for(let i =0; i<users.length; i++){
                    console.log(`${users[i].email} - ${users[i].foundInInbox ? "\x1b[32mInbox\x1b[0m" : "\x1b[31mTrash\x1b[0m"} `)
                    if(users[i].from.toLowerCase() == users[i].email.toLowerCase()) {console.log(`${users[i].email} - This the sender of email, skipping this user  ${users[i].foundInInbox ? "\x1b[32mInbox\x1b[0m" : "\x1b[31mTrash\x1b[0m"} `); continue}

                    const whoElseDoc = await db.WhoElse.create({
                                reportedMailId: users[i].reportedMailId,
                                name: users[i].name,
                                from: users[i].from,
                                subject: users[i].subject,
                                domainId: users[i].domainId,
                                companyId: users[i].companyId,
                                messageId: users[i].messageId,
                                internetMessageId: users[i].internetMessageId,
                                threadId: null,
                                to: users[i].email,
                                whoelseMail: users[i].email,
                                userId: users[i].emailUserId,
                                isTrashed: users[i].foundInTrash? true: false,
                                folderId: users[i].folderId
                    }) 
                    
                    if (hasBanner && !users[i].foundInTrash) {
                        queue.create('inject-banner-outlook', {
                            whoElseId: whoElseDoc._id.toHexString(),
                            companyId,
                            domainId,
                        })
                        .delay(2000)
                        .priority('high')
                        .removeOnComplete(true)
                        .save();

                        console.log(`queued inject-banner-outlook for ${users[i].email}`);
                    }
                }
                if(totalUsers == processedUsers){
                    try {
                        const metaBefore = await db.WhoElseMetaData.findOne({reportedMailId, companyId, domainId}).lean();
                        console.log(`[WHOELSE][DOMAIN-PRE-FINALIZE] reportedMailId=${reportedMailId} domainId=${domainId} meta=%j`, metaBefore);
                    } catch (inspectErr){
                        console.log(`[WHOELSE][DOMAIN-PRE-FINALIZE-ERROR] reportedMailId=${reportedMailId} domainId=${domainId} error=${inspectErr && inspectErr.message ? inspectErr.message : inspectErr}`)
                    }
                    let update = await db.WhoElseMetaData.updateOne({
                        reportedMailId, companyId, domainId
                    },{
                        isProcessing: false,
                        isCompleted: true,
                        isError: false,
                        errorMessage: null
                    })
                    console.log(`[WHOELSE][DOMAIN-METADATA-UPDATED] reportedMailId=${reportedMailId} domainId=${domainId} matched=${update.matchedCount} modified=${update.modifiedCount}`)
                    console.log(`[WHOELSE][DOMAIN-COMPLETED] reportedMailId=${reportedMailId} companyId=${companyId} domainId=${domainId} totalUsers=${totalUsers} processedUsers=${processedUsers} mailAction=${mailAction || 'none'}`)
                    updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId)


                    if(mailAction){
                        console.log(`[WHOELSE][MAIL-ACTION-TRIGGER] reportedMailId=${reportedMailId} action=${mailAction}`)
                        callMailActionApi(reportedMailId, mailAction)
                    }
                    console.timeEnd(`total processing whoelse time ${reportedMailId}-${domainId}`);
                }
            } catch (err) {
                console.log(`[WHOELSE][DOMAIN-ERROR] reportedMailId=${reportedMailId} companyId=${companyId} domainId=${domainId} error=${err && err.message ? err.message : err}`)
                console.log(err);
            } finally {
                done();
            }
        }),

        queue.process('email-reported-who-else-gsuite', async (job, done) => {
            console.log(job.data);
            const { email, from, subject, reportedMailId, domainId, companyId, internetMessageId, mailAction } = job.data;
            try {
                const domain = await db.Domain.findOne({ _id: domainId, companyId, deletedAt: null});
                if(domain){
                    if(domain.isCredential){
                        const { fileName } = await Credentials.getCredentials(companyId, domainId);
                        
                        let groupsWithEmailAccess = await db.Group.find({ companyId, deletedAt: null, emailAccess: true }).select('_id')
                        groupsWithEmailAccess = groupsWithEmailAccess?.map(group=> group._id)

                        const users = await db.User.find({
                            domainId, companyId,
                            isActive: true,
                            groups: {$in: groupsWithEmailAccess },
                            deletedAt: null
                        })
                        console.log('fount total user for whoelse', users.length );
                        if(users.length > 0){
                            
                            let userLength = users.length;
                            let workerPool = WorkerCon.get();
                            console.time(`total processing whoelse time ${reportedMailId}-${domainId}`);
                            for(let i=0; i<userLength; i++){
                                let isLast = ((i + 1) == userLength);
                                console.time(`processing done whoelse ${users[i]._id.toHexString()}-${domainId}`);
                                workerPool.whoElseGsuite({ 
                                    index: i+1, 
                                    fileName, 
                                    subject, 
                                    isLast,
                                    from, 
                                    reportedMailId, 
                                    internetMessageId,
                                    domainId,
                                    companyId, 
                                    to:email,
                                    name: users[i].name,
                                    email: users[i].email,
                                    userId: users[i].userId,
                                    emailUserId: users[i]._id.toHexString()
                                })
                                .then(data => {
                                    queue.create('gsuite-who-else-event', {  data, mailAction }).removeOnComplete(true).priority('high').save();
                                    console.timeEnd(`processing done whoelse ${data.emailUserId}-${domainId}`);
                                })
                                .catch(async err => {
                                    if(isLast){
                                        console.log('gsuite------------',err)
                                        await db.WhoElseMetaData.updateOne({
                                            reportedMailId, companyId, domainId
                                        },{
                                            isProcessing: false,
                                            isCompleted: true,
                                            isError: true,
                                            errorMessage: 'Error From Workerpool'
                                        })
                                        updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId)
                                    }
                                })
                            }
                        } else {
                            await db.WhoElseMetaData.updateOne({
                                reportedMailId, companyId, domainId
                            },{
                                isProcessing: false,
                                isCompleted: true,
                                isError: true,
                                errorMessage: "Domain Users not found"
                            })
                            updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId)
                        }
                    } else {
                        await db.WhoElseMetaData.updateOne({
                            reportedMailId, companyId, domainId
                        },{
                            isProcessing: false,
                            isCompleted: true,
                            isError: true,
                            errorMessage: "Domain Credentials not found"
                        })
                        updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId)
                    }
                } else {
                    await db.WhoElseMetaData.updateOne({
                        reportedMailId, companyId, domainId
                    },{
                        isProcessing: false,
                        isCompleted: true,
                        isError: true,
                        errorMessage: "Domain not found"
                    })
                    updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId)
                }
            } catch (err) {
                await db.WhoElseMetaData.updateOne({
                    reportedMailId, companyId, domainId
                },{
                    isProcessing: false,
                    isCompleted: true,
                    isError: true,
                    errorMessage: JSON.stringify(err)
                })
                updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId)
            } finally {
                done();
            }
        }),

        queue.process('email-reported-similiar-emails-gsuite', async (job, done) => {
            console.log(job.data);
            let { email, from, subject, reportedMailId, domainId, companyId, internetMessageId } = job.data;
            try {
                const domain = await db.Domain.findOne({ _id: domainId, companyId, deletedAt: null});
                if(domain){
                    if(domain.isCredential){
                        const { fileName } = await Credentials.getCredentials(companyId, domainId);
                        
                        let groupsWithEmailAccess = await db.Group.find({ companyId, deletedAt: null, emailAccess: true }).select('_id')
                        groupsWithEmailAccess = groupsWithEmailAccess?.map(group=> group._id)

                        const users = await db.User.find({
                            domainId, companyId,
                            isActive: true,
                            groups: {$in: groupsWithEmailAccess },
                            deletedAt: null
                        })
                        console.log('fount total user for similiar emails', users.length );
                        if(users.length > 0){
                            await db.ReportedMail.updateOne({
                                _id: reportedMailId, companyId
                            }, {
                                syncStartAt: new Date(),
                                isSimilarEmailError: false,
                                isSimiliarEmailProcessing: true,
                                isSimiliarEmailErrorMessage: ""
                            })
                            let userLength = users.length;
                            let workerPool = WorkerCon.get();
                            console.time(`total processing similiar email time ${reportedMailId}-${domainId}`);

                            subject = cleanDictionaryAndSpecialChars(subject)

                            for(let i=0; i<userLength; i++){
                                let isLast = ((i + 1) == userLength);
                                console.time(`processing done similiar emails ${users[i]._id.toHexString()}-${domainId}`);
                                workerPool.similiarSearchGsuite({ 
                                    index: i+1, 
                                    fileName, 
                                    subject, 
                                    isLast,
                                    from, 
                                    reportedMailId, 
                                    internetMessageId,
                                    domainId,
                                    companyId, 
                                    to:email,
                                    name: users[i].name,
                                    email: users[i].email,
                                    userId: users[i].userId,
                                    emailUserId: users[i]._id.toHexString()
                                })
                                .then(data => {
                                    console.log({data})
                                    queue.create('gsuite-similiar-emails-event', { data }).removeOnComplete(true).priority('high').save();
                                    console.timeEnd(`processing done similiar emails ${data.emailUserId}-${domainId}`);
                                })
                                .catch(async err => {
                                    if(isLast){
                                        console.log('gsuite------------',err)
                                        await db.SimiliarEmailMetdata.updateOne({
                                            reportedMailId, companyId, domainId
                                        },{
                                            isProcessing: false,
                                            isCompleted: true,
                                            isError: true,
                                            errorMessage: 'Error From Workerpool'
                                        })
                                        updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId)
                                    }
                                })
                            }
                        } else {
                            await db.SimiliarEmailMetdata.updateOne({
                                reportedMailId, companyId, domainId
                            },{
                                isProcessing: false,
                                isCompleted: true,
                                isError: true,
                                errorMessage: "Domain Users not found"
                            })
                            updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId)
                        }
                    } else {
                        await db.SimiliarEmailMetdata.updateOne({
                            reportedMailId, companyId, domainId
                        },{
                            isProcessing: false,
                            isCompleted: true,
                            isError: true,
                            errorMessage: "Domain Credentials not found"
                        })
                        updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId)
                    }
                } else {
                    await db.SimiliarEmailMetdata.updateOne({
                        reportedMailId, companyId, domainId
                    },{
                        isProcessing: false,
                        isCompleted: true,
                        isError: true,
                        errorMessage: "Domain not found"
                    })
                    updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId)
                }
            } catch (err) {
                await db.SimiliarEmailMetdata.updateOne({
                    reportedMailId, companyId, domainId
                },{
                    isProcessing: false,
                    isCompleted: true,
                    isError: true,
                    errorMessage: JSON.stringify(err)
                })
                updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId)
            } finally {
                done();
            }
        }),

        queue.process('gsuite-similiar-emails-event', async (job, done) => {
            const {  name, from, subject, reportedMailId, companyId, domainId, emailUserId, email, isLast, isMailFound, internetMessageId } = job.data.data;
            try {
                if (isMailFound) {
                    let threadId = isMailFound.threadId;
                    let messageId = isMailFound.messageId;
                    await db.SimiliarEmail.create({
                        reportedMailId,
                        from,
                        subject: isMailFound.subject,
                        domainId,
                        companyId,
                        messageId,
                        threadId,
                        internetMessageId,
                        name,
                        to: email,
                        whoelseMail: email,
                        userId: emailUserId,
                        isTrashed: isMailFound.isTrashed
                    })
                }
                if(isLast){
                    await db.SimiliarEmailMetdata.updateOne({
                        reportedMailId, companyId, domainId
                    },{
                        isProcessing: false,
                        isCompleted: true,
                        isError: false,
                        errorMessage: null
                    })
                    updateReportedMailIfEveryDomainSimiliarSearchCompleted(reportedMailId, companyId)

                    console.timeEnd(`total processing similiar email time ${reportedMailId}-${domainId}`);
                }
            } catch (err) {
                await db.SimiliarEmailMetdata.updateOne(
                  {
                    reportedMailId,
                    companyId,
                    domainId,
                  },
                  {
                    isProcessing: false,
                    isCompleted: true,
                    isError: true,
                    errorMessage: "gsuite-similiar-emails-event",
                  }
                );
                updateReportedMailIfEveryDomainSimiliarSearchCompleted(
                  reportedMailId,
                  companyId
                );
                console.log(err);
            } finally {
                done();
            }
        }),

        queue.process('gsuite-who-else-event', async (job, done) => {
            try {
                const { to, name, from, subject, reportedMailId, companyId, domainId, emailUserId, email, isLast, isMailFound, foundInTrash, internetMessageId } = job.data.data;
                const { mailAction } = job.data
                if (isMailFound) {
                    let threadId = isMailFound.threadId;
                    let messageId = isMailFound.messageId;
                    await db.WhoElse.create({
                        reportedMailId,
                        from,
                        subject,
                        domainId,
                        companyId,
                        messageId,
                        threadId,
                        internetMessageId,
                        name,
                        to: email,
                        whoelseMail: email,
                        userId: emailUserId,
                        isTrashed: isMailFound.isTrashed
                    })
                }
                if(isLast){
                    await db.WhoElseMetaData.updateOne({
                        reportedMailId, companyId, domainId
                    },{
                        isProcessing: false,
                        isCompleted: true,
                        isError: false,
                        errorMessage: null
                    })
                    updateReportedMailIfEveryDomainCompleted(reportedMailId, companyId)

                    if(mailAction) callMailActionApi(reportedMailId, mailAction)
                    console.timeEnd(`total processing whoelse time ${reportedMailId}-${domainId}`);
                }
            } catch (err) {
                console.log(err);
            } finally {
                done();
            }
        }),

        queue.process('process-advanced-search-outlook', async (job, done) => {
            const { companyId, domainId, from, to, subject, fromDate, toDate, advanceSearchId, filter } = job.data;
            try{
                const { token } = await Credentials.getCredentials(companyId, domainId);
                const condition = { 
                    domainId, 
                    companyId, 
                    isActive: true,
                    deletedAt:null
                };
                if(to && to.length) {
                    condition['email'] = to;
                }
                const users = await db.User.find(condition);
                if(users.length > 0){
                    let userLength = users.length;
                    let workerPool = WorkerCon.get();
                    console.time(`total processing advance search time`);
                    for(let i=0; i<userLength; i++){
                        let isLast = ((i + 1) == userLength);
                        console.time(`processing done advance search ${i+1}`);
                        let emailUserId = users[i]._id.toHexString();
                        workerPool.advancedSearchOutlook({ 
                            index: i+1, 
                            token: token.access_token, 
                            subject, 
                            isLast,
                            from, 
                            to: users[i].email,
                            advanceSearchId, 
                            companyId, 
                            fromDate, 
                            toDate,
                            filter,
                            domainId,
                            emailUserId,
                            userId: users[i].userId
                        })
                        .then(data => {
                            queue.create('process-advanced-search-event-outlook', data).removeOnComplete(true).priority('high').save();
                            console.timeEnd(`processing done advance search ${data.index}`);
                        })
                        .catch(err => {
                            console.log(err);
                        })
                    }
                } else {
                    await db.AdvanceSearch.updateOne({
                        _id: advanceSearchId, companyId
                    }, {
                        isError: true,
                        isProcessing: false,
                        syncEndAt: new Date,
                        isErrorMessage: "Domain Users not found"
                    })
                }
            } catch(err) {
                console.log(err);
                await db.AdvanceSearch.updateOne({
                    _id: advanceSearchId, companyId
                }, {
                    isError: true,
                    isProcessing: false,
                    syncEndAt: new Date,
                    isErrorMessage: err
                })
            } finally {
                done();
            }
        })

        queue.process('process-advanced-search-event-outlook', async (job, done) => {
            try{
                const { isMailFound, foundInTrash, advanceSearchId, emailUserId, companyId, domainId, isLast, to } = job.data;
                if(isMailFound){
                    let data = [];
                    for(let i=0; i<isMailFound.length; i++){
                        data.push({
                            userId: emailUserId,
                            from: isMailFound[i].from.emailAddress.address,
                            fromName: isMailFound[i].from.emailAddress.name,
                            isTrashed: foundInTrash,
                            messageId: isMailFound[i].id,
                            subject: isMailFound[i].subject,
                            body: isMailFound[i].body.content,
                            to: to,
                            cc: isMailFound[i].ccRecipients,
                            advanceSearchId, companyId, domainId,
                            mailRecievedTime: isMailFound[i].receivedDateTime
                        })
                    }
                    await db.AdvanceSearchEmail.insertMany(data);
                }
                if(isLast){
                    console.timeEnd(`total processing advance search time`);
                    await db.AdvanceSearch.updateOne({
                        _id: advanceSearchId, companyId
                    }, {
                        isError: false,
                        isProcessing: false,
                        syncEndAt: new Date,
                        isErrorMessage: ""
                    })
                }
            } catch(err) {
                console.log(err);
            } finally {
                done();
            }
        })

        queue.process('process-advanced-search-gsuite', async (job, done) => {
            const { companyId, domainId, from, to, subject, fromDate, toDate, advanceSearchId, filter } = job.data;
            try{
                const { fileName } = await Credentials.getCredentials(companyId, domainId);
                const condition = { 
                    domainId, 
                    companyId, 
                    isActive: true,
                    deletedAt:null
                };
                if(to && to.length) {
                    condition['email'] = to;
                }
                const users = await db.User.find(condition);
                if(users.length > 0){
                    let userLength = users.length;
                    let workerPool = WorkerCon.get();
                    console.time(`total processing advance search time ${advanceSearchId}`);
                    for(let i=0; i<userLength; i++){
                        let isLast = ((i + 1) == userLength);
                        console.time(`processing done advance search ${i+1}`);
                        let emailUserId = users[i]._id.toHexString();
                        workerPool.advancedSearchGsuite({ 
                            index: i+1, 
                            fileName, 
                            subject, 
                            isLast,
                            from, 
                            to: users[i].email,
                            advanceSearchId, 
                            companyId, 
                            fromDate, 
                            toDate,
                            filter,
                            domainId,
                            emailUserId,
                            userId: users[i].userId
                        })
                        .then(data => {
                            queue.create('process-advanced-search-event-gsuite', data).removeOnComplete(true).priority('high').save();
                            console.timeEnd(`processing done advance search ${data.index}`);
                        })
                        .catch(err => {
                            console.log(err);
                        })
                    }
                } else {
                    await db.AdvanceSearch.updateOne({
                        _id: advanceSearchId, companyId
                    }, {
                        isError: true,
                        isProcessing: false,
                        syncEndAt: new Date,
                        isErrorMessage: "Domain Users not found"
                    })
                }
            } catch(err) {
                console.log(err);
                await db.AdvanceSearch.updateOne({
                    _id: advanceSearchId, companyId
                }, {
                    isError: true,
                    isProcessing: false,
                    syncEndAt: new Date,
                    isErrorMessage: err
                })
            } finally {
                done();
            }
        })

        queue.process('process-advanced-search-event-gsuite', async (job, done) => {
            try{
                const { isMailFound, advanceSearchId, emailUserId, companyId, domainId, isLast } = job.data;
                if(isMailFound && isMailFound.length){
                    let data = [];
                    for(let i=0; i<isMailFound.length; i++){
                        data.push({
                            userId: emailUserId,
                            from: isMailFound[i].from,
                            fromName: '',
                            messageId: isMailFound[i].messageId,
                            threadId: isMailFound[i].threadId,
                            subject: isMailFound[i].subject,
                            body: isMailFound[i].body,
                            to: isMailFound[i].to,
                            cc: isMailFound[i].cc,
                            advanceSearchId, companyId, domainId,
                            mailRecievedTime: isMailFound[i].date
                        })
                    }
                    await db.AdvanceSearchEmail.insertMany(data);
                }
                if(isLast){
                    console.timeEnd(`total processing advance search time ${advanceSearchId}`);
                    await db.AdvanceSearch.updateOne({
                        _id: advanceSearchId, companyId
                    }, {
                        isError: false,
                        isProcessing: false,
                        syncEndAt: new Date,
                        isErrorMessage: ""
                    })
                }
            } catch(err) {
                console.log(err);
            } finally {
                done();
            }
        })
        
        queue.process('url-report', async (job, done) => {
            console.log('processing url result.....');
            const { data, urlId, companyId } = job.data;
            try{
                const { scan_id } = data;
                const apikey = await totalvirus.getApiKey(companyId);
                scanResultURL.processScanResult({
                    apikey: apikey,
                    scan_id: scan_id
                })
                .then(data => {
                    console.log(data);
                    let score = null;
                    if (typeof data.positives === 'number' && typeof data.total === 'number' && data.total > 0) {
                        score = (data.positives / data.total) * 100;
                    }
                    return db.Url.updateOne({
                        _id: urlId,
                    }, {
                        status: 'COMPLETED',
                        result: JSON.stringify(data),
                        score
                    })
                })
                .then(r => {
                    console.log('done url result.....');
                })
                .catch(err => {
                    console.log(err);
                    return db.Url.updateOne({
                        _id: urlId,
                    }, {
                        status: 'FAILED',
                        details: err
                    })
                })
            } catch(err){
                console.log(err);
                return db.Url.updateOne({
                    _id: urlId,
                }, {
                    status: 'FAILED',
                    details: err
                })
            } finally {
                done();
            }
        })

        queue.process('url-wa-report', async (job, done) => {
            console.log('processing url result.....');
            const { data, urlId, companyId } = job.data;
            try{
                const { scan_id } = data;
                const apikey = await totalvirus.getApiKey(companyId);
                scanResultURL.processScanResult({
                    apikey: apikey,
                    scan_id: scan_id
                })
                .then(data => {
                    console.log(data);
                    return db.Url.updateOne({
                        _id: urlId,
                    }, {
                        status: 'COMPLETED',
                        result: JSON.stringify(data),
                        score: (data.positives/data.total)*100
                    })
                })
                .then(r => {
                    console.log('done url result.....');
                })
                .catch(err => {
                    console.log(err);
                    return db.Url.updateOne({
                        _id: urlId,
                    }, {
                        status: 'FAILED',
                        details: err
                    })
                })
            } catch(err){
                console.log(err);
                return db.Url.updateOne({
                    _id: urlId,
                }, {
                    status: 'FAILED',
                    details: err
                })
            } finally {
                done();
            }
        })


        // queue.process('attachment-report', async (job, done) => {
        //     console.log('processing attachment result.....');
        //     const { data, attachmentId, companyId } = job.data;
        //     try{
        //         const { scan_id } = data;
        //         const apikey = await totalvirus.getApiKey(companyId);
        //         scanResultAttachment.processScanResult({
        //             apikey: apikey,
        //             scan_id: scan_id
        //         })
        //         .then(data => {
        //             console.log('Attachment report results',data)
        //             return db.Attachment.updateOne({
        //                 _id: attachmentId,
        //             }, {
        //                 status: 'COMPLETED',
        //                 result: data
        //             })
        //         })
        //         .then(r => {
        //             done();
        //             console.log('done attachment result.....');
        //         })
        //         .catch(err => {
        //             console.log(err);
        //             return db.Attachment.updateOne({
        //                 _id: attachmentId,
        //             }, {
        //                 status: 'FAILED',
        //                 details: JSON.stringify(err)
        //             })
        //         })
        //     } catch(err){
        //         return db.Attachment.updateOne({
        //             _id: attachmentId,
        //         }, {
        //             status: 'FAILED',
        //             details: JSON.stringify(err)
        //         })
        //     } finally {
        //         done();
        //     }
        // })

        queue.process('attachment-report', async (job, done) => {
            console.log('processing attachment result.....');
            const { data, attachmentId, companyId } = job.data;
            console.log('job.data',job.data)
            try{
                const { scan_id } = data;
                const apikey = await totalvirus.getApiKey(companyId);
                scanResultAttachment.processScanResult({
                    apikey: apikey,
                    scan_id: scan_id
                })
                .then(async data => {
                    console.log('Attachment report results',data)
                    if(data.response_code == 1 && data.scans){
                        await db.Attachment.updateOne({
                            _id: attachmentId,
                        }, {
                            status: 'COMPLETED',
                            result: data,
                            score: (data.positives/data.total)*100
                        })
                        done();
                    }
                    else {
                     return done(new Error('ReAttempting'));
                }
                })
                .catch(async err => {
                    await db.Attachment.updateOne({
                        _id: attachmentId,
                    }, {
                        status: 'IN PROGRESS',
                        details: JSON.stringify(err)
                    })
                    return done(new Error('ReAttempting'));
                })
            } catch(err){
                await db.Attachment.updateOne({
                    _id: attachmentId,
                }, {
                    status: 'FAILED',
                    details: JSON.stringify(err)
                })
                done();
            }
        })

        queue.process('report-email-score', async (job, done) => {
            try {
                const { reportedMailId, spamScore } = job.data;
                await db.ReportedMail.updateOne({_id:reportedMailId},{$set:{spamScore}})
                // console.time(`spamassession-${reportedMailId}`)
                // new Promise((resolve, reject) => {
                //     spamc.report(mailBody, function (err, result) {
                //         if(err) reject(err);
                //         else resolve(result);
                //     })
                // })
                // .then( result => {
                    // console.timeEnd(`spamassession-${reportedMailId}`)
//                     return db.ReportedMail.updateOne({
//                         _id: reportedMailId
//                     }, {
//                         spamScore
//                     })
                // })
            } catch(err){
                console.log(err);
            } finally {
                done();
            }
        })

        queue.process('report-email-score-exchange', async (job, done) => {
            try {
                const { reportedMailId, spamScore } = job.data;
                // console.time(`spamassession-${reportedMailId}`)
                // new Promise((resolve, reject) => {
                //     spamc.headers(headers, function (err, result) {
                //         if(err) reject(err);
                //         else resolve(result);
                //     })
                // })
                // .then( result => {
                //     console.timeEnd(`spamassession-${reportedMailId}`)
                    return db.ReportedMail.updateOne({
                        _id: reportedMailId
                    }, {
                        spamScore: spamScore
                    })
                // })
            } catch(err){
                console.log(err);
            } finally {
                done();
            }
        })

        queue.process('process-who-else-trash-batches-outlook', async (job, done) => {
            try {
                const { responses, emailReported, Trash, Recover, Delete, companyId } = job.data;
                if(Trash){
                    const updates = responses.map(async (response) => {
                        try {
                            if (response.status >= 200 && response.status < 300) {
                                let trash = await db.WhoElse.findByIdAndUpdate(response.id, { isTrashed: true, messageId: response.body.id });
                                console.log(`\x1b[31mTrashed:\x1b[0m ${trash.to}`)
                                let isReporter = emailReported?.reporters.find(reporter => reporter.email.toLowerCase() === trash.to.toLowerCase())


                                if(emailReported.to.toLowerCase() !== trash.to.toLowerCase() && !isReporter) mailer.sendResultMailToOtherReporters(trash.name ,trash.to, trash.from, trash.subject, emailReported.mailRecievedTime, 'Trashed', companyId)
                                else mailer.sendActionResultMail(trash.name ,trash.to, trash.from, trash.subject, emailReported.mailRecievedTime, 'TRASHED', false, null, companyId)
                            } else {
                                console.log(`Error Trashing Mail for ${response.id}`)
                                await db.WhoElse.findByIdAndUpdate(response.id, { isErrorWhileMoving: { isError: true, message: JSON.stringify(response.body) } });
                            }
                        } catch (error) {
                            console.log(`Error from record ${response.id} while trashing`,error)
                        }
                    });
                    await Promise.all(updates);
                }

                else if (Recover) {
                    console.log(`Recovering ${responses.length} emails`);

                    // --- ORIGINAL RECOVER FLOW (unchanged) ---
                    await Promise.all(
                        responses.map(async (response) => {
                        try {
                            if (response.status >= 200 && response.status < 300) {
                            const recover = await db.WhoElse.findByIdAndUpdate(
                                response.id,
                                {
                                isTrashed: false,
                                messageId: response.body.id, // original behavior preserved
                                },
                                { new: true }
                            );

                            console.log(`\x1b[32mRecovered:\x1b[0m ${recover?.to}`);

                            const isReporter = emailReported.reporters
                                ?.some(r => r.email.toLowerCase() === recover.to.toLowerCase());

                            if (emailReported.to.toLowerCase() !== recover.to.toLowerCase() && !isReporter) {
                                mailer.sendResultMailToOtherReporters(
                                recover.name,
                                recover.to,
                                recover.from,
                                recover.subject,
                                emailReported.mailRecievedTime,
                                'Recovered',
                                companyId
                                );
                            } else {
                                mailer.sendActionResultMail(
                                recover.name,
                                recover.to,
                                recover.from,
                                recover.subject,
                                emailReported.mailRecievedTime,
                                'RECOVERED',
                                false,
                                null,
                                companyId
                                );
                            }
                            } else {
                            console.log(`Error Recovering Mail for ${response.id}`);
                            await db.WhoElse.findByIdAndUpdate(response.id, {
                                isErrorWhileMoving: { isError: true, message: JSON.stringify(response.body) }
                            });
                            }
                        } catch (error) {
                            console.log(`Error from record ${response.id} while recovering`, error);
                        }
                        })
                    );

                    console.log(`Processed ${responses.length} recoveries`);

                    // --- BANNER REMOVAL ENQUEUE (only runs if BannerMessage exists) ---
                    const bannerMeta = await db.MetaData.findOne({ companyId, name: 'BannerMessage', deletedAt: null });
                    if (bannerMeta?.value) {
                        let queued = 0;

                        for (const response of responses) {
                        if (response.status >= 200 && response.status < 300) {
                            // Only enqueue if we *think* a banner was injected on that user's copy.
                            // The worker will re-check the body and no-op if nothing is there.
                            const whoElse = await db.WhoElse.findById(response.id).select('_id isBannerInjected');
                            if (!whoElse || !whoElse.isBannerInjected) continue;

                            queue
                            .create('remove-banner-outlook', {
                                whoElseId: whoElse._id.toHexString(),
                                companyId,
                                domainId: emailReported.domainId,
                            })
                            .delay(6000)            // let Graph settle after move
                            .priority('normal')
                            .removeOnComplete(true)
                            .save();

                            queued += 1;
                        }
                        }

                        console.log(`Queued remove-banner-outlook for ${queued} recovered messages`);
                    } else {
                        // If no banner configured, nothing changes (original flow remains intact)
                        console.log('No BannerMessage set; skipping banner removal');
                    }
                }

                 else if(Delete){
                    const updates = responses.map(async (response) => {
                        try {                            
                            if (response.status >= 200 && response.status < 300) {
                                let deleteRecord = await db.WhoElse.findByIdAndUpdate(response.id, { isDeleted: true });
                                console.log(`\x1b[31mDeleted:\x1b[0m ${deleteRecord.to}`)
                                let isReporter = emailReported?.reporters.find(reporter => reporter.email.toLowerCase() === deleteRecord.to.toLowerCase())


                                if(emailReported.to.toLowerCase() !== deleteRecord.to.toLowerCase() && !isReporter) mailer.sendResultMailToOtherReporters(deleteRecord.name ,deleteRecord.to, deleteRecord.from, deleteRecord.subject, emailReported.mailRecievedTime, 'Deleted', companyId)
                                else mailer.sendActionResultMail(deleteRecord.name ,deleteRecord.to, deleteRecord.from, deleteRecord.subject, emailReported.mailRecievedTime, 'DELETED', false, null, companyId)
                            } else {
                                console.log(`Error Deleting Mail for ${response.id}`)
                                await db.WhoElse.findByIdAndUpdate(response.id, { isErrorWhileMoving: { isError: true, message: JSON.stringify(response.body) } });
                            }
                        } catch (error) {
                            console.log(`Error from record ${response.id} while deleting`,error)
                        }
                    });
                    await Promise.all(updates);
                }
            } catch(err){
                console.log(err);
            } finally {
                done();
            }
        })
        queue.process('process-image-ocr', async (job, done) => {
            try {
                const { reportedMessage } = job.data;                
                processImage.imageToText(reportedMessage.fileName)
                .then(async (result)=>{
                    if(result) {
                        console.log("result from ocrrrrrrrrrrrrr",result)
                        let checkSpam = {data: false}
                        console.log("checkspam result------",checkSpam.data)

                        queue.create('email-reported-url', { body:`${result.split('\n').join(' ') +" "+ result.split('\n').join('')}`, reportedMailId: null, whatsAppMessageId: reportedMessage._id}).removeOnComplete(true).priority('high').save();

                        // let urls = await getUrls(result);
                        // console.log("urls in scanned image----",urls)

                        await db.whatsapp.updateOne({_id: reportedMessage._id},{message: result, result: checkSpam? checkSpam.data : null })
                        console.log("Successfully Updated Message!", checkSpam.data);
                    }
                    else{
                        whatsApp.sendMessage(reportedMessage.phoneNumberId, reportedMessage.ticketId, reportedMessage.phoneNumber, "Invalid Content", "No text found!" , 'result')
                        .then((result) => { console.log("Sent Message to User ----->", result)})
                        .catch((error) => { console.error("Error sending message to user",error.response.data)});
                    }
                    done();
                })
                .catch((error)=>{
                    console.log("Error from process-image-ocr kue",error)
                    done();
                })                
            } catch(err){
                console.log(err);
                done();
            } finally {
                done();
            }
        })

        queue.process('process-whatsapp-image', async (job, done) => {
            try {
                const { reportedMessage, companyId, preferedLanguage } = job.data;
                console.log('Processing WhatsApp image job');
        
                const result = await processWhatsappMessage.processMessage(reportedMessage.fileName, preferedLanguage);
                const resultContent = result.content;
                console.log('Processed content:', resultContent);
        
                const { template, originalResponse, sender, overallResult, messageSummary } = await whatsappResultTemplate(resultContent, reportedMessage.ticketId, preferedLanguage);
                console.log("Original Response:", originalResponse);
        
                const parsedResponse = tryParseJSON(originalResponse);
                if (Array.isArray(parsedResponse)) {
                    const urls = parsedResponse[0].flatMap(message => 
                        message.Links?.map(url => ({
                            url,
                            deceptiveStatus: null,
                            result: null,
                            details: null,
                            scanId: null,
                            companyId,
                            whatsappMessageId: reportedMessage._id
                        })) || []
                    );
        
                    if (urls.length) {
                        await db.Url.insertMany(urls);
                    }
                }
                await db.whatsapp.updateOne({ _id: reportedMessage._id }, { $set: { message: parsedResponse ? originalResponse : JSON.stringify(originalResponse), sender, result: overallResult, messageSummary } });
                await sendWhatsappMessage(reportedMessage.phoneNumberId, template, reportedMessage.phoneNumber, reportedMessage.messageId);
        
            } catch (err) {
                console.error('Error processing WhatsApp image job:', err);
            } finally {
                console.log('Finished processing job');
                done();
            }
        });
        
        

        queue.process('process-trash-request-reported-email', async (job, done) => {
            try {
                const { companyId, email, domainId, internetMessageId, isReported, name, folderId } = job.data;
                moveEmail.processTrashWhoElse({ companyId, email, domainId, internetMessageId, folderId })
                .then(async (folderId)=>{
                    if(await canAccessFeature(companyId,"TPIR-RN")) mailer.sendAlreadyReportedMail(name, email, companyId)
                    await db.ReportedMail.updateOne({_id:isReported._id},{ $push: { reporters: {email, folderId} } })
                    done()
                })
                .catch((error)=>{
                    console.log('Error when moving the already reported mail from kue',error)
                    done()
                })
            } catch(err){
                console.log(err);
                done();
            } finally {
                done();
            }
        })

        queue.process('cache-reported-mail', async (job, done) => {
            try {
                const { reportedEmail } = job.data;
                cacheReportedMail(reportedEmail)
            } catch(err){
                console.log(err);
                done();
            } finally {
                done();
            }
        })

        queue.process('broadcast-reported-mails', 20, async (job, done) => {
            const { mailIds, companyId } = job.data;
            try {
              processBroadcastMailsRequest(mailIds, companyId);
              done();
            } catch (error) {
              console.error(`Error in sending broadcast emails: ${error}`);
              done(error);
            }
          });

        queue.process('process-update-folderId-outlook', async (job, done) => {
            try {
                const { whoElses, domainId, companyId, mailAction, emailReported } = job.data;
                // console.log('----------------------------------------------->',job.data)

                const { token } = await Credentials.getCredentials(companyId, domainId);

                let requestObjectsForMessageId = await createRequestObjects(whoElses)
                // console.log("----------------------------------------->",requestObjectsForMessageId)
                await Promise.allSettled(requestObjectsForMessageId.map((batch) => update(batch, token, mailAction==='Recovered')))

                const updatedWhoElses = [];
                for(const whoElse of whoElses){
                    let arr = [];
                    for(const currWhoElse of whoElse){
                        let resFromDb = await db.WhoElse.findOne({_id: currWhoElse._id});
                        
                        if(mailAction == 'Recovered'){
                            let folderId = null
                            if(emailReported.to === resFromDb.to){ 
                                folderId = emailReported.reporterFolderId ? emailReported.reporterFolderId : 'inbox'
                            }
                            else{
                                let findFolderIdInReporters = emailReported.reporters.find(reporter => reporter.email.toLowerCase() === resFromDb.to.toLowerCase())
                                if(findFolderIdInReporters) {
                                    folderId = findFolderIdInReporters.folderId ? findFolderIdInReporters.folderId : 'inbox' 
                                }
                                else {
                                    folderId = resFromDb.folderId ? resFromDb.folderId : 'inbox'
                                }
                            }
                            resFromDb = {...resFromDb.toObject(), folderId}
                        }

                        arr.push(resFromDb);
                    }
                    
                    updatedWhoElses.push(arr);
                }
                let requestObjectForMailAction = createRequestObjectMailAction(updatedWhoElses, token, mailAction);
                const resp = await Promise.allSettled(requestObjectForMailAction.map((batch) => outlookBatchProcess(batch, token.access_token)))


                for(let i=0;i<resp.length;i++){
                    let batch = resp[i];
                    console.log(batch)
                    if(batch.status == 'fulfilled'){
                        queue.create('process-who-else-trash-batches-outlook', {responses:batch.value, emailReported, 
                            Trash: mailAction ==='Trashed', 
                            Recover: mailAction ==='Recovered' , 
                            Delete: mailAction === 'Deleted', companyId})
                            .removeOnComplete(true).priority('high').save()
                    }
                }

            } catch(err){
                console.log(err);
                done();
            } finally {
                done();
            }
        })

        queue.process('remove-Groups-Application', async (job, done) => {
            const { groupIds, localCompanyId } = job.data;
            try {
                console.log("Deleting groups in database:", groupIds);
        
                const groups = await db.Group.find({ tacIdentityKey: { $in: groupIds }, companyId: localCompanyId });
                const groupObjectIds = groups.map(group => group._id);
        
                await db.User.updateMany(
                    { companyId: localCompanyId, groups: { $in: groupObjectIds } },
                    { $pull: { groups: { $in: groupObjectIds } } }
                );
        
                // Delete users with no groups left
                await db.User.deleteMany({
                    companyId: localCompanyId,
                    groups: { $size: 1 },
                    deletedAt: null,
                });
        
                // Remove groups in bulk
                await db.Group.deleteMany({ _id: { $in: groupObjectIds }, companyId: localCompanyId, isDefaultGroup: false });
        
                console.log(`Successfully deleted groups: ${groupObjectIds}`);
            } catch (error) {
                console.error("Error during group deletion:", error);
                return done(error);
            }
            done();
        });

        queue.process('add-User-Queue', async (job, done) => {
            let { tacCompanyId, tacIdentityKey, localCompanyId, localGroupId, limit, offset, isLastBatch, lastSyncId } = job.data;
            try {   
            let response =await axios.post(`${process.env.TAC_URL}/api/sync-services/tpir/fetch-group-users`,{      
                    groupIdentityKey: tacIdentityKey,
                    tacCompanyId:tacCompanyId,
                    limit:limit,
                    offset:offset,
                },
                {
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': `Bearer ${config.adminCentral.api_key}`
                    },
                    params:{
                        appName:"TPIR"
                    },
                    ...(config.proxy.enableForTA && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
                }
                )
                
                let users;

                users = response.data.response                

                let syncData = {
                    users,
                    companyId: localCompanyId,
                    groupId: localGroupId,
                    isLastBatch,
                    lastSyncId
                }

                queue.create(`add-users-tac`, {...syncData})
                .priority('normal')
                .removeOnComplete(true)
                .save()    

                done();
            } catch (error) {
                // await t.rollback();
                console.log(error.response.data);
                done(error);
            }
        });


        queue.process('asssign-group-user',async (job,done)=>{
            let {localGroupId, localCompanyId, tacCompanyId, memberCount, tacIdentityKey, lastSyncId }=job.data;
            let offset = 0;
            const limit = 1;
            let pages = Math.ceil(memberCount / limit);
            console.log("The total number of users are",pages, job.data)
            while(pages--){
                try{
                    queue.create('add-User-Queue',{
                        tacCompanyId:tacCompanyId,
                        tacIdentityKey,
                        localCompanyId:localCompanyId,
                        localGroupId:localGroupId,
                        limit:limit,
                        offset:offset,
                        lastSyncId,
                        isLastBatch: pages == 0
                    }).removeOnComplete(true).save()
                offset+=limit
                }
                catch(error){
                    console.log(error);
                    done(error);
                }
            }
        done();
        })

        // queue.process('retry-syncing-users',async (job,done)=>{
        //     try {
        //         let {localGroupId, localCompanyId, memberCount, tacIdentityKey, licenseKey = '', lastSyncId }=job.data;
        //     let offset = 0;
        //     const limit = 1;
        //     let pages = Math.ceil(memberCount / limit);
        //     console.log("The total number of users are",pages, job.data)
        //     while(pages--){
        //         try{
        //             var response =await axios.get(`${process.env.TAC_URL}/api/sync-services/common/fetch-group-users`,
        //             {
        //                 headers: {
        //                     'Content-Type': 'application/json',
        //                     Authorization: `Bearer ${licenseKey}`
        //                 },
        //                 params:{
        //                     appName:"TPIR",
        //                     groupIdentityKey: tacIdentityKey,
        //                     limit:limit,
        //                     offset:offset
        //             }
        //             }
        //         )
                
        //         let users;

        //         users = response.data.response.groupUserDetails;

        //         let syncData = {
        //             users,
        //             companyId: localCompanyId,
        //             groupId: localGroupId,
        //             isLastBatch: pages == 0,
        //             lastSyncId
        //         }

        //         queue.create(`add-users-tac`, {...syncData})
        //         .priority('normal')
        //         .removeOnComplete(true)
        //         .save()    

        //         done();
        //         offset+=limit
        //         }
        //         catch(error){
        //             console.log(error);
        //             done(error);
        //         }
        //     }
        //     done();
        //     } catch (error) {
        //         console.log(error)
        //         done()
        //     }
            
        // })

        queue.process('retry-syncing-users', async (job, done) => {
        const {
            localGroupId,
            localCompanyId,
            memberCount,
            tacIdentityKey,
            licenseKey = '',
            lastSyncId
        } = job.data;

        const limit  = 100;               // fetch 100 users at a time
        const pages  = Math.ceil(memberCount / limit);
        let   offset = 0;

        try {
            for (let page = 0; page < pages; page++, offset += limit) {
                console.log("-----------PAGE--------------",page)
            const { data } = await axios.get(
                `${process.env.TAC_URL}/api/sync-services/common/fetch-group-users`,
                {
                    headers: { Authorization: `Bearer ${licenseKey}` },
                    params : {
                        appName: 'TPIR',
                        groupIdentityKey: tacIdentityKey,
                        limit,
                        offset
                    },
                    ...(config.proxy.enableForTA && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
                }
            );

            const users = data?.response?.groupUserDetails || [];

            // Wrap .save() so we know the job is really in Redis before moving on
            await new Promise((res, rej) =>
                queue
                .create('add-users-tac', {
                    users,
                    companyId : localCompanyId,
                    groupId   : localGroupId,
                    isLastBatch: page === pages -1,
                    lastSyncId
                })
                .priority('normal')
                .removeOnComplete(true)
                .save(err => (err ? rej(err) : res()))
            );
            }

            done();              // ✅ EXACTLY ONCE, when everything’s finished
        } catch (err) {
            console.error(err);
            done(err);           // ✅ EXACTLY ONCE, only on failure
        }
        });



        queue.process('sync-users-csv', async (job, done) => {
            console.log("inside sync users csv==========")
            const { users, domain, domainType, companyId, groupId, isLast } = job.data;
            try {
                const group = await db.Group.findOne({_id:groupId, companyId, deletedAt: null})
                console.log({groupId,group})
                const allUsersGroup = await db.Group.findOne({groupName:"all-users-tpir", companyId, deletedAt:null, isDefaultGroup: true})
                
                const userLimit = (await db.MetaData.findOne({ companyId, name: "userLimit"})).value;
                const userLimitMessenger = (await db.MetaData.findOne({ companyId, name: "userLimitMessenger"})).value;
                
                const addedUsersCount = await db.User.countDocuments({companyId, deletedAt: null})
                const remainingUserCount = (parseInt(userLimit) + parseInt(userLimitMessenger)) - addedUsersCount;
                var addedUsersSoFar = 0;
            
                let processedUsers = new Set();  // To keep track of already processed emails
                const userUpdates = users.map(async (user) => {
                  if (processedUsers.has(user.email)) {
                      return `This user has already been processed ${user.email}`;  // No action for this user
                  }
                  processedUsers.add(user.email);

                  const subDomainGroupFromDb = await db.SubDomainGroup.findOne({
                    groupName: user.email.split("@")[1],
                    domainId: domain._id
                  });
                  const existingUser = await db.User.findOne({ email: user.email, companyId, deletedAt: null });
                  console.log({addedUsersSoFar, remainingUserCount, existingUser, lim:addedUsersSoFar < remainingUserCount})

                  const canBeActivate = (allUsersGroup.emailAccess || group.emailAccess) && addedUsersSoFar < remainingUserCount;
                  const canBeActivateMessenger = (allUsersGroup.messengerAccess || group.messengerAccess) && addedUsersSoFar < remainingUserCount;
                  console.log("users can activate--------", user.email,canBeActivate,canBeActivateMessenger)
                  if (existingUser) {
                    return db.User.updateOne({ _id: existingUser._id }, { $set: { name: user.name, domainId: domain._id, emailType: domainType, phoneNumber: user.phoneNumber, subDomainGroupId: subDomainGroupFromDb?._id, deletedAt: null }, $addToSet: { groups: group._id} });
                  } else if(addedUsersSoFar < remainingUserCount){
                    addedUsersSoFar++;
                    console.log("all users group id -------------------------",allUsersGroup._id);
                    return db.User.create({ name: user.name, email: user.email, isActive: canBeActivate, isActiveMessenger: canBeActivateMessenger, domainId: domain._id, groups: [group._id, allUsersGroup._id], emailType: domainType, phoneNumber: user.phoneNumber, companyId, subDomainGroupId: subDomainGroupFromDb?._id });
                  }
                  else { return "User Limit Exceeded!"};
                  
                });
                await Promise.all(userUpdates);
                
                done();
            } 
            catch (error) {
              console.error(`Error processing users:`, error);
              done(error);
            }
            finally{
                if(isLast) {
                    await updateSyncingStatusOfGroups(groupId, companyId)
                    let isAnyUserUploadedInCurrentGroup = await db.User.countDocuments({companyId, groups:{$in:[groupId]}})
                    console.log({isAnyUserUploadedInCurrentGroup})
                    if(!isAnyUserUploadedInCurrentGroup) await db.Group.deleteOne({_id: groupId, isDefaultGroup: false, companyId})
                }
                done()
            }
          });

        queue.process('sync-tac-users-identityKey', async (job, done) => {
            let { tacCompanyId, groupIdentityKey, appName, limit, offset, isLastBatch, companyId } = job.data;
            try {
                const BATCH_SIZE = 1000;
        
                async function processBatch(batch) {
                    try {
                        const bulkOps = batch.map(([email, identityKeys]) => ({
                            updateOne: {
                                filter: { email, companyId },
                                update: { $set: { tacIdentityKey: identityKeys.userIdentityKey } },
                            },
                        }));
                
                        const result = await db.User.bulkWrite(bulkOps);
                
                        console.log(`Processed batch of ${batch.length} updates successfully.`);
                        console.log(`Matched: ${result.matchedCount}, Modified: ${result.modifiedCount}`);
                    } catch (error) {
                        console.error("Error updating batch:", error);
                        throw error;
                    }
                }
        
                const response = await axios.get(
                    `${process.env.TAC_URL}/api/sync-services/common/sync-group-users-identityKey`,
                    {
                        headers: {
                            'Content-Type': 'application/json',
                            'Authorization': `Bearer ${config.adminCentral.api_key}`,
                        },
                        params: {
                            companyId: tacCompanyId,
                            groupIdentityKey,
                            appName,
                            limit,
                            offset,
                        },
                        ...(config.proxy.enableForTA && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
                    }
                );
        
                const usersObj = response.data.response;
        
                if (Object.keys(usersObj).length === 0) {
                    console.log("No more data to process.");
                    if(isLastBatch){
                        const update = await db.Company.updateOne({
                            _id: companyId
                        },{
                            $set:{
                                isTacEnabled: true,
                                isTaConnectionInProgess: false
                            }
                        })
                    }
                    done();
                    return;
                }
        
                const entries = Object.entries(usersObj);
                const batches = [];
        
                for (let i = 0; i < entries.length; i += BATCH_SIZE) {
                    batches.push(entries.slice(i, i + BATCH_SIZE));
                }
        
                for (const batch of batches) {
                    await processBatch(batch);
                }

                console.log({isLastBatch, companyId})
                if(isLastBatch){
                    const update = await db.Company.updateOne({
                        _id: companyId
                    },{
                        $set:{
                            isTacEnabled: true,
                            isTaConnectionInProgess: false
                        }
                    })
                    let upppppKUEUEUUE = await db.Company.findOne({_id: companyId})
                    console.log({upppppKUEUEUUE})
                    console.log('nfjksnfnsknfdkksf isme ghusa',update)
                }
                console.log("All IdentityKeys for targets of group having groupIdentityKey: " + groupIdentityKey + " have been updated successfully.");
                done();
            }
            catch (error) {
              console.error(`Error processing users:`, error);
              done(error);
            }
        });

        queue.process('add-users-tac', async (job, done) => {
            const { users, companyId, groupId, isLastBatch, lastSyncId = '' } = job.data;
            console.log('JOB DATA ADD USERS TAC',job.data)
            try {
                const userLimit = parseInt((await db.MetaData.findOne({ companyId, name: "userLimit" })).value);
                const userLimitMessenger = parseInt((await db.MetaData.findOne({ companyId, name: "userLimitMessenger" })).value);
                const addedUsersCount = await db.User.countDocuments({ companyId, deletedAt: null });
                const remainingUsersCount = Math.max(0, (userLimit + userLimitMessenger) - addedUsersCount);
        
                const allUsersGroup = await db.Group.findOne({
                    groupName: "all-users-tpir",
                    isDefaultGroup: true,
                    companyId: companyId,
                });

                const currentGroup = await db.Group.findOne({
                    _id: groupId,
                    companyId,
                    deletedAt: null
                })
        
                let addedUsersSoFar = 0;
    

                for (let user of users) {
                    const { firstname, lastname, email, IdentityKey, phoneNumber, userIdentityKey } = user;
                    const domainName = email.split('@')[1];

                    console.log({ domainName });

                    let domain = await db.Domain.findOne({ domainName, companyId, deletedAt: null });
                    
                    if (!domain) {
                        const domainGroup = await db.SubDomainGroup.findOne({ groupName: domainName, companyId, deletedAt: null });
                    
                        if (domainGroup?.domainId) {
                            domain = await db.Domain.findOne({ _id: domainGroup.domainId, companyId, deletedAt: null });
                        }
                    }
                    
                    const domainId = domain?._id || null;

                    if (domainId) {
                        const existingUser = await db.User.findOne({ email, companyId });
                        console.log({ existingUser, addedUsersSoFar, remainingUsersCount, email });
                
                        let updateFields = {};
                
                        if (firstname || lastname) {
                            updateFields.name = `${firstname || ''} ${lastname || ''}`.trim();
                        }
                        if (email) {
                            updateFields.email = email;
                        }
                        if (phoneNumber) {
                            updateFields.phoneNumber = phoneNumber?.startsWith("+") ? phoneNumber?.slice(1) : phoneNumber;;
                        }
                        if (domainId) {
                            updateFields.domainId = domainId;
                        }

                        if (domain?.domainType === "Outlook") {
                            updateFields.emailType = domain.domainTypeForOutlook === "EXCHANGE" ? "Exchange" : "Outlook";
                        }
                        else {
                            updateFields.emailType = "Gsuite";
                        }
                        
                        if (companyId) {
                            updateFields.companyId = companyId;
                        }
                        if (IdentityKey || userIdentityKey) {
                            if(IdentityKey) updateFields.tacIdentityKey = IdentityKey;
                            if(userIdentityKey) updateFields.tacIdentityKey = userIdentityKey
                        }
                        if(allUsersGroup.emailAccess || currentGroup.emailAccess){
                            updateFields.isActive = true
                        }
                        if(allUsersGroup.messengerAccess || currentGroup.messengerAccess){
                            updateFields.isActiveMessenger = true
                        }
                
                        const updateQuery = {
                            $set: updateFields,
                            $addToSet: { groups: { $each: [allUsersGroup._id, groupId] } },
                        };
                
                        if (existingUser) {
                            await db.User.updateOne(
                                { email, domainId, companyId },
                                updateQuery
                            );
                        } else if (addedUsersSoFar < remainingUsersCount) {
                            await db.User.updateOne(
                                { email, domainId, companyId },
                                updateQuery,
                                { upsert: true }
                            );
                            addedUsersSoFar++;
                        }
                    }
                }
        
                if (isLastBatch) {
                    await updateSyncingStatusOfGroups(groupId, companyId);
                    await db.Group.updateOne({ _id: groupId, companyId, deletedAt: null }, { $set: { lastSyncId, lastSyncIdMismatch: false } });
                }
                done();
            } catch (error) {
                console.error("Error from adding users", error);
                await updateSyncingStatusOfGroups(groupId, companyId); 
                done();
            }
        });

        queue.process('update-bulk-users', async (job, done) => {
            try {
                const { companyId, userDetails } = job.data;
                if (!userDetails || userDetails.length === 0) {
                    return done();
                }
        
                const userUpdates = [];
                const adminUpdates = [];
                const employeeUpdates = [];
        
                userDetails.forEach(({ tacIdentityKey, firstname, lastname, phone }) => {
                    userUpdates.push({ updateOne: { filter: { companyId, tacIdentityKey }, update: { $set: {tacIdentityKey, name: firstname+lastname, phoneNumber: phone} } } });
                    adminUpdates.push({ updateOne: { filter: { companyId, tacIdentityKey }, update: { $set: { tacIdentityKey, firstName: firstname, lastName: lastname } } } });
                    employeeUpdates.push({ updateOne: { filter: { companyId, tacIdentityKey }, update: { $set: { tacIdentityKey, firstName: firstname, lastName: lastname } } } });
                });
        
                await Promise.all([
                    userUpdates.length ? db.User.bulkWrite(userUpdates) : Promise.resolve(),
                    adminUpdates.length ? db.Admin.bulkWrite(adminUpdates) : Promise.resolve(),
                    employeeUpdates.length ? db.Employee.bulkWrite(employeeUpdates) : Promise.resolve(),
                ]);
        
                console.log('Bulk update successful');
                done();
            } catch (error) {
                console.error('Bulk update failed:', error);
                done(error);
            }
        });

        queue.process('inject-banner-outlook', 5, async (job, done) => {
            const { whoElseId, companyId, domainId } = job.data;

            try {
                const result = await injectBannerForWhoElse({ whoElseId, companyId, domainId });
                // result: { changed: boolean, reason?: string }
                if (!result.changed && result.reason) {
                console.log(`[inject-banner-outlook] skipped: ${result.reason} for whoElseId=${whoElseId}`);
                } else if (result.changed) {
                console.log(`[inject-banner-outlook] injected for whoElseId=${whoElseId}`);
                }
                done();
            } catch (err) {
                console.error('[inject-banner-outlook] error', whoElseId, err?.message || err);
                done(err);
            }
        });

        queue.process('remove-banner-outlook', 5, async (job, done) => {
            const { whoElseId, companyId, domainId } = job.data;
            try {
                const whoElseDoc = await db.WhoElse.findById(whoElseId);
                if (!whoElseDoc) return done();

                const result = await removeBannerForWhoElse({ whoElseId, companyId, domainId });
                // result: { changed: boolean, reason?: string }
                if (!result.changed && result.reason) {
                console.log(`[remove-banner-outlook] skipped: ${result.reason} for whoElseId=${whoElseId}`);
                } else if (result.changed) {
                console.log(`[remove-banner-outlook] removed for whoElseId=${whoElseId}`);
                }
                done();
            } catch (err) {
                console.error('[remove-banner-outlook] error', whoElseId, err?.message || err);
                done(err);
            }
        });
    }
    
}