import nodemailer from 'nodemailer';
import MailService from './service/MailEngine';
import config from './config';
import path from 'path';
import { send } from 'process';

const appUrl = config.app.url;

const sendMail = async ({ companyId, to, subject, html, attachments = [], mailerFunction }) => {
  const mailer = await new MailService(companyId).init();
  const summary = mailer.getSummary();
  console.log('SMTP Summary:', summary);
  await mailer.triggerEmail({
    recipientAddress: to,
    subject,
    content: html,
    attachments,
    mailerFunction
  })
}

export default {
    sendRegisterationLink: async (name, email, token, companyId) => {
        try {
                let url = `${appUrl}/email-verification/${email}/${token}`;

                const html = `<!DOCTYPE html> <html lang="en" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:v="urn:schemas-microsoft-com:vml"> <head> <title></title> <meta content="text/html; charset=utf-8" http-equiv="Content-Type" /> <meta content="width=device-width, initial-scale=1.0" name="viewport" /> <link href="https://fonts.googleapis.com/css?family=Poppins" rel="stylesheet" type="text/css" /> <style> * { box-sizing: border-box; } body { margin: 0; padding: 0; } a[x-apple-data-detectors] { color: inherit !important; text-decoration: inherit !important; } #MessageViewBody a { color: inherit; text-decoration: none; } p { line-height: inherit } .desktop_hide, .desktop_hide table { mso-hide: all; display: none; max-height: 0px; overflow: hidden; } @media (max-width:700px) { .desktop_hide table.icons-inner { display: inline-block !important; } .icons-inner { text-align: center; } .icons-inner td { margin: 0 auto; } .row-content { width: 100% !important; } .mobile_hide { display: none; } .stack .column { width: 100%; display: block; } .mobile_hide { min-height: 0; max-height: 0; max-width: 0; overflow: hidden; font-size: 0px; } .desktop_hide, .desktop_hide table { display: table !important; max-height: none !important; } } </style> </head> <body style="background-color: #f5f5f5; margin: 0; padding: 0; -webkit-text-size-adjust: none; text-size-adjust: none;"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="nl-container" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #f5f5f5;" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row row-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row-content stack" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #2c5596; background-image: url('${appUrl}/api/static/logo/heasder-bg.png'); background-repeat: no-repeat; color: #000000; background-size: cover; border-radius: 0; width: 680px;" width="680"> <tbody> <tr> <td class="column column-1" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; vertical-align: top; padding-top: 0px; padding-bottom: 25px; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="image_block block-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tr> <td class="pad"> <div align="left" class="alignment" style="line-height:10px"> <img src="${appUrl}/api/static/logo/Tpirlogo.png" style="display: block; height: auto; border: 0; width: 170px; max-width: 100%;" width="170" /> </div> </td> </tr> </table> <table border="0" cellpadding="0" cellspacing="0" class="heading_block block-2" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tr> <td class="pad" style="padding-top:5px;text-align:center;width:100%;"> <h1 style="margin: 0; color: #ffffff; direction: ltr; font-family: Poppins, Arial, Helvetica, sans-serif; font-size: 30px; font-weight: 700; letter-spacing: normal; line-height: 150%; text-align: center; margin-top: 0; margin-bottom: 0;">Welcome, ${name}!</h1> </td> </tr> </table> <table border="0" cellpadding="0" cellspacing="0" class="text_block block-3" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; word-break: break-word;" width="100%"> <tr> <td class="pad" style="padding-bottom:15px;padding-left:15px;padding-right:15px;padding-top:10px;"> <div style="font-family: sans-serif"> <div class="" style="font-size: 12px; font-family: Poppins, Arial, Helvetica, sans-serif; mso-line-height-alt: 18px; color: #ffffff; line-height: 1.5;"> <p style="margin: 0; font-size: 17px; text-align: center; mso-line-height-alt: 24px;"> <span style="font-size:16px;">We're thrilled to have you on the team</span> </p> </div> </div> </td> </tr> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row row-2" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row-content stack" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #ffffff; color: #000000; border-radius: 0; width: 680px;" width="680"> <tbody> <tr> <td class="column column-1" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-left: 30px; padding-right: 30px; vertical-align: top; padding-top: 0px; padding-bottom: 25px; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="paragraph_block block-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; word-break: break-word;" width="100%"> <tr> <td class="pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px;"> <div style="color:#333954;font-size:15px;font-family:'Lato', Tahoma, Verdana, Segoe, sans-serif;font-weight:400;line-height:180%;text-align:left;direction:ltr;letter-spacing:0px;mso-line-height-alt:27px;"> <p style="margin: 0; margin-bottom: 16px;">Welcome to Threatcop Phishing Incident Response(TPIR), We are thrilled to have you join our community. You have successfully registered for an account on our platform and are one step closer to exploring our offerings.</p> <p style="margin: 0;">To start accessing all the features and benefits of our platform, please activate your account by clicking on the button below.</p> </div> </td> </tr> </table> <table border="0" cellpadding="0" cellspacing="0" class="button_block block-2" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tr> <td class="pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center;"> <div align="center" class="alignment"> <a href="${url}" style="text-decoration:none;display:inline-block;color:#ffffff;background-color:#2c5596;border-radius:4px;width:auto;border-top:0px solid transparent;font-weight:400;border-right:0px solid transparent;border-bottom:0px solid transparent;border-left:0px solid transparent;padding-top:5px;padding-bottom:5px;font-family:Poppins, Arial, Helvetica, sans-serif;font-size:14px;text-align:center;mso-border-alt:none;word-break:keep-all;"> <span style="padding-left:20px;padding-right:20px;font-size:14px;display:inline-block;letter-spacing:normal;"> <span dir="ltr" style="word-break: break-word; line-height: 28px;">Verify Email Address</span> </span> </a> </div> </td> </tr> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row row-3" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row-content stack" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #2c5596; color: #000000; width: 680px;" width="680"> <tbody> <tr> <td class="column column-1" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; vertical-align: top; padding-top: 10px; padding-bottom: 0px; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="paragraph_block block-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; word-break: break-word;" width="100%"> <tr> <td class="pad" style="padding-top:10px;padding-right:10px;padding-left:10px;"> <div style="color:#ffffff;font-size:11px;font-family:Poppins, Arial, Helvetica, sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px;mso-line-height-alt:13.2px;">  </div> </td> </tr> </table> <table border="0" cellpadding="20" cellspacing="0" class="text_block block-2" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; word-break: break-word;" width="100%"> <tr> <td class="pad"> <div style="font-family: sans-serif"> <div class="" style="font-size: 12px; font-family: Poppins, Arial, Helvetica, sans-serif; mso-line-height-alt: 18px; color: #fafafa; line-height: 1.5;"> <p style="margin: 0; font-size: 10px; text-align: center; mso-line-height-alt: 15px;">  </p> </div> </div> </td> </tr> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row row-4" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row-content stack" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; color: #000000; width: 680px;" width="680"> <tbody> <tr> <td class="column column-1" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; vertical-align: top; padding-top: 5px; padding-bottom: 5px; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="icons_block block-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tr> <td class="pad" style="vertical-align: middle; padding-bottom: 5px; padding-top: 5px; text-align: center; color: #9d9d9d; font-family: inherit; font-size: 15px;"> <table cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tr> <td class="alignment" style="vertical-align: middle; text-align: center;"></td> </tr> </table> </td> </tr> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </body> </html>`;

                await sendMail({
                    companyId,
                    to: email,
                    subject: 'Email Verification',
                    html: html,
                    mailerFunction: 'sendRegisterationLink'
                });
            } catch (err) {
                console.log(err)
            }
    },
    sendOTP: async (name, email, otp, companyId) => {
        try {
                const html = `<html> <head> <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> <style> * { box-sizing: border-box } body { margin: 0; padding: 0 } #m_MessageViewBody a { color: inherit; text-decoration: none } p { line-height: inherit } .m_desktop_hide, .m_desktop_hide table { display: none; max-height: 0px; overflow: hidden } @media (max-width:700px) { .m_desktop_hide table.m_icons-inner { display: inline-block !important } .m_icons-inner { text-align: center } .m_icons-inner td { margin: 0 auto } .m_row-content { width: 100% !important } .m_mobile_hide { display: none } .m_stack .m_column { width: 100%; display: block } .m_mobile_hide { min-height: 0; max-height: 0; max-width: 0; overflow: hidden; font-size: 0px } .m_desktop_hide, .m_desktop_hide table { display: table !important; max-height: none !important } } </style> </head> <body> <u></u> <div style="background-color:#f5f5f5;margin:0;padding:0"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_nl-container" role="presentation" style="background-color:#f5f5f5" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-1" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#2c5596;background-image:url('${appUrl}/api/static/logo/heasder-bg.png');background-repeat:no-repeat;color:#000000;background-size:cover;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="m_image_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad"> <div align="left" class="m_alignment" style="line-height:10px"> <img src="${appUrl}/api/static/logo/Tpirlogo.png" style="display:block;height:auto;border:0;width:170px;max-width:100%" width="170"> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_heading_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:5px;text-align:center;width:100%"> <h1 style="margin:0;color:#ffffff;direction:ltr;font-family:Poppins,Arial,Helvetica,sans-serif;font-size:30px;font-weight:700;letter-spacing:normal;line-height:150%;text-align:center;margin-top:0;margin-bottom:0">One-Time Password</h1> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_text_block m_block-3" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:15px;padding-left:15px;padding-right:15px;padding-top:10px"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#ffffff;line-height:1.5"> <p style="margin:0;font-size:17px;text-align:center"> <span style="font-size:16px">OTP for Your TPIR sign-in</span> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-2" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#ffffff;color:#000000;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;padding-left:30px;padding-right:30px;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px"> <div style="color:#333954;font-size:15px;font-family:'Lato',Tahoma,Verdana,Segoe,sans-serif;font-weight:400;line-height:180%;text-align:left;direction:ltr;letter-spacing:0px"> <p style="margin:0;margin-bottom:1px">Dear ${name},</p> <p style="margin:0;margin-bottom:12px">Use the following one-time password (OTP) to sign in to your TPIR account.</p> <h3>${otp}</h3> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_button_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center"></td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-3" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#2c5596;color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:10px;padding-bottom:0px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:10px;padding-right:10px;padding-left:10px"> <div style="color:#ffffff;font-size:11px;font-family:Poppins,Arial,Helvetica,sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px"></div> </td> </tr> </tbody> </table> <table border="0" cellpadding="20" cellspacing="0" class="m_text_block m_block-2" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#fafafa;line-height:1.5"> <p style="margin:0;font-size:10px;text-align:center"> <span style="font-size:10px"></span> <span style="font-size:10px"></span> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-4" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:5px;padding-bottom:5px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_icons_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="vertical-align:middle;padding-bottom:5px;padding-top:5px;text-align:center;color:#9d9d9d;font-family:inherit;font-size:15px"> <table cellpadding="0" cellspacing="0" role="presentation" width="100%"> <tbody> <tr> <td class="m_alignment" style="vertical-align:middle;text-align:center"></td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </div> </body> </html>`;

                await sendMail({
                    companyId,
                    to: email,
                    subject: 'One Time Password: TPIR',
                    html: html,
                    mailerFunction: 'sendOTP'
                });
            } catch (err) {
                console.log("mailer",err)
            }
    },
    sendEmployeePassword: async (name, email, encryptEmail, token, companyId) => {
        try {
                    const url = `${appUrl}/reset-password/${encryptEmail}/${token}?reset=false`
                    const html = `<html> <head> <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> <style> * { box-sizing: border-box } body { margin: 0; padding: 0 } #m_MessageViewBody a { color: inherit; text-decoration: none } p { line-height: inherit } .m_desktop_hide, .m_desktop_hide table { display: none; max-height: 0px; overflow: hidden } @media (max-width:700px) { .m_desktop_hide table.m_icons-inner { display: inline-block !important } .m_icons-inner { text-align: center } .m_icons-inner td { margin: 0 auto } .m_row-content { width: 100% !important } .m_mobile_hide { display: none } .m_stack .m_column { width: 100%; display: block } .m_mobile_hide { min-height: 0; max-height: 0; max-width: 0; overflow: hidden; font-size: 0px } .m_desktop_hide, .m_desktop_hide table { display: table !important; max-height: none !important } } </style> </head> <body> <u></u> <div style="background-color:#f5f5f5;margin:0;padding:0"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_nl-container" role="presentation" style="background-color:#f5f5f5" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-1" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#2c5596;background-image:url('${appUrl}/api/static/logo/heasder-bg.png');background-repeat:no-repeat;color:#000000;background-size:cover;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="m_image_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad"> <div align="left" class="m_alignment" style="line-height:10px"> <img src="${appUrl}/api/static/logo/Tpirlogo.png" style="display:block;height:auto;border:0;width:170px;max-width:100%" width="170"> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_heading_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:5px;text-align:center;width:100%"> <h1 style="margin:0;color:#ffffff;direction:ltr;font-family:Poppins,Arial,Helvetica,sans-serif;font-size:30px;font-weight:700;letter-spacing:normal;line-height:150%;text-align:center;margin-top:0;margin-bottom:0">Set Password</h1> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_text_block m_block-3" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:15px;padding-left:15px;padding-right:15px;padding-top:10px"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#ffffff;line-height:1.5"> <p style="margin:0;font-size:17px;text-align:center"> <span style="font-size:16px">Don't worry, Setting your password is easy</span> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-2" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#ffffff;color:#000000;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;padding-left:30px;padding-right:30px;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px"> <div style="color:#333954;font-size:15px;font-family:'Lato',Tahoma,Verdana,Segoe,sans-serif;font-weight:400;line-height:180%;text-align:left;direction:ltr;letter-spacing:0px"> <p style="margin:0;margin-bottom:16px">Dear ${name},</p> <p style="margin:0;margin-bottom:16px">We have received a request to set your password for your TPIR account associated with this email address.</p> <p style="margin:0">To set your password, please click on the button below.</p> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_button_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center"> <div align="center" class="m_alignment"> <a href="${url}" style="text-decoration:none;display:inline-block;color:#ffffff;background-color:#2c5596;border-radius:4px;width:auto;border-top:0px solid transparent;font-weight:400;border-right:0px solid transparent;border-bottom:0px solid transparent;border-left:0px solid transparent;padding-top:5px;padding-bottom:5px;font-family:Poppins,Arial,Helvetica,sans-serif;font-size:14px;text-align:center;word-break:keep-all"> <span style="padding-left:20px;padding-right:20px;font-size:14px;display:inline-block;letter-spacing:normal"> <span dir="ltr" style="word-break:break-word;line-height:28px">Set Password</span> </span> </a> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-3" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#2c5596;color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:10px;padding-bottom:0px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:10px;padding-right:10px;padding-left:10px"> <div style="color:#ffffff;font-size:11px;font-family:Poppins,Arial,Helvetica,sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px">    </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="20" cellspacing="0" class="m_text_block m_block-2" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#fafafa;line-height:1.5"> <p style="margin:0;font-size:10px;text-align:center"> <span style="font-size:10px">    </span> <span style="font-size:10px">     </span> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-4" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:5px;padding-bottom:5px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_icons_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="vertical-align:middle;padding-bottom:5px;padding-top:5px;text-align:center;color:#9d9d9d;font-family:inherit;font-size:15px"> <table cellpadding="0" cellspacing="0" role="presentation" width="100%"> <tbody> <tr> <td class="m_alignment" style="vertical-align:middle;text-align:center"></td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </div> </body> </html>`;

                    await sendMail({
                        companyId,
                        to: email,
                        subject: 'TPIR Password Create',
                        html: html,
                        mailerFunction: 'sendEmployeePassword'
                    });
                    console.log(`-----------------------EMPLOYEE PASSWORD MAIL SENT - ${email} ------------------------`);
                } catch (err) {
                    console.log("send employee password mail error", err)
                }

    },
    sendSuccessRegister: async (name, email, companyId) => {
                try {
                    const html = `<!DOCTYPE html> <html> <head> <title></title> </head> <body cz-shortcut-listen="true" style="margin: 0; padding: 0 !important; margin-top: 20px; mso-line-height-rule: exactly; color: black;" width="100%"> <center style="width: 100%;"> <div style="display: none; font-size: 1px;max-height: 0px; max-width: 0px; opacity: 0; overflow: hidden; mso-hide: all; font-family: sans-serif;"> </div> <div class="email-container" style="max-width: 600px; margin: 0 auto;"> <div class="overlay"> </div> <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="margin: auto; padding:0px;background: #f4f4f4;" width="100%"> <tbody> <tr> <td class="hero bg_white" valign="middle"> <table border="0" cellpadding="0" cellspacing="0" width="100%"> <tbody> <tr> <td style="text-align: center;"> <br> <br> <img width="200px" style="margin-bottom: 14px; border-radius: 5px;" src="${appUrl}/api/static/logo/TPIR-banner.png"> <br> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" max-width="100%"> <tbody> <tr> <td> <img src="${appUrl}/api/static/logo/tpir-registration.png" style="width: 100%;"> </td> </tr> </tbody> </table> <table border="0" cellpadding="20" cellspacing="0" width="100%"> <tbody> <tr> <td style="text-align: center;padding-top: 0px;"> <p style="font-size:20px;margin-bottom: 15px;font-family:Arial;color:black;margin-top: 15px;"><b>Dear User, </b></p> <p style="font-size:16px;line-height:28px;font-family:Arial;margin-bottom:30px;color:black;margin-top: 0px;">Thank you for completing the registration process. We’re currently working towards the activation of your account and will be sharing the access to you soon.</p> <p style="font-size: 12px;font-family:Arial;color: black;font-weight: 400;">Warm Regards, <br> Threatcop Team</p> </td> </tr> <tr> <td style=" text-align: center;padding-top: 0px;"> <p style="font-size:17px;font-weight: 600; margin-bottom:10px;margin-top:0px; font-family:Arial;color: #333333;">Need Help?</p> <p style="font-size:16px; line-height:26px;font-family:Arial;margin-bottom:2px; margin-top: 8px;color:black; color: #545353;">Please send any feedback or bug reports to <a href="mailto:support@tpir.threatcop.com">support@tpir.threatcop.com</a> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </div> </center> </body> </html>`;

                    await sendMail({
                        companyId,
                        to: email,
                        subject: 'ThreatCop: Account Activation',
                        html: html,
                        mailerFunction: 'sendSuccessRegister'
                    });

                    console.log(`-----------------------ACCOUNT ACTIVATION MAIL SENT - ${email} ------------------------`);

                } catch (err) {
                    console.log("send success register mail error", err);
                }


    },
    sendResetLink:async (name, email, encryptEmail, token, companyId) => {
                try {
                    const url = `${appUrl}/reset-password/${encryptEmail}/${token}?reset=true`;
                    const html = `<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"><style>*{box-sizing:border-box}body{margin:0;padding:0}#m_MessageViewBody a{color:inherit;text-decoration:none}p{line-height:inherit}.m_desktop_hide,.m_desktop_hide table{display:none;max-height:0px;overflow:hidden}@media (max-width:700px){.m_desktop_hide table.m_icons-inner{display:inline-block!important}.m_icons-inner{text-align:center}.m_icons-inner td{margin:0 auto}.m_row-content{width:100%!important}.m_mobile_hide{display:none}.m_stack .m_column{width:100%;display:block}.m_mobile_hide{min-height:0;max-height:0;max-width:0;overflow:hidden;font-size:0px}.m_desktop_hide,.m_desktop_hide table{display:table!important;max-height:none!important}}</style></head><body><u></u> <div style="background-color:#f5f5f5;margin:0;padding:0"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_nl-container" role="presentation" style="background-color:#f5f5f5" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-1" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#2c5596;background-image:url('${appUrl}/api/static/logo/heasder-bg.png');background-repeat:no-repeat;color:#000000;background-size:cover;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="m_image_block m_block-1" role="presentation" width="100%"> <tbody><tr> <td class="m_pad"> <div align="left" class="m_alignment" style="line-height:10px"><img src="${appUrl}/api/static/logo/Tpirlogo.png" style="display:block;height:auto;border:0;width:170px;max-width:100%" width="170"></div> </td> </tr> </tbody></table> <table border="0" cellpadding="0" cellspacing="0" class="m_heading_block m_block-2" role="presentation" width="100%"> <tbody><tr> <td class="m_pad" style="padding-top:5px;text-align:center;width:100%"> <h1 style="margin:0;color:#ffffff;direction:ltr;font-family:Poppins,Arial,Helvetica,sans-serif;font-size:30px;font-weight:700;letter-spacing:normal;line-height:150%;text-align:center;margin-top:0;margin-bottom:0">Reset Password</h1> </td> </tr> </tbody></table> <table border="0" cellpadding="0" cellspacing="0" class="m_text_block m_block-3" role="presentation" style="word-break:break-word" width="100%"> <tbody><tr> <td class="m_pad" style="padding-bottom:15px;padding-left:15px;padding-right:15px;padding-top:10px"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#ffffff;line-height:1.5"> <p style="margin:0;font-size:17px;text-align:center"><span style="font-size:16px">Don't worry, Resetting your password is easy</span></p> </div> </div> </td> </tr> </tbody></table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-2" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#ffffff;color:#000000;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;padding-left:30px;padding-right:30px;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody><tr> <td class="m_pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px"> <div style="color:#333954;font-size:15px;font-family:'Lato',Tahoma,Verdana,Segoe,sans-serif;font-weight:400;line-height:180%;text-align:left;direction:ltr;letter-spacing:0px"> <p style="margin:0;margin-bottom:16px">Dear ${name},</p> <p style="margin:0;margin-bottom:16px">We have received a request to reset your password for your TPIR account associated with this email address.</p> <p style="margin:0">To reset your password, please click on the button below.</p> </div> </td> </tr> </tbody></table> <table border="0" cellpadding="0" cellspacing="0" class="m_button_block m_block-2" role="presentation" width="100%"> <tbody><tr> <td class="m_pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center"> <div align="center" class="m_alignment"> <a href="${url}" style="text-decoration:none;display:inline-block;color:#ffffff;background-color:#2c5596;border-radius:4px;width:auto;border-top:0px solid transparent;font-weight:400;border-right:0px solid transparent;border-bottom:0px solid transparent;border-left:0px solid transparent;padding-top:5px;padding-bottom:5px;font-family:Poppins,Arial,Helvetica,sans-serif;font-size:14px;text-align:center;word-break:keep-all"> <span style="padding-left:20px;padding-right:20px;font-size:14px;display:inline-block;letter-spacing:normal"> <span dir="ltr" style="word-break:break-word;line-height:28px">Reset Password</span> </span> </a> </div> </td> </tr> </tbody></table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-3" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#2c5596;color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:10px;padding-bottom:0px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody><tr> <td class="m_pad" style="padding-top:10px;padding-right:10px;padding-left:10px"> <div style="color:#ffffff;font-size:11px;font-family:Poppins,Arial,Helvetica,sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px">  </div> </td> </tr> </tbody></table> <table border="0" cellpadding="20" cellspacing="0" class="m_text_block m_block-2" role="presentation" style="word-break:break-word" width="100%"> <tbody><tr> <td class="m_pad"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#fafafa;line-height:1.5"> <p style="margin:0;font-size:10px;text-align:center"><span style="font-size:10px">  </span><span style="font-size:10px">   </span></p> </div> </div> </td> </tr> </tbody></table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-4" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:5px;padding-bottom:5px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_icons_block m_block-1" role="presentation" width="100%"> <tbody><tr> <td class="m_pad" style="vertical-align:middle;padding-bottom:5px;padding-top:5px;text-align:center;color:#9d9d9d;font-family:inherit;font-size:15px"> <table cellpadding="0" cellspacing="0" role="presentation" width="100%"> <tbody><tr> <td class="m_alignment" style="vertical-align:middle;text-align:center"> </td> </tr> </tbody></table> </td> </tr> </tbody></table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </div> </body></html>`;

                    await sendMail({
                        companyId,
                        to: email,
                        subject: 'Reset Password',
                        html,
                        mailerFunction: 'sendResetLink'
                    })

                    console.log(`-----------------------RESET PASSWORD MAIL SENT - ${email} ------------------------`);
                } catch (err) {
                    console.log("send reset link mail error", err);
                }
    },
    sendReportedMail:async (to, from, subject, date, companyId, userName) => {
                try {
                    let timezone = await db.MetaData.findOne({name:"timeZone",companyId:companyId})
                    if(timezone && timezone.value) timezone = timezone.value
                    else timezone = 'Asia/Kolkata'

                    let headerContent = '';
                    let footerContent = ''
                    let bodyContent = ''
                    let bgColor = ''
                    let logo = ''

                    let customHtml = await db.Template.findOne({name:'Acknowledgment E-Mail', companyId})
                    if(customHtml) {
                        headerContent = customHtml.headerContent;
                        bodyContent = customHtml.bodyContent;
                        footerContent = customHtml.footerContent
                        bgColor = customHtml.bgColor
                        logo = `${appUrl}/api/static/templateLogo/${customHtml.logo}`
                    }
                    else {
                        let defaultHtml = await db.Template.findOne({name:'Acknowledgment E-Mail'})
                        headerContent = defaultHtml.headerContent;
                        bodyContent = defaultHtml.bodyContent;
                        footerContent = defaultHtml.footerContent
                        bgColor = defaultHtml.bgColor
                        logo = `${appUrl}/api/static/templateLogo/${defaultHtml.logo}`
                    }
                    console.log({logo})

                    let html = `<html> <head> <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> <style> * { box-sizing: border-box } body { margin: 0; padding: 0 } #m_MessageViewBody a { color: inherit; text-decoration: none } p { line-height: inherit } .m_desktop_hide, .m_desktop_hide table { display: none; max-height: 0px; overflow: hidden } @media (max-width:700px) { .m_desktop_hide table.m_icons-inner { display: inline-block !important } .m_icons-inner { text-align: center } .m_icons-inner td { margin: 0 auto } .m_row-content { width: 100% !important } .m_mobile_hide { display: none } .m_stack .m_column { width: 100%; display: block } .m_mobile_hide { min-height: 0; max-height: 0; max-width: 0; overflow: hidden; font-size: 0px } .m_desktop_hide, .m_desktop_hide table { display: table !important; max-height: none !important } } </style> </head> <body> <u></u> <div style="background-color:#;margin:0;padding:0"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_nl-container" role="presentation" style="background-color:#f5f5f5" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-1" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:${bgColor};background-image:url('${appUrl}/api/static/logo/heasder-bg.png');background-repeat:no-repeat;color:#000000;background-size:cover;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="m_image_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad"> <div align="left" class="m_alignment" style="line-height:10px"> <img src="${logo}" style="display:block;height:auto;border:0;width:170px;max-width:100%" width="170"> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_heading_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:5px;text-align:center;width:100%;color:white;"> ${headerContent} </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-2" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#ffffff;color:#000000;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;padding-left:30px;padding-right:30px;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px"> ${bodyContent} </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_button_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center"> <div align="center" class="m_alignment"></div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-3" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:${bgColor};color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:10px;padding-bottom:0px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:10px;padding-right:10px;padding-left:10px"> <div style="color:#ffffff;font-size:11px;font-family:Poppins,Arial,Helvetica,sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px"> ${footerContent} </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="20" cellspacing="0" class="m_text_block m_block-2" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#fafafa;line-height:1.5"> <p style="margin:0;font-size:10px;text-align:center"> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-4" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:5px;padding-bottom:5px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_icons_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="vertical-align:middle;padding-bottom:5px;padding-top:5px;text-align:center;color:#9d9d9d;font-family:inherit;font-size:15px"> <table cellpadding="0" cellspacing="0" role="presentation" width="100%"> <tbody> <tr> <td class="m_alignment" style="vertical-align:middle;text-align:center"></td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </div> </body> </html>`;

                    let interpolatedHtml = html
                        .replace(/\${to}/g, to)
                        .replace(/\${from}/g, from)
                        .replace(/\${subject}/g, subject)
                        .replace(/\${date}/g, `${new Date(date).toLocaleString('en-US', { timeZone: timezone, dateStyle: 'long', timeStyle: 'short' })}`)
                        .replace(/\${logo}/g, logo)
                        .replace(/\${userName}/g, userName);
                    if(customHtml && customHtml.logo == null) interpolatedHtml=  interpolatedHtml.replace(/<img\b[^>]*>/gi, '');

                    await sendMail({
                        companyId,
                        to: to,
                        subject: 'Mail Reported Successfully!',
                        html: interpolatedHtml,
                        mailerFunction: 'sendReportedMail'
                    });

                    console.log(`----------------------REPORTED MAIL MESSAGE SENT - ${to} ------------------------`,to);
                } catch (err) {
                    console.log("Error sending reported mail", err);
                }
    },
    sendAlreadyReportedMail:async (name, to, companyId) => {
                try {
                    const html = `<html> <head> <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> <style> * { box-sizing: border-box } body { margin: 0; padding: 0 } #m_MessageViewBody a { color: inherit; text-decoration: none } p { line-height: inherit } .m_desktop_hide, .m_desktop_hide table { display: none; max-height: 0px; overflow: hidden } @media (max-width:700px) { .m_desktop_hide table.m_icons-inner { display: inline-block !important } .m_icons-inner { text-align: center } .m_icons-inner td { margin: 0 auto } .m_row-content { width: 100% !important } .m_mobile_hide { display: none } .m_stack .m_column { width: 100%; display: block } .m_mobile_hide { min-height: 0; max-height: 0; max-width: 0; overflow: hidden; font-size: 0px } .m_desktop_hide, .m_desktop_hide table { display: table !important; max-height: none !important } } </style> </head> <body> <u></u> <div style="background-color:#f5f5f5;margin:0;padding:0"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_nl-container" role="presentation" style="background-color:#f5f5f5" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-1" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#2c5596;background-image:url('${appUrl}/api/static/logo/heasder-bg.png');background-repeat:no-repeat;color:#000000;background-size:cover;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="m_image_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad"> <div align="left" class="m_alignment" style="line-height:10px"> <img src="${appUrl}/api/static/logo/Tpirlogo.png" style="display:block;height:auto;border:0;width:170px;max-width:100%" width="170"> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_heading_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:5px;text-align:center;width:100%"> <h1 style="margin:0;color:#ffffff;direction:ltr;font-family:Poppins,Arial,Helvetica,sans-serif;font-size:30px;font-weight:700;letter-spacing:normal;line-height:150%;text-align:center;margin-top:0;margin-bottom:0">Mail Reported Successfully!</h1> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_text_block m_block-3" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:15px;padding-left:15px;padding-right:15px;padding-top:10px"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#ffffff;line-height:1.5"> <p style="margin:0;font-size:17px;text-align:center"> <span style="font-size:16px">The mail will be reviewed by the SOC team.</span> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-2" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#ffffff;color:#000000;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;padding-left:30px;padding-right:30px;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px"> <div style="color:#333954;font-size:15px;font-family:'Lato',Tahoma,Verdana,Segoe,sans-serif;font-weight:400;line-height:180%;text-align:left;direction:ltr;letter-spacing:0px"> <p style="margin:0;margin-bottom:16px">Dear ${name}, <br> Thank You for reporting a suspicious email. </p> <p style="margin:0;margin-bottom:16px"> <br> The mail has been reported by someone else too. It has been forwarded to SOC Team for further review. Your actions are helping the organization to keep the network and our data safe! <br> <br>Thanks, <br>TPIR Team </p> <p style="margin:0"></p> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_button_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center"> <div align="center" class="m_alignment"></div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-3" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#2c5596;color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:10px;padding-bottom:0px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:10px;padding-right:10px;padding-left:10px"> <div style="color:#ffffff;font-size:11px;font-family:Poppins,Arial,Helvetica,sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px">   </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="20" cellspacing="0" class="m_text_block m_block-2" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#fafafa;line-height:1.5"> <p style="margin:0;font-size:10px;text-align:center"> <span style="font-size:10px">    </span> <span style="font-size:10px">     </span> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-4" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:5px;padding-bottom:5px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_icons_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="vertical-align:middle;padding-bottom:5px;padding-top:5px;text-align:center;color:#9d9d9d;font-family:inherit;font-size:15px"> <table cellpadding="0" cellspacing="0" role="presentation" width="100%"> <tbody> <tr> <td class="m_alignment" style="vertical-align:middle;text-align:center"></td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </div> </body> </html>`;

                    await sendMail({
                        companyId,
                        to,
                        subject: 'Mail Reported Successfully!',
                        html,
                        mailerFunction: 'sendAlreadyReportedMail'
                    })
                    console.log(`----------------------ALREADY REPORTED MAIL MESSAGE SENT - ${to} ------------------------`,to);
                } catch (err) {
                    console.log("Error sending already reported mail",err);
                }
    },
    sendSocMail: async (to, from, subject, date, header, body, eml, socMail, attachment, filename, companyId, mailBody='', isGsuite) => {
        console.log("sendSocMail called", {to, from, subject, date, header, body, eml, socMail, attachment, filename, companyId, mailBody, isGsuite});
            try {
                    let headerContent = '';
                    let footerContent = ''
                    let bodyContent = ''
                    let bgColor = ''
                    let logo = ''
                    const regex = /Content-Type: .*(\r?\n)/i;
                    if (typeof header === "string")
                    header = header.replace(
                    regex,
                    `Content-Type: ${"text/html"}$1`
                  );
                    let customHtml = await db.Template.findOne({name:'SOC Notification E-mail', companyId})

                    let timezone = await db.MetaData.findOne({name:"timeZone",companyId:companyId})
                    if(timezone && timezone.value) timezone = timezone.value
                    else timezone = 'Asia/Kolkata'

                    if(customHtml) {
                        headerContent = customHtml.headerContent;
                        bodyContent = customHtml.bodyContent;
                        footerContent = customHtml.footerContent
                        bgColor = customHtml.bgColor
                        logo = `${appUrl}/api/static/templateLogo/${customHtml.logo}`
                    }
                    else {
                        let defaultHtml = await db.Template.findOne({name:'SOC Notification E-mail'})
                        headerContent = defaultHtml.headerContent;
                        bodyContent = defaultHtml.bodyContent;
                        footerContent = defaultHtml.footerContent
                        bgColor = defaultHtml.bgColor
                        logo = `${appUrl}/api/static/templateLogo/${defaultHtml.logo}`
                    }

                    let html = `<html> <head> <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> <style> * { box-sizing: border-box } body { margin: 0; padding: 0 } #m_MessageViewBody a { color: inherit; text-decoration: none } p { line-height: inherit } .m_desktop_hide, .m_desktop_hide table { display: none; max-height: 0px; overflow: hidden } @media (max-width:700px) { .m_desktop_hide table.m_icons-inner { display: inline-block !important } .m_icons-inner { text-align: center } .m_icons-inner td { margin: 0 auto } .m_row-content { width: 100% !important } .m_mobile_hide { display: none } .m_stack .m_column { width: 100%; display: block } .m_mobile_hide { min-height: 0; max-height: 0; max-width: 0; overflow: hidden; font-size: 0px } .m_desktop_hide, .m_desktop_hide table { display: table !important; max-height: none !important } } </style> </head> <body> <u></u> <div style="background-color:#;margin:0;padding:0"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_nl-container" role="presentation" style="background-color:#f5f5f5" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-1" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:${bgColor};background-image:url('${appUrl}/api/static/logo/heasder-bg.png');background-repeat:no-repeat;color:#000000;background-size:cover;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="m_image_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad"> <div align="left" class="m_alignment" style="line-height:10px"> <img src="${logo}" style="display:block;height:auto;border:0;width:170px;max-width:100%" width="170"> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_heading_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:5px;text-align:center;width:100%;color:white;"> ${headerContent} </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-2" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#ffffff;color:#000000;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;padding-left:30px;padding-right:30px;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px"> ${bodyContent} </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_button_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center"> <div align="center" class="m_alignment"></div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-3" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:${bgColor};color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:10px;padding-bottom:0px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:10px;padding-right:10px;padding-left:10px"> <div style="color:#ffffff;font-size:11px;font-family:Poppins,Arial,Helvetica,sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px"> ${footerContent} </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="20" cellspacing="0" class="m_text_block m_block-2" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#fafafa;line-height:1.5"> <p style="margin:0;font-size:10px;text-align:center"> <span style="font-size:10px">    </span> <span style="font-size:10px">     </span> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-4" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:5px;padding-bottom:5px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_icons_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="vertical-align:middle;padding-bottom:5px;padding-top:5px;text-align:center;color:#9d9d9d;font-family:inherit;font-size:15px"> <table cellpadding="0" cellspacing="0" role="presentation" width="100%"> <tbody> <tr> <td class="m_alignment" style="vertical-align:middle;text-align:center"></td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </div> </body> </html>`;


                    let interpolatedHtml = html
                        .replace(/\${to}/g, to)
                        .replace(/\${from}/g, from)
                        .replace(/\${subject}/g, subject)
                        .replace(/\${date}/g, `${new Date(date).toLocaleString('en-US', { timeZone: timezone, dateStyle: 'long', timeStyle: 'short' })}`)
                        .replace(/\${logo}/g, logo)

                    if(customHtml && customHtml.logo == null) interpolatedHtml = interpolatedHtml.replace(/<img\b[^>]*>/gi, '');

                        let attachment;
                        console.log("isss gsuite is:",isGsuite);
                        if(isGsuite==true){
                            attachment = {
                                filename: 'mail.eml',
                                contentType: 'text/plain',
                                content: mailBody
                            };
                        }
                        else{
                            attachment = {
                                filename: 'mail.eml',
                                contentType: 'text/plain',
                                content: `Header:\n${header}\n\nBody:\n${body}`,
                            };
                        }

                    await sendMail({
                        companyId,
                        to: socMail,
                        subject: 'Suspicious Mail Reported',
                        html: interpolatedHtml,
                        attachments: [ attachment ],
                        mailerFunction: 'sendSocMail'
                    });
                    console.log(`----------------------SOC MAIL MESSAGE SENT - ${socMail} ------------------------`);

                } catch (err) {
                    console.log("Error sending sendSocMail",err);
                }
    },
    sendActionResultMail:async (name, to, from, subject, date, status, hasAttachment, fileName, companyId ) => {
                try {
                    let headerContent = '';
                    let footerContent = ''
                    let bodyContent = ''
                    let bgColor = ''
                    let logo = ''
                    let result =``

                    let customHtml = await db.Template.findOne({name:'Admin Action E-mail', companyId})

                    let timezone = await db.MetaData.findOne({name:"timeZone",companyId:companyId})
                    if(timezone && timezone.value) timezone = timezone.value
                    else timezone = 'Asia/Kolkata'

                    if(customHtml) {
                        headerContent = customHtml.headerContent;
                        bodyContent = customHtml.bodyContent;
                        footerContent = customHtml.footerContent
                        bgColor = customHtml.bgColor
                        logo = `${appUrl}/api/static/templateLogo/${customHtml.logo}`
                    }
                    else {
                        let defaultHtml = await db.Template.findOne({name:'Admin Action E-mail', companyId:null})
                        headerContent = defaultHtml.headerContent;
                        bodyContent = defaultHtml.bodyContent;
                        footerContent = defaultHtml.footerContent
                        bgColor = defaultHtml.bgColor
                        logo = `${appUrl}/api/static/templateLogo/${defaultHtml.logo}`
                    }

                    let html = `<html> <head> <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> <style> * { box-sizing: border-box } body { margin: 0; padding: 0 } #m_MessageViewBody a { color: inherit; text-decoration: none } p { line-height: inherit } .m_desktop_hide, .m_desktop_hide table { display: none; max-height: 0px; overflow: hidden } @media (max-width:700px) { .m_desktop_hide table.m_icons-inner { display: inline-block !important } .m_icons-inner { text-align: center } .m_icons-inner td { margin: 0 auto } .m_row-content { width: 100% !important } .m_mobile_hide { display: none } .m_stack .m_column { width: 100%; display: block } .m_mobile_hide { min-height: 0; max-height: 0; max-width: 0; overflow: hidden; font-size: 0px } .m_desktop_hide, .m_desktop_hide table { display: table !important; max-height: none !important } } </style> </head> <body> <u></u> <div style="background-color:#;margin:0;padding:0"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_nl-container" role="presentation" style="background-color:#f5f5f5" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-1" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:${bgColor};background-image:url('${appUrl}/api/static/logo/heasder-bg.png');background-repeat:no-repeat;color:#000000;background-size:cover;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="m_image_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad"> <div align="left" class="m_alignment" style="line-height:10px"> <img src="${logo}" style="display:block;height:auto;border:0;width:170px;max-width:100%" width="170"> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_heading_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:5px;text-align:center;width:100%;color:white;"> ${headerContent} </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-2" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#ffffff;color:#000000;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;padding-left:30px;padding-right:30px;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px"> ${bodyContent} </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_button_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center"> <div align="center" class="m_alignment"></div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-3" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:${bgColor};color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:10px;padding-bottom:0px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:10px;padding-right:10px;padding-left:10px"> <div style="color:#ffffff;font-size:11px;font-family:Poppins,Arial,Helvetica,sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px"> ${footerContent} </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="20" cellspacing="0" class="m_text_block m_block-2" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#fafafa;line-height:1.5"> <p style="margin:0;font-size:10px;text-align:center"> <span style="font-size:10px">    </span> <span style="font-size:10px">     </span> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-4" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:5px;padding-bottom:5px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_icons_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="vertical-align:middle;padding-bottom:5px;padding-top:5px;text-align:center;color:#9d9d9d;font-family:inherit;font-size:15px"> <table cellpadding="0" cellspacing="0" role="presentation" width="100%"> <tbody> <tr> <td class="m_alignment" style="vertical-align:middle;text-align:center"></td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </div> </body> </html>`;

                    if(status === 'RECOVERED' || status === 'SAFE') result =`<b style="color:green">${status}</b>`;
                    else result =`<b style="color:red">${status}</b>`;


                    let interpolatedHtml = ''
                    if(status == 'SAFE' || status == 'RECOVERED'){
                        interpolatedHtml = html
                            .replace(/\${to}/g, to)
                            .replace(/\${from}/g, from)
                            .replace(/\${subject}/g, subject)
                            .replace(/\${date}/g, `${new Date(date).toLocaleString('en-US', { timeZone: timezone, dateStyle: 'long', timeStyle: 'short' })}`)
                            .replace(/\${logo}/g, logo)
                            .replace(/\${name}/g, name)
                            .replace(/\${status}/g, result)
                            .replace(/\${safeMessage}='([^']*)'/g, '$1')
                            .replace(/\${spamMessage}='([^']*)'/g,'')
                            .replace(/\${threatMessage}='([^']*)'/g,'')
                    }
                    if(status == 'SPAM' || status == 'TRASHED'){
                        interpolatedHtml = html
                            .replace(/\${to}/g, to)
                            .replace(/\${from}/g, from)
                            .replace(/\${subject}/g, subject)
                            .replace(/\${date}/g, `${new Date(date).toLocaleString('en-US', { timeZone: timezone, dateStyle: 'long', timeStyle: 'short' })}`)
                            .replace(/\${logo}/g, logo)
                            .replace(/\${name}/g, name)
                            .replace(/\${status}/g, result)
                            .replace(/\${safeMessage}='([^']*)'/g,'')
                            .replace(/\${spamMessage}='([^']*)'/g, '$1')
                            .replace(/\${threatMessage}='([^']*)'/g,'')
                    }
                    if(status == 'THREAT' || status == 'DELETED'){
                        interpolatedHtml = html
                            .replace(/\${to}/g, to)
                            .replace(/\${from}/g, from)
                            .replace(/\${subject}/g, subject)
                            .replace(/\${date}/g, `${new Date(date).toLocaleString('en-US', { timeZone: timezone, dateStyle: 'long', timeStyle: 'short' })}`)
                            .replace(/\${logo}/g, logo)
                            .replace(/\${name}/g, name)
                            .replace(/\${status}/g, result)
                            .replace(/\${safeMessage}='([^']*)'/g,'')
                            .replace(/\${spamMessage}='([^']*)'/g,'')
                            .replace(/\${threatMessage}='([^']*)'/g, '$1')
                    }
                    if(customHtml && customHtml.logo == null) interpolatedHtml = interpolatedHtml.replace(/<img\b[^>]*>/gi, '');

                    if(hasAttachment){
                        await sendMail({
                            companyId,
                            to,
                            subject: 'Mail Report!',
                            html: interpolatedHtml,
                            attachments: [{
                                filename: fileName,
                                contentType: 'text/plain',
                                path: path.join(appRoot, 'public', 'eml', fileName)
                            }],
                            mailerFunction: 'sendActionResultMail'
                        });
                        console.log(`----------------------REPORTED MAIL MESSAGE SENT - ${to} ------------------------`);
                    }
                    else{
                        await sendMail({
                            companyId,
                            to,
                            subject: 'Mail Report!',
                            html: interpolatedHtml,
                            mailerFunction: 'sendActionResultMail'
                        });
                        console.log(`----------------------REPORTED MAIL MESSAGE SENT - ${to} ------------------------`);
                    }
                } catch (err) {
                    console.log("Error sending action result mail", err);
                }
    },
    sendResultMailToOtherReporters:async (name, to, from, subject, date, status, companyId ) => {
                try {
                    let headerContent = '';
                    let footerContent = ''
                    let bodyContent = ''
                    let bgColor = ''
                    let logo = ''
                    let result =``

                    let customHtml = await db.Template.findOne({name:'Result Notification Other Reporters E-mail', companyId})

                    let timezone = await db.MetaData.findOne({name:"timeZone",companyId:companyId})
                    if(timezone && timezone.value) timezone = timezone.value
                    else timezone = 'Asia/Kolkata'

                    if(customHtml) {
                        headerContent = customHtml.headerContent;
                        bodyContent = customHtml.bodyContent;
                        footerContent = customHtml.footerContent
                        bgColor = customHtml.bgColor
                        logo = `${appUrl}/api/static/templateLogo/${customHtml.logo}`
                    }
                    else {
                        let defaultHtml = await db.Template.findOne({name:'Result Notification Other Reporters E-mail', companyId:null})
                        headerContent = defaultHtml.headerContent;
                        bodyContent = defaultHtml.bodyContent;
                        footerContent = defaultHtml.footerContent
                        bgColor = defaultHtml.bgColor
                        logo = `${appUrl}/api/static/templateLogo/${defaultHtml.logo}`
                    }

                    let html = `<html> <head> <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> <style> * { box-sizing: border-box } body { margin: 0; padding: 0 } #m_MessageViewBody a { color: inherit; text-decoration: none } p { line-height: inherit } .m_desktop_hide, .m_desktop_hide table { display: none; max-height: 0px; overflow: hidden } @media (max-width:700px) { .m_desktop_hide table.m_icons-inner { display: inline-block !important } .m_icons-inner { text-align: center } .m_icons-inner td { margin: 0 auto } .m_row-content { width: 100% !important } .m_mobile_hide { display: none } .m_stack .m_column { width: 100%; display: block } .m_mobile_hide { min-height: 0; max-height: 0; max-width: 0; overflow: hidden; font-size: 0px } .m_desktop_hide, .m_desktop_hide table { display: table !important; max-height: none !important } } </style> </head> <body> <u></u> <div style="background-color:#;margin:0;padding:0"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_nl-container" role="presentation" style="background-color:#f5f5f5" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-1" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:${bgColor};background-image:url('${appUrl}/api/static/logo/heasder-bg.png');background-repeat:no-repeat;color:#000000;background-size:cover;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="m_image_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad"> <div align="left" class="m_alignment" style="line-height:10px"> <img src="${logo}" style="display:block;height:auto;border:0;width:170px;max-width:100%" width="170"> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_heading_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:5px;text-align:center;width:100%;color:white;"> ${headerContent} </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-2" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#ffffff;color:#000000;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;padding-left:30px;padding-right:30px;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px"> ${bodyContent} </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_button_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center"> <div align="center" class="m_alignment"></div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-3" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:${bgColor};color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:10px;padding-bottom:0px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:10px;padding-right:10px;padding-left:10px"> <div style="color:#ffffff;font-size:11px;font-family:Poppins,Arial,Helvetica,sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px"> ${footerContent} </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="20" cellspacing="0" class="m_text_block m_block-2" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#fafafa;line-height:1.5"> <p style="margin:0;font-size:10px;text-align:center"> <span style="font-size:10px">    </span> <span style="font-size:10px">     </span> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-4" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:5px;padding-bottom:5px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_icons_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="vertical-align:middle;padding-bottom:5px;padding-top:5px;text-align:center;color:#9d9d9d;font-family:inherit;font-size:15px"> <table cellpadding="0" cellspacing="0" role="presentation" width="100%"> <tbody> <tr> <td class="m_alignment" style="vertical-align:middle;text-align:center"></td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </div> </body> </html>`;

                    result = status === 'Recovered'? `<b style="color:green">safe</b>`: status === 'Trashed'
                    ? `<b style="color:red">Spam</b>`: status === 'Deleted'
                    ? `<b style="color:red">Threat</b>`: '';

                    let interpolatedHtml = ''
                    if(status == 'RECOVERED' || status == 'Recovered'){
                        interpolatedHtml = html
                            .replace(/\${to}/g, to)
                            .replace(/\${from}/g, from)
                            .replace(/\${subject}/g, subject)
                            .replace(/\${date}/g, `${new Date(date).toLocaleString('en-US', { timeZone: timezone, dateStyle: 'long', timeStyle: 'short' })}`)
                            .replace(/\${logo}/g, logo)
                            .replace(/\${name}/g, name)
                            .replace(/\${status}/g, status)
                            .replace(/\${result}/g, result)
                            .replace(/\${safeMessage}='([^']*)'/g, '$1')
                            .replace(/\${spamMessage}='([^']*)'/g,'')
                            .replace(/\${threatMessage}='([^']*)'/g,'')
                    }
                    if(status == 'TRASHED' || status == 'Trashed'){
                        interpolatedHtml = html
                            .replace(/\${to}/g, to)
                            .replace(/\${from}/g, from)
                            .replace(/\${subject}/g, subject)
                            .replace(/\${date}/g, `${new Date(date).toLocaleString('en-US', { timeZone: timezone, dateStyle: 'long', timeStyle: 'short' })}`)
                            .replace(/\${logo}/g, logo)
                            .replace(/\${name}/g, name)
                            .replace(/\${status}/g, status)
                            .replace(/\${result}/g, result)
                            .replace(/\${safeMessage}='([^']*)'/g, '')
                            .replace(/\${spamMessage}='([^']*)'/g,'$1')
                            .replace(/\${threatMessage}='([^']*)'/g,'')
                    }
                    if(status == 'Deleted' || status == 'DELETED'){
                        interpolatedHtml = html
                            .replace(/\${to}/g, to)
                            .replace(/\${from}/g, from)
                            .replace(/\${subject}/g, subject)
                            .replace(/\${date}/g, `${new Date(date).toLocaleString('en-US', { timeZone: timezone, dateStyle: 'long', timeStyle: 'short' })}`)
                            .replace(/\${logo}/g, logo)
                            .replace(/\${name}/g, name)
                            .replace(/\${status}/g, status)
                            .replace(/\${result}/g, result)
                            .replace(/\${safeMessage}='([^']*)'/g, '')
                            .replace(/\${spamMessage}='([^']*)'/g,'')
                            .replace(/\${threatMessage}='([^']*)'/g,'$1')
                    }
                    if(customHtml && customHtml.logo == null) interpolatedHtml = interpolatedHtml.replace(/<img\b[^>]*>/gi, '');

                    await sendMail({
                        companyId,
                        to,
                        subject: 'Mail Report!',
                        html: interpolatedHtml,
                        mailerFunction: 'sendResultMailToOtherReporters'
                    });
                    console.log(`----------------------REPORTED MAIL MESSAGE SENT - ${to} ------------------------`);

                } catch (err) {
                    console.log("Error sending result mail to other reporters", err);
                }
    },

    sendTestMail: async (testMail, companyId, name ) => {
                try {

                    const html = `<!DOCTYPE html> <html lang="en" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:v="urn:schemas-microsoft-com:vml"> <head> <title></title> <meta content="text/html; charset=utf-8" http-equiv="Content-Type" /> <meta content="width=device-width, initial-scale=1.0" name="viewport" /> <link href="https://fonts.googleapis.com/css?family=Poppins" rel="stylesheet" type="text/css" /> <style> * { box-sizing: border-box; } body { margin: 0; padding: 0; } a[x-apple-data-detectors] { color: inherit !important; text-decoration: inherit !important; } #MessageViewBody a { color: inherit; text-decoration: none; } p { line-height: inherit } .desktop_hide, .desktop_hide table { mso-hide: all; display: none; max-height: 0px; overflow: hidden; } @media (max-width:700px) { .desktop_hide table.icons-inner { display: inline-block !important; } .icons-inner { text-align: center; } .icons-inner td { margin: 0 auto; } .row-content { width: 100% !important; } .mobile_hide { display: none; } .stack .column { width: 100%; display: block; } .mobile_hide { min-height: 0; max-height: 0; max-width: 0; overflow: hidden; font-size: 0px; } .desktop_hide, .desktop_hide table { display: table !important; max-height: none !important; } } </style> </head> <body style="background-color: #f5f5f5; margin: 0; padding: 0; -webkit-text-size-adjust: none; text-size-adjust: none;"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="nl-container" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #f5f5f5;" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row row-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row-content stack" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #2c5596; background-image: url('${appUrl}/api/static/logo/heasder-bg.png'); background-repeat: no-repeat; color: #000000; background-size: cover; border-radius: 0; width: 680px;" width="680"> <tbody> <tr> <td class="column column-1" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; vertical-align: top; padding-top: 0px; padding-bottom: 25px; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="image_block block-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tr> <td class="pad"> <div align="left" class="alignment" style="line-height:10px"> <img src="${appUrl}/api/static/logo/Tpirlogo.png" style="display: block; height: auto; border: 0; width: 170px; max-width: 100%;" width="170" /> </div> </td> </tr> </table> <table border="0" cellpadding="0" cellspacing="0" class="heading_block block-2" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tr> <td class="pad" style="padding-top:5px;text-align:center;width:100%;"> <h1 style="margin: 0; color: #ffffff; direction: ltr; font-family: Poppins, Arial, Helvetica, sans-serif; font-size: 30px; font-weight: 700; letter-spacing: normal; line-height: 150%; text-align: center; margin-top: 0; margin-bottom: 0;">Hi, ${name}!</h1> </td> </tr> </table> <table border="0" cellpadding="0" cellspacing="0" class="text_block block-3" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; word-break: break-word;" width="100%"> <tr> <td class="pad" style="padding-bottom:15px;padding-left:15px;padding-right:15px;padding-top:10px;"> <div style="font-family: sans-serif"> <div class="" style="font-size: 12px; font-family: Poppins, Arial, Helvetica, sans-serif; mso-line-height-alt: 18px; color: #ffffff; line-height: 1.5;"> <p style="margin: 0; font-size: 17px; text-align: center; mso-line-height-alt: 24px;"> <span style="font-size:16px;">We're thrilled to have you on the team</span> </p> </div> </div> </td> </tr> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row row-2" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row-content stack" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #ffffff; color: #000000; border-radius: 0; width: 680px;" width="680"> <tbody> <tr> <td class="column column-1" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-left: 30px; padding-right: 30px; vertical-align: top; padding-top: 0px; padding-bottom: 25px; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="paragraph_block block-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; word-break: break-word;" width="100%"> <tr> <td class="pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px;"> <div style="color:#333954;font-size:15px;font-family:'Lato', Tahoma, Verdana, Segoe, sans-serif;font-weight:400;line-height:180%;text-align:left;direction:ltr;letter-spacing:0px;mso-line-height-alt:27px;"> <p style="margin: 0; margin-bottom: 16px;">Welcome to Threatcop Phishing Incident Response(TPIR), We are thrilled to have you join our community. You have successfully sent a test mail from your SMTP.</p> </div> </td> </tr> </table> <table border="0" cellpadding="0" cellspacing="0" class="button_block block-2" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tr> <td class="pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center;"> </td> </tr> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row row-3" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row-content stack" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #2c5596; color: #000000; width: 680px;" width="680"> <tbody> <tr> <td class="column column-1" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; vertical-align: top; padding-top: 10px; padding-bottom: 0px; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="paragraph_block block-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; word-break: break-word;" width="100%"> <tr> <td class="pad" style="padding-top:10px;padding-right:10px;padding-left:10px;"> <div style="color:#ffffff;font-size:11px;font-family:Poppins, Arial, Helvetica, sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px;mso-line-height-alt:13.2px;">   </div> </td> </tr> </table> <table border="0" cellpadding="20" cellspacing="0" class="text_block block-2" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; word-break: break-word;" width="100%"> <tr> <td class="pad"> <div style="font-family: sans-serif"> <div class="" style="font-size: 12px; font-family: Poppins, Arial, Helvetica, sans-serif; mso-line-height-alt: 18px; color: #fafafa; line-height: 1.5;"> <p style="margin: 0; font-size: 10px; text-align: center; mso-line-height-alt: 15px;">   </p> </div> </div> </td> </tr> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row row-4" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="row-content stack" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; color: #000000; width: 680px;" width="680"> <tbody> <tr> <td class="column column-1" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; vertical-align: top; padding-top: 5px; padding-bottom: 5px; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="icons_block block-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tr> <td class="pad" style="vertical-align: middle; padding-bottom: 5px; padding-top: 5px; text-align: center; color: #9d9d9d; font-family: inherit; font-size: 15px;"> <table cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%"> <tr> <td class="alignment" style="vertical-align: middle; text-align: center;"></td> </tr> </table> </td> </tr> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </body> </html>`;

                    await sendMail({
                        companyId,
                        to: testMail,
                        subject: 'Test Mail!',
                        html: html,
                        mailerFunction: 'sendTestMail'
                    })
                    console.log(`-----------------------TEST MAIL SENT - ${testMail}  ------------------------`);
                } catch (err) {
                    console.log(err)
                }

    },
    sendBroadcastMail:async (from, subject, companyId, to, screenshotFilePath ,mailId) => {
                try {
                    console.log({to})
                    let headerContent = '';
                    let footerContent = ''
                    let bodyContent = ''
                    let bgColor = ''
                    let logo = ''
                    let result = ''

                    let customHtml = await db.Template.findOne({name:'Broadcast Email', companyId})

                    if(customHtml) {
                        headerContent = customHtml.headerContent;
                        bodyContent = customHtml.bodyContent;
                        footerContent = customHtml.footerContent
                        bgColor = customHtml.bgColor
                        logo = `${appUrl}/api/static/templateLogo/${customHtml.logo}`
                    }
                    else {
                        let defaultHtml = await db.Template.findOne({name:'Broadcast Email', companyId:null})
                        headerContent = defaultHtml.headerContent;
                        bodyContent = defaultHtml.bodyContent;
                        footerContent = defaultHtml.footerContent
                        bgColor = defaultHtml.bgColor
                        logo = `${appUrl}/api/static/templateLogo/${defaultHtml.logo}`
                    }

                    let html = `<html> <head> <meta http-equiv="Content-Type" content="text/html; charset=utf-8"> <style> * { box-sizing: border-box } body { margin: 0; padding: 0 } #m_MessageViewBody a { color: inherit; text-decoration: none } p { line-height: inherit } .m_desktop_hide, .m_desktop_hide table { display: none; max-height: 0px; overflow: hidden } @media (max-width:700px) { .m_desktop_hide table.m_icons-inner { display: inline-block !important } .m_icons-inner { text-align: center } .m_icons-inner td { margin: 0 auto } .m_row-content { width: 100% !important } .m_mobile_hide { display: none } .m_stack .m_column { width: 100%; display: block } .m_mobile_hide { min-height: 0; max-height: 0; max-width: 0; overflow: hidden; font-size: 0px } .m_desktop_hide, .m_desktop_hide table { display: table !important; max-height: none !important } } </style> </head> <body> <u></u> <div style="background-color:#;margin:0;padding:0"> <table> <tbody> <tr> <td height="50">&nbsp;</td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_nl-container" role="presentation" style="background-color:#f5f5f5" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-1" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:${bgColor};background-image:url('${appUrl}/api/static/logo/heasder-bg.png');background-repeat:no-repeat;color:#000000;background-size:cover;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="10" cellspacing="0" class="m_image_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad"> <div align="left" class="m_alignment" style="line-height:10px"> <img src="${logo}" style="display:block;height:auto;border:0;width:170px;max-width:100%" width="170"> </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_heading_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:5px;text-align:center;width:100%;color:white;"> ${headerContent} </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-2" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:#ffffff;color:#000000;border-radius:0;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;padding-left:30px;padding-right:30px;vertical-align:top;padding-top:0px;padding-bottom:25px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:25px;padding-right:10px;padding-bottom:10px;padding-left:10px"> ${bodyContent} </td> </tr> </tbody> </table> <table border="0" cellpadding="0" cellspacing="0" class="m_button_block m_block-2" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-bottom:30px;padding-left:10px;padding-right:10px;padding-top:30px;text-align:center"> <div align="center" class="m_alignment"></div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-3" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="background-color:${bgColor};color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:10px;padding-bottom:0px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_paragraph_block m_block-1" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad" style="padding-top:10px;padding-right:10px;padding-left:10px"> <div style="color:#ffffff;font-size:11px;font-family:Poppins,Arial,Helvetica,sans-serif;font-weight:400;line-height:120%;text-align:center;direction:ltr;letter-spacing:0px"> ${footerContent} </div> </td> </tr> </tbody> </table> <table border="0" cellpadding="20" cellspacing="0" class="m_text_block m_block-2" role="presentation" style="word-break:break-word" width="100%"> <tbody> <tr> <td class="m_pad"> <div style="font-family:sans-serif"> <div style="font-size:12px;font-family:Poppins,Arial,Helvetica,sans-serif;color:#fafafa;line-height:1.5"> <p style="margin:0;font-size:10px;text-align:center"> <span style="font-size:10px">    </span> <span style="font-size:10px">     </span> </p> </div> </div> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row m_row-4" role="presentation" width="100%"> <tbody> <tr> <td> <table align="center" border="0" cellpadding="0" cellspacing="0" class="m_row-content m_stack" role="presentation" style="color:#000000;width:680px" width="680"> <tbody> <tr> <td class="m_column m_column-1" style="font-weight:400;text-align:left;vertical-align:top;padding-top:5px;padding-bottom:5px;border-top:0px;border-right:0px;border-bottom:0px;border-left:0px" width="100%"> <table border="0" cellpadding="0" cellspacing="0" class="m_icons_block m_block-1" role="presentation" width="100%"> <tbody> <tr> <td class="m_pad" style="vertical-align:middle;padding-bottom:5px;padding-top:5px;text-align:center;color:#9d9d9d;font-family:inherit;font-size:15px"> <table cellpadding="0" cellspacing="0" role="presentation" width="100%"> <tbody> <tr> <td class="m_alignment" style="vertical-align:middle;text-align:center"></td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </td> </tr> </tbody> </table> </div> </body> </html>`;

                    let interpolatedHtml = ''
                    interpolatedHtml = html
                            .replace(/\${from}/g, from)
                            .replace(/\${subject}/g, subject)
                            .replace(/\${logo}/g, logo)

                    if(customHtml && customHtml.logo == null) interpolatedHtml = interpolatedHtml.replace(/<img\b[^>]*>/gi, '');

                    await sendMail({
                        companyId,
                        to,
                        subject: 'Broadcast Mail!',
                        html: interpolatedHtml,
                        attachments: [
                            {
                                filename: 'email-screenshot.png',
                                path: screenshotFilePath
                            }
                        ],
                        mailerFunction: 'sendBroadcastMail',
                    });
                    console.log(`----------------------BROADCAST MAIL MESSAGE SENT - ${to} ------------------------`);
                } catch (err) {
                    console.log("Error sending broadcast mail", err);
                }
    }
}



