const restrictFeature = (featureCode) => {
  return async (reqOrData, res, next) => {
    const isMiddleware = !!next;
    try {
      const companyId = isMiddleware
      ? reqOrData.companyId || reqOrData.user?.companyId
      : reqOrData.companyId;
      
      if (!companyId) {
        const error = new Error('Company ID is missing');
        if (isMiddleware) return res.status(400).json({ message: error.message });
        throw error;
      }

      const feature = await db.Feature.findOne({ featureCode });
      if (!feature) {
        if (isMiddleware) return next(new RequestError('Feature not found',404)) ;
      }

      const companyFeature = await db.CompanyFeature.findOne({
        companyId,
        featureId: feature._id,
      });
      console.log({companyFeature})
      if (!companyFeature) {
        const error = new RequestError('Feature is restricted');
        if (isMiddleware) throw error
        else throw false
    }

      if (isMiddleware) {
        return next();
      } else {
        return true; 
      }
    } catch (error) {
      if (isMiddleware) {
        return next(error);
      } else {
        throw error;
      }
    }
  };
};

export default restrictFeature