export let permission = function(module, access){
    return async (req, res, next) => {
        try {
            if((req.user.type === 'root')){
                next();
            } else {
                const employeeId = req.user._id;
                const requestedPolicyId = await db.Policy.findOne({ name: `${module}-${access}` });
                const rolesForCurrEmployee = await db.EmployeeRole.findOne({ employeeId });
                let havePermission = false;
                if (rolesForCurrEmployee && rolesForCurrEmployee.roleIds) {
                    let allPoliciesEmployeeHave = [];
                    for (const role of rolesForCurrEmployee.roleIds) {
                        let roleFromDb = await db.Role.findOne({ _id: role });
                        if (roleFromDb && roleFromDb.policyIds) {
                            roleFromDb.policyIds.map(id => allPoliciesEmployeeHave.push(id));
                        }
                    }
                    havePermission = havePermission || allPoliciesEmployeeHave.includes(requestedPolicyId._id.toHexString());
                }
                if(havePermission){
                    return next()
                }
                next(new RequestError(`${module}-Permission denied`, 403))
            }
        } catch (error) {
            next(new RequestError(error));
        }
    }
}; 