import passport from 'passport';

export let jwtStrategy = (req, res, next) => {
  passport.authenticate('jwt', { session: false }, (err, user, info) => {
    if (err && err === 'session-expired') {
      res.clearCookie('logo');
      res.clearCookie('token');
      res.clearCookie('username');
      return next(new RequestError('Session expired', 401));
    }
    if (err && err === 'user') {
      return next(new RequestError('Unauthorized User', 401));
    }
    if (err && typeof err === 'object' && Object.keys(err).length) {
      return next(new RequestError(err, 401));
    }
    if (err) {
      return next(new RequestError('Unauthorized User', 401));
    }
    if (!user) {
      return next(new RequestError('Unauthorized User', 401));
    }

    req.user = user;
    return next();
  })(req, res, next);
};

export let jwtLogoutStrategy = (req, res, next) => {
  passport.authenticate('jwt', { session: false }, (err, user, info) => {
    if (user) {
      req.user = user;
        } else {
            req.user = {};
        }
        next();
    })(req, res, next);
};

export let localStrategy = (req, res, next) => {
    passport.authenticate('User', { session: false }, (err, user) => {
        if (err && err == 'invalid-email') { return next(new RequestError('User email is not valid')) }
        if (err && err == 'invalid') { return next(new RequestError('User account is not verified')) }
        if (err && err == 'inactive') { return next(new RequestError('User account is not active')) }
        if (err && err == 'otp') { return next(new RequestError('Invalid otp')) }
        if (err && err == 'password') { return next(new RequestError('Invalid credentials')) }
        if (err && err == 'attempt') {return next(new RequestError('Too many invalid attempts. Please reset your password.'))}
        if (err && err == 'undefined-password') {return next(new RequestError('User not verified or password not set'))}
        if (err && err.startsWith('attempt:')) { return next(new RequestError('Invalid Credentials (' + err.split(':')[1]+' Attempt(s) Left)'))}
        if (err) { return next(new RequestError(err)) }
        if (!user) { return next(new RequestError('Invalid Credentials')) }
        req.user = user;
        next();
    })(req, res, next);
};

export let checkStrategy = async (req, res, next) => {
    if(!req.user.isLicense) return next(new RequestError("Your license has expired. Please renew it."))  
     const companyId = req.user.companyId   
     const userLimit = await db.MetaData.findOne({
        companyId,
        name: 'userLimit'
    })
     const userLimitMessenger = await db.MetaData.findOne({
         companyId,
         name: 'userLimitMessenger'
     })
   
     const addedUsersCount = await db.User.countDocuments({companyId, deletedAt:null})
     const remainingUserLimit = (parseInt(userLimit?.value) + parseInt(userLimitMessenger?.value)) - addedUsersCount 
     if(remainingUserLimit <= 0) return next(new RequestError("User Limit Exceeded!",429))   
     
    next()
};


export let checkCompanyValidityStrategy = async (req, res, next) => {
    if(!req.user.isLicense) return next(new RequestError("Your license has expired. Please renew it."))  
    next()
};

export let checkLicenseStrategy = async (req, res, next) => {
    if(!req.user.isLicense) return next(new RequestError("Your license has expired. Please renew it."))  
     const companyId = req.user.companyId   
     const userLimit = await db.MetaData.findOne({
        companyId,
        name: 'userLimit'
    })
     const userLimitMessenger = await db.MetaData.findOne({
         companyId,
         name: 'userLimitMessenger'
     })
   
     const addedUsersCount = await db.User.countDocuments({companyId, deletedAt:null})
     const remainingUserLimit = (parseInt(userLimit?.value) + parseInt(userLimitMessenger?.value)) - addedUsersCount 
     if(remainingUserLimit <= 0) return next(new RequestError("User Limit Exceeded!",429))   
     
    next()
};

export let checkTaConnectionStrategy = async (req, res, next) => {
    let company = await db.Company.findOne({_id:req.user.companyId, deletedAt:null})
    if(company.isTacEnabled) return next(new RequestError("Kindly continue this operation on TA!"))
    if(company.isTaConnectionInProgess) return next(new RequestError("TA conncetion in progress please wait!"))
    else next()
};