export let validateBody = (schema) => {
	return (req, res, next) => {
		try {
			console.log(req.method != 'GET' && req.method != 'DELETE' ? req.body : req.query);
			const result = req.method != 'GET' && req.method != 'DELETE' ? schema.validate(req.body) : schema.validate(req.query);
			if (result.error) {
				let errors = [];
				for(let i = 0; i< result.error.details.length; i++){
					errors.push(result.error.details[i].message)
				}
				next(new RequestError(errors, 400))
			}
			next();
		} catch (error) {
			console.log(error);
			next(error)
		}
	}
}