import mongoose from 'mongoose';

const advanceSearchSchema =  new mongoose.Schema({
    from: { type: String },
    to: { type: String, default: '' },
    subject: { type: String, default: '' },
    fromDate: { type: Date },
    toDate: { type: Date },
    filter: { type: String, default: '' },
    isError: { type: Boolean, default: false },
    isErrorMessage: { type: String, default: '' },
    isProcessing: { type: Boolean, default: true },
    syncStartAt: Date,
    syncEndAt: Date,
    domainId: { type: mongoose.Schema.Types.ObjectId, ref: 'Domain' },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    deletedAt: { type: Date, default: null }
}, {
    timestamps: true,
});
advanceSearchSchema.index({ from: 'text', to: 'text', subject: 'text' })
export default mongoose.model('AdvanceSearch', advanceSearchSchema);