import mongoose from 'mongoose';

const advanceSearchEmailSchema =  new mongoose.Schema({
    from: { type: String },
    fromName: { type: String, default: '' },
    to: { type: Array, default: [] },
    cc: { type: Array, default: [] },
    mailRecievedTime: { type: Date },
    body: { type: String },
    subject: { type: String, default: '' },
    messageId: {type: String },
    threadId: String,
    isTrashed: { type: Boolean, default: false},
    userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User' },
    domainId: { type: mongoose.Schema.Types.ObjectId, ref: 'Domain' },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    advanceSearchId: { type: mongoose.Schema.Types.ObjectId, ref: 'AdvanceSearch' },
    deletedAt: { type: Date, default: null }
}, {
    timestamps: true,
});
advanceSearchEmailSchema.index({ from: 'text', to: 'text', subject: 'text'})
export default mongoose.model('AdvanceSearchEmail', advanceSearchEmailSchema);