import mongoose from 'mongoose';

const attachmentSchema = new mongoose.Schema({
    attachmentId: { type: String , require: true},
    fileName: { type: String, trim: true },
    originalName: { type: String, trim: true },
    mimeType: { type: String, trim: true },
    attachmentType: { type: String, trim: true },
    status: { 
        type: String, 
        enum: [
            'NOT SCANNED',
            'IN PROGRESS', 
            'COMPLETED', 
            'FAILED'
        ], 
        default: 'NOT SCANNED' 
    },
    result: { type: mongoose.Schema.Types.Mixed, default: null },
    details: { type: mongoose.Schema.Types.Mixed, default: null },
    scanId: { type: String },
    score : { type: Number },
    reportedMailId: { type: mongoose.Schema.Types.ObjectId, ref: 'ReportedMail' },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    isInfected: {type: Boolean},
    viruses: {type: Array},
}, {
    timestamps: true,
});

export default mongoose.model('Attachment', attachmentSchema);