import mongoose from 'mongoose';

const auditLogSchema = new mongoose.Schema({
	activity: String,
    newData: String,
    oldData: String,
	type: String,
    header: String,
    ip: String,
    firstName: String,
    lastName: String,
    userType: String,
    metadata: { type: Object },
    adminId: { type: mongoose.Schema.Types.ObjectId, ref: 'Admin' },
    employeeId: { type: mongoose.Schema.Types.ObjectId, ref: 'Employee' },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
}, {
	timestamps: true,
});

export default mongoose.model('AuditLog', auditLogSchema);