import mongoose from 'mongoose';

const checkEmailScoreEventSchema = new mongoose.Schema({
	from: { type: String, trim: true, required: true },
    fromName: { type: String, trim: true },
    to: { type: String, trim: true, required: true },
    toName: { type: String, trim: true },
    otherTo: { type: Array },
    subject: { type: String, trim: true },
    score: { type: Number, default: 0 },
    mailId: {type: String, required: true },
    messageId: {type: String, required: true },
    mailRecievedTime: { type: Date },
    mailType: { type: String, trim: true },
    headerDetails: { type: Object },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
}, {
	timestamps: true,
});
checkEmailScoreEventSchema.index({ from: 'text', to: 'text', fromName: 'text', subject: 'text'})
export default mongoose.model('CheckEmailScoreEvent', checkEmailScoreEventSchema);