import mongoose from 'mongoose';

const companySchema = new mongoose.Schema({
	name: String,
	alias: { type: String, required: true, trim: true, unique: true },
	logo: { type: String, default: null },
	licenceKey: { type: String, default: null },
	tacLicenseKey: { type: String, default: null },
	socEmail: { type: [String], default: [] }, 
	isActive: { type: Boolean, default: true },
	deletedAt: { type: Date, default: null },
	isLite: { type: Boolean, default: false },
	broadcastThreshold: { type: Number, default: 0 },
	tacCompanyId: { type: String, default: null },
	isTacEnabled: {type: Boolean, default: false},
	isTaConnectionInProgess: {type: Boolean, default: false},
	isNewCompany: {type: Boolean, default: false},
	industry: { type: String, default: null },
	country: { type: String, default: null },
	tacCompanyId: { type: String, default: null },
	packageAccessKey: { type: String, default: null },
	reportingMethod: { type: String, default: "Default" },
	lastModifiedPackageId: { type: String, default: null},
	packageModifiedLocally: { type: Boolean, default: false},
	whatsappLanguage: { type: String, default: 'English' },
}, {
	timestamps: true,
});

export default mongoose.model('Company', companySchema);