import { lstatSync } from 'fs';
import mongoose from 'mongoose';

const domainSchema =  new mongoose.Schema({
    domainName: { type: String, require: true, trim: true},
    txtRecord: { type: String, trim: true },
    isVerified: { type: Boolean, default: false },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    domainType: { type: String, default: 'Outlook' },
    webhookEmail: { type: String, default: null },
    isCredential: { type: Boolean, default: false },
    credential: { type: Object },
    isSyncingUser: { type: Boolean, default: false },
    isSyncingUserError: { type: Boolean, default: false },
    isSyncingUserErrorFile: { type: String, default: null },
    isScheduledSyncing:{
        isActive: { type: Boolean, default:false },
        daysOfWeek: {type: [String], default: []},
        timeZone: {type: String, default: null},
        hour: {type: String, default: null},
        minute: {type: String, default: null},
        syncType: { type: String, enum: ['All Users', 'Specific Groups'], default: 'All Users' },
        groupIds: {type: [Object], default: []},
        lastSync: { type: Date, default: null },
        isUserSyncMirrored: { type: Boolean, default: false }
    },
    domainTypeForOutlook: {
        type: String,
        enum : ['OFFICE365', 'EXCHANGE', null, 'null'],
        default: 'OFFICE365'
    },
    syncStartAt: Date,
    syncEndAt: Date,
    lastAllUsersSyncAt: { type: Date, default: null },
    webhookAccessKey: { type: String, default: null },
    deletedAt: { type: Date, default: null },
}, {
    timestamps: true,
});

domainSchema.pre('save', function (next) {
    if (this.domainName) {
        this.domainName = this.domainName.toLowerCase();
    }
    next();
});

export default mongoose.model('Domain', domainSchema);
