import mongoose from 'mongoose';

const employeeSchema = new mongoose.Schema({
	firstName: {
		type: String, required: true, trim: true
	},
	lastName: {
		type: String, trim: true
	},
	email: {
		type: String, required: true, trim: true,
		set: (value) => value.toLowerCase() // Automatically set email to lowercase
	},
	password: {
		type: String, trim: true
	},
	phone: {
		type: String, trim: true
	},
	tacIdentityKey: { type: String, default: null },
	isActive: { type: Boolean, default: false },
	isVerify: { type: Boolean, default: false },
	verfKey: { type: String, default: null },
	verfKeyExpiry: { type: Date, default: null },
	companyId: { type: mongoose.Schema.ObjectId, ref: 'Company' },
	attempt: { type: Number, default: 0 },
	security: {
		status: {
			type: Boolean, default: false
		},
		otpType: {
			type: String, default: 'MAIL'
		},
		otp: {
			type: String, default: null
		},
		tOtpKey: {
			type: String, default: null
		},
		otpExpiry: {
			type: Date, default: null
		}
	},	
	loggedIn: {type: Boolean, default: false},
	deletedAt: { type: Date, default: null }
},{
    timestamps: true,
});

employeeSchema.pre('find', function (next) {
	if (this._conditions.email && typeof this._conditions.email === 'string') {
		this._conditions.email = this._conditions.email.toLowerCase();
	}
	next();
});

employeeSchema.pre('findOne', function (next) {
	if (this._conditions.email && typeof this._conditions.email === 'string') {
		this._conditions.email = this._conditions.email.toLowerCase();
	}
	next();
});

employeeSchema.pre('save', function (next) {
	if (this.email && typeof this.email === 'string') {
		this.email = this.email.toLowerCase();
	}
	next();
});

employeeSchema.pre('updateOne', function (next) {
	if (this._update.email && typeof this._update.email === 'string') {
		this._update.email = this._update.email.toLowerCase();
	}
	next();
});

export default mongoose.model('Employee', employeeSchema);
