import mongoose from 'mongoose';

const groupsSchema =  new mongoose.Schema({
    groupName: { type: String, require: true, trim: true },
    tacIdentityKey: { type: String, default: null },
    type:{
        type: String,
        enum : ['Admin', 'Custom'],
        default: "Custom"
    },
    groupId: { type: String, default: null },
    domainId: { type: String, default: null },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    isDefaultGroup: { type: Boolean, default: false},
    emailAccess: { type: Boolean, default: false},
    messengerAccess: { type: Boolean, default: false},
    isSyncingUsers: { type: Boolean, default: false},
    lastSyncId: {type: String, default: null},
    lastSyncIdMismatch: {type: Boolean, default: false},
    isADSynced:   { type: Boolean, default: false },
    deletedAt: { type: Date, default: null }
}, {
    timestamps: true,
});

export default mongoose.model('Group', groupsSchema);