import mongoose from 'mongoose';

const reportedMailSchema = new mongoose.Schema({
    from: { type: String, trim: true,   },
    fromName: { type: String, trim: true },
    to: { type: String, trim: true,   },
    toName: { type: String, trim: true },
    otherTo: { type: Array, default: [] },
    cc: { type: Array, default: [] },
    bcc: { type: Array, default: [] },
    subject: { type: String, trim: true },
    mailId: {type: String,   },
    messageId: {type: String,   },
    internetMessageId: {type: String,  },
    mailRecievedTime: { type: Date },
    mailType: { type: String, trim: true },
    fileName: { type: String, default: null },
    header: { type: String },
    parsedHeader: { type: mongoose.Schema.Types.Mixed, default: null },
    headerDetails: { type: Object },
    body: { type: String },
    syncStartAt: Date,
    syncEndAt: Date,
    spamScore: { type: Number, default: 0 },
    reporters: [
        {
          email: { type: String, trim: true },
          folderId: { type: String, trim: true }
        }
      ],
    senderDomain: { type: String, default: '' },
    senderDomainDeceptive: { type: Boolean, default: false },
    dnsbl: { type: mongoose.Schema.Types.Mixed, default: null },
    isRecoveredEmail: { type: String, default: false },
    isTrashedEmail: { type: String, default: false },
    isDeletedEmail: { type: String, default: false },
    isWhoElseError: { type: String, default: false },
    isWhoElseErrorMessage: { type: String, default: '' },
    isWhoElseProcessing: { type: Boolean, default: false },
    isWhoElseCompleted: { type: Boolean, default: false },
    isMailActionProcessing: { type: String, default: null },
    isSimilarEmailError: { type: String, default: false },
    isSimiliarEmailErrorMessage: { type: String, default: '' },
    isSimiliarEmailProcessing: { type: Boolean, default: false },
    isSimiliarEmailCompleted: { type: Boolean, default: false },
    isMailActionProcessing: { type: String, default: null },
    languages:{type: Array, default:null},
    reporterFolderId: String,
    isLiteEnvReport: { type: Boolean, default: false },
    userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User' },
    domainId: { type: mongoose.Schema.Types.ObjectId, ref: 'Domain' },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    deletedAt: { type: Date, default: null },
    isBroadcastMail:{type: Boolean,default:false},
    // Read/Unread functionality
    isRead: { type: Boolean, default: false },
    readAt: { type: Date, default: null },
    readBy: { type: mongoose.Schema.Types.ObjectId, ref: 'User', default: null },
    // Ignore functionality
    isIgnored: { type: Boolean, default: false },
    ignoredAt: { type: Date, default: null },
    ignoredBy: { type: mongoose.Schema.Types.ObjectId, ref: 'User', default: null }
  }, {
    timestamps: true,
});
reportedMailSchema.index({to: 'text', from: 'text', subject: 'text'});
reportedMailSchema.index({ internetMessageId:'text' });
export default mongoose.model('ReportedMail', reportedMailSchema);