const mongoose = require("mongoose");

const roleSchema = new mongoose.Schema(
  {
    roleName: {type: String, unique: true},
    description: String,
    policyIds: { type: Array, default: [], ref: "Policy" },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: "Company" },
    roleType: {type: String, default: "Custom"}
  },
  {
    timestamps: true,
  }
);

// roleSchema.pre('save', (next) => {
//     if (this._roleName) this._roleName = this._roleName.toLowerCase();
//     next();
// })

export default mongoose.model("Role", roleSchema);
