import mongoose from 'mongoose';

const similiarEmailsSchema = new mongoose.Schema({
    to: String,
    name: String,
    from: String,
    subject: String,
    messageId: String,
    internetMessageId: {type: String, required: true},
    threadId: String,
    isTrashed: { type: Boolean, default: false },
    isDeleted: { type: Boolean, default: false },
    isErrorWhileMoving: { type: Object, default: {
        isError: false,
        message: ''
    }},
    folderId: String,
    userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User' },
    domainId: { type: mongoose.Schema.Types.ObjectId, ref: 'Domain' },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    reportedMailId: { type: mongoose.Schema.Types.ObjectId, ref: 'ReportedMail' },
    deletedAt: { type: Date, default: null }
}, {
    timestamps: true,
});

similiarEmailsSchema.index({ from: 'text', to: 'text' });
similiarEmailsSchema.index({ internetMessageId:'text' });
export default mongoose.model('SimiliarEmail', similiarEmailsSchema);