import mongoose from 'mongoose';

const smtpCredSchema = new mongoose.Schema({
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company', required: true },
    clientId: { type: String, trim: true },
    secretId: { type: String, trim: true },
    tenantId: { type: String, trim: true },
    senderEmail: { type: String, trim: true },
    type: { type: String, enum: ['Oauth', 'Creds'], required: true },
    deletedAt: { type: Date, default: null },
}, {
    timestamps: true,
});

export default mongoose.model('SmtpCred', smtpCredSchema);
