import mongoose from 'mongoose';

const urlSchema = new mongoose.Schema({
    url: { type: String, trim: true },
    deceptiveStatus: { type: String, default: null },
    status: { 
        type: String, 
        enum : [
            'NOT SCANNED',
            'IN PROGRESS', 
            'COMPLETED', 
            'FAILED'
        ], 
        default: 'NOT SCANNED' 
    },
    domain: { type: Object },
    result: { type: mongoose.Schema.Types.Mixed, default: null },
    details: { type: mongoose.Schema.Types.Mixed, default: null },
    scanId: { type: String },
    score: { type: Number },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    reportedMailId: { type: mongoose.Schema.Types.ObjectId, ref: 'ReportedMail' }, 
    whatsappMessageId :  { type: mongoose.Schema.Types.ObjectId, ref: 'whatsapp' }
}, {
    timestamps: true,
});

export default mongoose.model('Url', urlSchema);