import mongoose from 'mongoose';

const userSchema =  new mongoose.Schema({
    name: { type: String, trim: true },
    email: { type: String, trim: true, default: null, lowercase: true,  },
    tacIdentityKey: { type: String, trim: true, default: null },
    userId: { type: String },
    groups: [{
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Group' 
    }],    
    tacGroupId: { type: Number, default: null},
    domainId: { type: mongoose.Schema.Types.ObjectId, ref: 'Domain' },
    subDomainGroupId: { type: mongoose.Schema.Types.ObjectId, ref: 'SubDomainGroup' },
    phoneNumber: { type: String },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    isActive: { type: Boolean, default: false },
    isActiveMessenger: { type: Boolean, default: false },
    emailType: { type: String, default: 'Outlook' },
    isADSynced:   { type: Boolean, default: false },      
    lastAdSeenAt: { type: Date, default: null },
    deletedAt: { type: Date, default: null }
},{
    timestamps: true,
});

userSchema.pre('findOne', function (next) {
  if (this._conditions.email && typeof this._conditions.email === 'string') {
      this._conditions.email = this._conditions.email.toLowerCase();
  }
  next();
});

// Function to sanitize phoneNumber
const sanitizePhoneNumber = (phoneNumber) => {
  return phoneNumber ? phoneNumber.replace(/\D/g, '') : phoneNumber;
};

// Remove special characters from phoneNumber before saving
userSchema.pre('save', function (next) {
  if (this.phoneNumber) {
      this.phoneNumber = sanitizePhoneNumber(this.phoneNumber);
  }
  next();
});

// Ensure phoneNumber is sanitized before updating
const updateMiddleware = function (next) {
  if (this._update && this._update.$set && this._update.$set.phoneNumber) {
      this._update.$set.phoneNumber = sanitizePhoneNumber(this._update.$set.phoneNumber);
  }
  next();
};

userSchema.pre('updateOne', updateMiddleware);
userSchema.pre('updateMany', updateMiddleware);
userSchema.pre('findOneAndUpdate', updateMiddleware);
userSchema.pre('update', updateMiddleware);


userSchema.index(
  { name: 'text', userId: 1 }
);


export default mongoose.model('User', userSchema);