import mongoose from 'mongoose';

const userGroupSchema =  new mongoose.Schema({
    label: { type: String, require: true, trim: true,},
    value: { type: String, required: true, unique: true},
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    domainId: { type: mongoose.Schema.Types.ObjectId, ref: 'Domain' },
    deletedAt: { type: Date, default: null }
}, {
    timestamps: true,
});

export default mongoose.model('UserGroup', userGroupSchema);
