import mongoose from 'mongoose';

const whatsappSchema = new mongoose.Schema({
    from: { type: String, trim: true, required: true },
    phoneNumber: { type: Number, required: true },
    phoneNumberId: { type: String, trim: true, required: true, default: null },
    sender: { type: String, trim: true },
    messageId: { type: String, trim: true, default: null },
    type: { type: String },
    imageId : { type: String, default:null },
    messageId: {type: String, required: true },
    imageUrl: {type: String },
    status: { 
        type: String, 
        enum: [
            'Safe',
            'Unsafe',
            'No Action'
        ], 
        default: 'No Action' 
    },
    result: { type: mongoose.Schema.Types.Mixed, default: null },
    messageSummary: { type: String, trim: true, default: null },
    message: { type: mongoose.Schema.Types.Mixed, default: null },
    fileName: { type: String, trim: true, default:null },
    ticketId: { type: String, default: null},
    userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User' },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },  
    deletedAt: { type: Date, default: null }
}, {
    timestamps: true,
});

whatsappSchema.index({ phoneNumber: 1})

export default mongoose.model('whatsapp', whatsappSchema);