import mongoose from 'mongoose';

const whoElseMetadataSchema = new mongoose.Schema({
    domainId: { type: mongoose.Schema.Types.ObjectId, ref: 'Domain' },
    companyId: { type: mongoose.Schema.Types.ObjectId, ref: 'Company' },
    reportedMailId: { type: mongoose.Schema.Types.ObjectId, ref: 'ReportedMail' },
    isProcessing: { type: Boolean, default: false },
    isCompleted: { type: Boolean, default: false },
    isError: { type: Boolean, default: false },
    errorMessage: { type: String, default: null },
    deletedAt: { type: Date, default: null }
}, {
    timestamps: true,
});

export default mongoose.model('WhoElseMetaData', whoElseMetadataSchema);