import uaParser from 'ua-parser-js';

/* parse data for audit logs */
const validateAndParseData = (req, activity, newData, oldData) => {
    return new Promise((resolve, reject) => {
        try {
            var detail = {};
            detail.user_agent = req.headers['user-agent'];
            detail.systemDetail = uaParser(req.headers['user-agent']);
            detail.ip = req.headers["x-real-ip"] || req.ip;;
        
            resolve({
                activity,
                ip: detail.ip,
                newData: newData,
                oldData: oldData,
                firstName: req.user?.firstName,
                lastName: req.user?.lastName,
                userType: req.user?.type,
                companyId: req.user?.companyId, 
                metadata: JSON.stringify(detail),
                adminId: req?.user?.type=="root"? req.user._id: null,
                employeeId: req?.user?.type=="employee"? req.user._id: null,
            })
        } catch(err){
            reject(err);
        }
    })
}

export default {
    create: (req, activity = '', newName = '', oldName = '') => {
        try {
            return validateAndParseData(req, activity, newName, oldName)
            .then(data => {
                return db.AuditLog.create(data);
            })
            .catch(err => {
                console.error(err);
            })
        } catch(err) {
            console.error();
        }
    }
}