import puppeteer from 'puppeteer';
import mailer from "../mailer";
import s3 from '../Content/upload_file';
import path from 'path';
import fs from 'fs';

let browser;

async function getBrowserInstance() {
 try {
  if (!browser) {
    browser = await puppeteer.launch({
      args: ['--no-sandbox', '--disable-setuid-sandbox'],
      headless: true
    });
  }
  return browser;
 } catch (error) {
   throw error;
 }
}


// async function captureScreenshotToFile(htmlContent, filePath) {
//   try {
//     const browser = await getBrowserInstance();
//     const page = await browser.newPage();
    
//     await page.setContent(htmlContent);

//     await page.screenshot({ path: filePath });

//     await page.close();
    
//     return filePath;
//   } catch (error) {
//     console.error("Error capturing screenshot: ", error);
//     throw error;
//   }
// }

async function captureScreenshotToFile(htmlContent, filePath) {
  let browser; 
  try {
    browser = await puppeteer.launch({
      args: ['--no-sandbox', '--disable-setuid-sandbox'],
      headless: true
    });

    const page = await browser.newPage();
    await page.setContent(htmlContent);
    await page.screenshot({ path: filePath });

    await page.close(); 
    return filePath;
  } catch (error) {
    console.error("Error capturing screenshot: ", error);
    throw error;
  } finally {
    if (browser) {
      await browser.close();
    }
  }
}


export const fetchUsersInBatches = async (batchSize, companyId, lastId = null) => {
 try {
  const query = lastId ? { _id: { $gt: lastId }, companyId, isActive: true, deletedAt: null } : { companyId, isActive: true, deletedAt: null };
  const batch = await db.User.find(query).limit(batchSize).sort({ _id: 1 });
  return batch;
 } catch (error) {
  throw error;
 }
};

export const sendEmailsToBatch = async (reportedMail, userBatch, screenshotFilePath, mailId) => {
  try {
    const reporterEmails = reportedMail.reporters.map(reporter => reporter.email);

  let to = userBatch.map(user => user.email).join(', ');
  let MailAlreadySent = await db.ReportedMail.findOne({ mailId });
  MailAlreadySent = MailAlreadySent.isBroadcastMail;

  if (to && !MailAlreadySent) {
    await db.ReportedMail.updateOne({mailId},{$set:{isBroadcastMail:true}})
    await mailer.sendBroadcastMail(reportedMail.from, reportedMail.subject, reportedMail.companyId, to, screenshotFilePath,mailId);
  }
  } catch (error) {
    throw error;
  }
};

export const sendBroadcastEmails = async (reportedMailIds, companyId) => {
  try{
    const batchSize = 1000;
    const users = await fetchUsersInBatches(batchSize, companyId);
  
    const emailPromises = reportedMailIds.map(async (mailId) => {
      const reportedMail = await s3.fetchReportedMail(mailId);
      if (!reportedMail) {
        console.error(`Reported mail with ID ${mailId} not found`);
        return;
      }
  
      const screenshotFilePath = path.join(appRoot, 'Content', 'reportedMailScreenshots', `screenshot-${mailId}.png`);
  
      console.log('Before capturing screenshot', reportedMail.body);
      await captureScreenshotToFile(reportedMail.body, screenshotFilePath);
  
      let batchPromises = [];
      let lastId = null;
  
      while (true) {
        console.log('Fetching user batches...');
        const userBatch = await fetchUsersInBatches(batchSize, companyId, lastId);
        if (userBatch.length === 0) break;
        batchPromises.push(sendEmailsToBatch(reportedMail, userBatch, screenshotFilePath, reportedMail.mailId));
        lastId = userBatch[userBatch.length - 1]._id;
      }
  
      await Promise.all(batchPromises);
  
      fs.unlink(screenshotFilePath, (err) => {
        if (err) {
          console.error(`Error deleting screenshot file: ${screenshotFilePath}`, err);
        } else {
          console.log(`Deleted screenshot file: ${screenshotFilePath}`);
        }
      });
    });
  
    await Promise.all(emailPromises);
  }

  catch(error){
    await db.ReportedMail.updateOne({mailId: reportedMailIds[0]},{$set:{isBroadcastMail:false}})
    throw error;
  }
  }


export const processBroadcastMailsRequest = async (reportedMailIds, companyId) => {
  return sendBroadcastEmails(reportedMailIds, companyId);
};
